/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.runtime;

import com.agfa.pacs.data.shared.primitives.IntHashSet;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.model.HangingProtocolSnapshotRuntime;
import com.agfa.pacs.impaxee.hanging.model.xml.Condition;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHanging;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHangingScreen;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplaySetCondition;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplaySetConditionRule;
import com.agfa.pacs.impaxee.hanging.model.xml.OrderHanging;
import com.agfa.pacs.impaxee.hanging.model.xml.OrderHangingScreen;
import com.agfa.pacs.impaxee.hanging.model.xml.ReferencedDescriptor;
import com.agfa.pacs.impaxee.hanging.runtime.HangingDefinitionRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.HangingProtocolRuntime;
import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTagDictionary;
import com.agfa.pacs.logging.ALogger;
import com.tiani.util.expressions.OperatorEnum;
import java.util.Arrays;

public class PriorsToBeLoaded {
    private static final PriorLoading load = PriorLoading.valueOf(Config.impaxee.jvision.HANGMAN.onHangupLoadPriors.get());
    private IntHashSet priors2load;
    private IStudyContainer studyContainer;

    public PriorsToBeLoaded(IStudyContainer iStudyContainer) {
        this.studyContainer = iStudyContainer;
        this.priors2load = new IntHashSet(iStudyContainer.getRelevantPriorCount());
    }

    public PriorsToBeLoaded(IStudyContainer iStudyContainer, PriorsToBeLoaded priorsToBeLoaded) {
        this.studyContainer = iStudyContainer;
        this.priors2load = new IntHashSet(priorsToBeLoaded.priors2load.toArray());
    }

    public void addPrior(int n) {
        this.priors2load.add(n);
    }

    public void addPrior(int n, PriorsToBeLoaded priorsToBeLoaded) {
        if (priorsToBeLoaded.priors2load.contains(n)) {
            this.priors2load.add(n);
        }
    }

    public boolean hasPriorsToLoad() {
        if (this.priors2load.size() == 0) {
            return false;
        }
        int[] nArray = this.priors2load.toArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (!this.studyContainer.isPriorLoaded(n3)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void ensurePriorsLoaded() {
        int[] nArray = this.priors2load.toArray();
        Arrays.sort(nArray);
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            this.studyContainer.loadRelevantPrior(n3);
            ++n2;
        }
    }

    public PriorsToBeLoaded detectNotDirectlyNeededPriors(HangingProtocolRuntime hangingProtocolRuntime) {
        if (load == PriorLoading.All) {
            return new PriorsToBeLoaded(this.studyContainer);
        }
        PriorsToBeLoaded priorsToBeLoaded = new PriorsToBeLoaded(this.studyContainer, this);
        this.priors2load.clear();
        HangingDefinitionRuntime hangingDefinitionRuntime = hangingProtocolRuntime.getHangingDefinition();
        HangingProtocolSnapshotRuntime hangingProtocolSnapshotRuntime = hangingDefinitionRuntime.getSnapshot(0);
        this.analyzeSnapshot(hangingProtocolSnapshotRuntime, priorsToBeLoaded);
        if (load == PriorLoading.Mentioned) {
            int n = 1;
            while (n < hangingDefinitionRuntime.getSnapshotCount()) {
                this.analyzeSnapshot(hangingDefinitionRuntime.getSnapshot(n), priorsToBeLoaded);
                ++n;
            }
        }
        priorsToBeLoaded.priors2load.removeAll(this.priors2load.toArray());
        return priorsToBeLoaded;
    }

    private void analyzeSnapshot(HangingProtocolSnapshotRuntime hangingProtocolSnapshotRuntime, PriorsToBeLoaded priorsToBeLoaded) {
        ConditionalHanging conditionalHanging = hangingProtocolSnapshotRuntime.getConditionalHanging();
        OrderHanging orderHanging = hangingProtocolSnapshotRuntime.getOrderHanging();
        if (conditionalHanging != null) {
            int n = PrivateTagDictionary.studyLoadOrderTag;
            for (ConditionalHangingScreen conditionalHangingScreen : conditionalHanging.screens()) {
                for (DisplaySetCondition displaySetCondition2 : conditionalHangingScreen.displaySetConditions()) {
                    for (DisplaySetConditionRule displaySetConditionRule : displaySetCondition2.rules()) {
                        ReferencedDescriptor[] referencedDescriptorArray = displaySetConditionRule.referencedDescriptors();
                        int n2 = referencedDescriptorArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            ReferencedDescriptor referencedDescriptor = referencedDescriptorArray[n3];
                            for (Condition condition : referencedDescriptor.referencedDescriptor().conditions()) {
                                if (condition.getTag() != n) continue;
                                this.collectPriors(condition, priorsToBeLoaded);
                            }
                            ++n3;
                        }
                    }
                }
            }
        } else if (orderHanging != null) {
            int n = 0;
            while (n < orderHanging.orderHangingScreenCount()) {
                OrderHangingScreen orderHangingScreen = orderHanging.getOrderHangingScreen(n);
                if (orderHangingScreen.getOrderHangingScreenStartDSStrategy() == null) {
                    this.addAllPriors(priorsToBeLoaded);
                    return;
                }
                switch (orderHangingScreen.getOrderHangingScreenStartDSStrategy()) {
                    case BASE_STUDY: {
                        break;
                    }
                    case FIRST_PRIOR: {
                        this.addPrior(0, priorsToBeLoaded);
                        break;
                    }
                    case SECOND_PRIOR: {
                        this.addPrior(1, priorsToBeLoaded);
                        break;
                    }
                    case THIRD_PRIOR: {
                        this.addPrior(2, priorsToBeLoaded);
                        break;
                    }
                    case FOURTH_PRIOR: {
                        this.addPrior(3, priorsToBeLoaded);
                        break;
                    }
                    case FIFTH_PRIOR: {
                        this.addPrior(4, priorsToBeLoaded);
                        break;
                    }
                    case OLDEST_PRIOR: {
                        this.addPrior(this.studyContainer.getRelevantPriorCount() - 1, priorsToBeLoaded);
                        break;
                    }
                    case CURRENT_DISPLAY_SET: {
                        this.addAllPriors(priorsToBeLoaded);
                        break;
                    }
                    case CURRENT_STUDY: {
                        int n4 = n - 1;
                        if (n4 < 0) break;
                        this.addPrior(n4, priorsToBeLoaded);
                    }
                }
                ++n;
            }
        } else {
            this.addAllPriors(priorsToBeLoaded);
        }
    }

    private void collectPriors(Condition condition, PriorsToBeLoaded priorsToBeLoaded) {
        if (condition.getOperator() == OperatorEnum.EQUAL) {
            try {
                int n = Integer.parseInt(condition.getValue());
                if (n > 0) {
                    this.addPrior(n - 1, priorsToBeLoaded);
                } else if (n < 0) {
                    this.addPrior(this.studyContainer.getRelevantPriorCount() + n, priorsToBeLoaded);
                }
            }
            catch (NumberFormatException numberFormatException) {
                ALogger.getLogger(PriorsToBeLoaded.class).warn("Could not parse condition", (Throwable)numberFormatException);
            }
        } else {
            this.addAllPriors(priorsToBeLoaded);
        }
    }

    public String toString() {
        int[] nArray = this.priors2load.toArray();
        Arrays.sort(nArray);
        return "Priors:" + Arrays.toString(nArray);
    }

    private void addAllPriors(PriorsToBeLoaded priorsToBeLoaded) {
        this.priors2load.clear();
        this.priors2load.addAll(priorsToBeLoaded.priors2load.toArray());
    }

    public static enum PriorLoading {
        All,
        Mentioned,
        Mentioned_1Snapshot;


        public String toString() {
            return Messages.getString("PriorLoading." + this.name());
        }
    }
}

