/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.runtime;

import com.agfa.pacs.impaxee.hanging.model.IDisplayLayoutDefinition;
import com.agfa.pacs.impaxee.hanging.model.IScreenLayoutDefinition;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplayLayout;
import com.agfa.pacs.impaxee.hanging.model.xml.ScreenLayout;
import com.agfa.pacs.impaxee.hanging.runtime.AbstractLayoutRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.DisplayLayoutRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.LayoutRuntime;
import java.util.ArrayList;
import java.util.List;

public class ScreenLayoutRuntime
extends AbstractLayoutRuntime<ScreenLayout>
implements IScreenLayoutDefinition {
    private List<DisplayLayoutRuntime> displayLayoutRuntimes = new ArrayList<DisplayLayoutRuntime>(4);
    private LayoutRuntime layoutRuntime;
    private Boolean onlyOneStudyEnabled = Boolean.FALSE;

    public ScreenLayoutRuntime() {
        this(new ScreenLayout());
    }

    public ScreenLayoutRuntime(ScreenLayout screenLayout) {
        super(screenLayout);
        if (screenLayout != null) {
            this.onlyOneStudyEnabled = screenLayout.getOnlyOneStudyEnabled();
            DisplayLayout[] displayLayoutArray = screenLayout.displayLayouts();
            int n = displayLayoutArray.length;
            int n2 = 0;
            while (n2 < n) {
                DisplayLayout displayLayout = displayLayoutArray[n2];
                this.addDisplayLayout(new DisplayLayoutRuntime(displayLayout));
                ++n2;
            }
        }
    }

    public ScreenLayoutRuntime(ScreenLayoutRuntime screenLayoutRuntime) {
        super(screenLayoutRuntime.getHorizontalXVertical());
        this.onlyOneStudyEnabled = screenLayoutRuntime.getOnlyOneStudyEnabled();
        DisplayLayoutRuntime[] displayLayoutRuntimeArray = screenLayoutRuntime.displayLayouts();
        int n = displayLayoutRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayLayoutRuntime displayLayoutRuntime = displayLayoutRuntimeArray[n2];
            this.addDisplayLayout(new DisplayLayoutRuntime(displayLayoutRuntime));
            ++n2;
        }
    }

    @Override
    public Boolean getOnlyOneStudyEnabled() {
        return this.onlyOneStudyEnabled;
    }

    @Override
    public void setOnlyOneStudyEnabled(Boolean bl) {
        this.onlyOneStudyEnabled = bl != null ? bl : Boolean.FALSE;
    }

    public final void addDisplayLayout(DisplayLayoutRuntime displayLayoutRuntime) {
        this.displayLayoutRuntimes.add(displayLayoutRuntime);
        displayLayoutRuntime.setScreenLayoutRuntime(this);
    }

    @Override
    public void appendDisplayLayout(IDisplayLayoutDefinition iDisplayLayoutDefinition) {
        if (iDisplayLayoutDefinition instanceof DisplayLayoutRuntime) {
            this.addDisplayLayout((DisplayLayoutRuntime)iDisplayLayoutDefinition);
        }
    }

    @Override
    public IDisplayLayoutDefinition appendDisplayLayout(String string) {
        DisplayLayoutRuntime displayLayoutRuntime = new DisplayLayoutRuntime(new DisplayLayout());
        displayLayoutRuntime.setHorizontalXVertical(string);
        this.addDisplayLayout(displayLayoutRuntime);
        return displayLayoutRuntime;
    }

    @Override
    public void clear() {
        for (DisplayLayoutRuntime displayLayoutRuntime : this.displayLayoutRuntimes) {
            displayLayoutRuntime.setScreenLayoutRuntime(null);
        }
        this.displayLayoutRuntimes.clear();
    }

    @Override
    public int displayLayoutCount() {
        return this.displayLayoutRuntimes.size();
    }

    public DisplayLayoutRuntime[] displayLayouts() {
        return this.displayLayoutRuntimes.toArray(new DisplayLayoutRuntime[this.displayLayoutRuntimes.size()]);
    }

    @Override
    public DisplayLayoutRuntime getDisplayLayout(int n) {
        return this.displayLayoutRuntimes.get(n);
    }

    public int getDisplayLayoutCount() {
        return this.displayLayoutRuntimes.size();
    }

    public LayoutRuntime getLayoutRuntime() {
        return this.layoutRuntime;
    }

    @Override
    public boolean removeDisplayLayout(IDisplayLayoutDefinition iDisplayLayoutDefinition) {
        if (iDisplayLayoutDefinition instanceof DisplayLayoutRuntime) {
            ((DisplayLayoutRuntime)iDisplayLayoutDefinition).setScreenLayoutRuntime(null);
            return this.displayLayoutRuntimes.remove(iDisplayLayoutDefinition);
        }
        return false;
    }

    public void setLayoutRuntime(LayoutRuntime layoutRuntime) {
        this.layoutRuntime = layoutRuntime;
    }
}

