/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.runtime;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.ISinglePatientHanging;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.model.HangingProtocolSnapshotRuntime;
import com.agfa.pacs.impaxee.hanging.model.IHangingProtocolDefinition;
import com.agfa.pacs.impaxee.hanging.model.enums.UsePriors;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingAccessAuthorization;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingApplicability;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingCondition;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingProtocol;
import com.agfa.pacs.impaxee.hanging.runtime.HangingDefinitionRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.HangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.ISnapshotDefinition;
import com.agfa.pacs.impaxee.hanging.runtime.PriorsToBeLoaded;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.impaxee.model.xml.shared.IUniqueNameGenerator;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.URLProviderFactory;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.patinfo.DataSelectionManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;

public abstract class SinglePatientHangingProtocolRuntime
extends HangingProtocolRuntime
implements IHangingProtocolDefinition,
ISinglePatientHanging,
IUniqueNameGenerator {
    private static final ALogger LOGGER = ALogger.getLogger(SinglePatientHangingProtocolRuntime.class);
    private static final Icon ICON = IAIconFactory.DEFAULT_FACTORY.loadIcon("hangingcase.svg");
    protected IStudyContainer baseContainer;
    protected IPatientRepresentation patientRepresentation;
    private String createdBy;
    private HangingAccessAuthorization hangingAccessAuthorization;
    private HangingApplicability hangingApplicability;
    private List<HangingCondition> hangingConditions = new ArrayList<HangingCondition>();
    private HangingProtocol hangingProtocol;
    private String lastModifiedBy;
    private Integer numberOfPriors = 0;
    private ISplitAndSortRuntime splitAndSortRuntime;
    private UsePriors usePriors = UsePriors.NO_PRIORS;
    private String name;
    private Boolean isFitToBreast = Boolean.TRUE;
    protected String actionID;

    private static String createIdentifier(String string, IStudyContainer iStudyContainer) {
        Date date = iStudyContainer.getBaseStudyDate();
        if (date != null) {
            return String.valueOf(string) + " [" + DateTimeUtils.date2ShortString((Date)date) + "]";
        }
        return string;
    }

    protected SinglePatientHangingProtocolRuntime() {
    }

    protected SinglePatientHangingProtocolRuntime(IStudyContainer iStudyContainer, HangingProtocol hangingProtocol, ISplitAndSortRuntime iSplitAndSortRuntime) {
        super(hangingProtocol != null ? SinglePatientHangingProtocolRuntime.createIdentifier(hangingProtocol.getName(), iStudyContainer) : Messages.getString("NO_HANGING"));
        this.splitAndSortRuntime = iSplitAndSortRuntime;
        this.baseContainer = iStudyContainer;
        this.patientRepresentation = iStudyContainer.getPatientRepresentation();
        this.makeVisibleNameUnique();
        if (hangingProtocol != null) {
            this.hangingProtocol = hangingProtocol;
            this.createdBy = hangingProtocol.getCreatedBy();
            this.lastModifiedBy = hangingProtocol.getLastModifiedBy();
            this.usePriors = hangingProtocol.getUsePriors();
            this.numberOfPriors = hangingProtocol.getNumberOfPriors();
            this.name = hangingProtocol.getName();
            this.setPriority(hangingProtocol.getPriority());
            this.setFitToBreast(hangingProtocol.getFitToBreast());
            this.setActionID(hangingProtocol.getActionID());
            this.setHangingDefinition(new HangingDefinitionRuntime(hangingProtocol.getHangingDefinition(), (HangingProtocolRuntime)this));
            this.setHangingApplicability(hangingProtocol.getHangingApplicability() != null ? hangingProtocol.getHangingApplicability().clone() : null);
            this.hangingAccessAuthorization = hangingProtocol.getHangingAccessAuthorization() != null ? hangingProtocol.getHangingAccessAuthorization().clone() : null;
        }
    }

    @Override
    public void ensurePriorsLoaded() {
        int n = this.numberOfPriors;
        boolean bl = false;
        switch (this.usePriors) {
            case NO_PRIORS: {
                return;
            }
            case FIRST_X_PRIORS_WITH_LAST: {
                if (this.baseContainer.getRelevantPriorCount() <= n) break;
                bl = true;
                break;
            }
            case ALL_PRIORS: {
                n = n == 0 ? this.baseContainer.getRelevantPriorCount() : Math.min(this.baseContainer.getRelevantPriorCount(), n);
            }
        }
        PriorsToBeLoaded priorsToBeLoaded = new PriorsToBeLoaded(this.baseContainer);
        int n2 = 0;
        while (n2 < n) {
            priorsToBeLoaded.addPrior(n2);
            ++n2;
        }
        if (bl) {
            priorsToBeLoaded.addPrior(this.baseContainer.getRelevantPriorCount() - 1);
        }
        final PriorsToBeLoaded priorsToBeLoaded2 = priorsToBeLoaded.detectNotDirectlyNeededPriors(this);
        LOGGER.info("Load eagerly priors: {}", (Object)priorsToBeLoaded);
        priorsToBeLoaded.ensurePriorsLoaded();
        if (priorsToBeLoaded2.hasPriorsToLoad()) {
            DataSelectionManager.getInstance().notifyLoadingPriorsInProgress(true);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    LOGGER.info("Load in parallel priors: {}", (Object)priorsToBeLoaded2);
                    priorsToBeLoaded2.ensurePriorsLoaded();
                    DataSelectionManager.getInstance().notifyLoadingPriorsInProgress(false);
                }
            }, "Prior loading thread");
            thread.setPriority(4);
            thread.start();
        }
    }

    public IStudyData getBaseStudyData() {
        return this.baseContainer.getBaseStudy();
    }

    @Override
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Override
    public List<IDisplaySet> getDisplaySets() {
        ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>(32);
        IDisplaySet[] iDisplaySetArray = this.getSplitAndSortRuntime().getDisplaySets();
        int n = iDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDisplaySet iDisplaySet = iDisplaySetArray[n2];
            if (this.baseContainer.hasStudy(iDisplaySet.getOneObject().getParent().getParent().getKey()) && iDisplaySet.isBeingLoaded()) {
                arrayList.add(iDisplaySet);
            }
            ++n2;
        }
        return arrayList;
    }

    @Override
    public HangingAccessAuthorization getHangingAccessAuthorization() {
        return this.hangingAccessAuthorization;
    }

    @Override
    public HangingApplicability getHangingApplicability() {
        return this.hangingApplicability;
    }

    public List<HangingCondition> getHangingConditions() {
        return this.hangingConditions;
    }

    public HangingProtocol getHangingProtocol() {
        return this.hangingProtocol;
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    @Override
    public Integer getNumberOfPriors() {
        return this.numberOfPriors;
    }

    @Override
    public IPatientRepresentation getPatient() {
        return this.getStudyContainer().getPatientRepresentation();
    }

    @Override
    public ISplitAndSortRuntime getSplitAndSortRuntime() {
        return this.splitAndSortRuntime;
    }

    @Override
    public IStudyContainer getStudyContainer() {
        return this.baseContainer;
    }

    @Override
    public UsePriors getUsePriors() {
        return this.usePriors;
    }

    public void hangingChanged() {
        this.setLastModifiedBy(URLProviderFactory.getProvider().getLoginInformation().getUserFullName());
    }

    @Override
    public void setCreatedBy(String string) {
        this.createdBy = string;
    }

    @Override
    public void setHangingAccessAuthorization(HangingAccessAuthorization hangingAccessAuthorization) {
        this.hangingAccessAuthorization = hangingAccessAuthorization;
    }

    @Override
    public final void setHangingApplicability(HangingApplicability hangingApplicability) {
        this.hangingApplicability = hangingApplicability;
        if (hangingApplicability != null) {
            for (HangingCondition hangingCondition2 : hangingApplicability.hangingConditions()) {
                this.hangingConditions.add(hangingCondition2);
            }
        }
    }

    @Override
    public void setLastModifiedBy(String string) {
        this.lastModifiedBy = string;
    }

    @Override
    public void setNumberOfPriors(Integer n) {
        this.numberOfPriors = n;
    }

    public void setSplitAndSortRuntime(ISplitAndSortRuntime iSplitAndSortRuntime) {
        this.splitAndSortRuntime = iSplitAndSortRuntime;
    }

    @Override
    public void setUsePriors(UsePriors usePriors) {
        this.usePriors = usePriors;
    }

    @Override
    public void setName(String string) {
        this.name = string;
        if (this.getStudyContainer() != null) {
            this.setVisibleName(SinglePatientHangingProtocolRuntime.createIdentifier(string, this.getStudyContainer()));
        }
        this.makeVisibleNameUnique();
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void makeVisibleNameUnique() {
        this.setVisibleName(this.createUniqueName(this.getVisibleName()));
    }

    @Override
    public boolean isUniqueSnapshotName(String string, ISnapshotDefinition iSnapshotDefinition) {
        HangingProtocolSnapshotRuntime[] hangingProtocolSnapshotRuntimeArray = ((HangingDefinitionRuntime)this.getHangingDefinition()).snapshots();
        int n = hangingProtocolSnapshotRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            HangingProtocolSnapshotRuntime hangingProtocolSnapshotRuntime = hangingProtocolSnapshotRuntimeArray[n2];
            if (iSnapshotDefinition != hangingProtocolSnapshotRuntime && hangingProtocolSnapshotRuntime != null && string.equals(hangingProtocolSnapshotRuntime.getName())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public Boolean getFitToBreast() {
        return this.isFitToBreast;
    }

    @Override
    public final void setFitToBreast(Boolean bl) {
        this.isFitToBreast = bl;
    }

    @Override
    public String getActionID() {
        return this.actionID;
    }

    @Override
    public void setActionID(String string) {
        this.actionID = string;
    }
}

