/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.keyimages;

import com.agfa.pacs.base.swing.progress.IActivityIndicator;
import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.base.swing.util.ProgressUtil;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAsynchronousActionListener;
import com.agfa.pacs.impaxee.keyimages.IKeyImageExpansion;
import com.agfa.pacs.impaxee.splitsort.runtime.IDisplaySetContainerRuntime;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IStudyData;
import com.tiani.config.LayoutConfig;
import com.tiani.jvision.main.JVision2;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.SwingWorker;

abstract class AbstractKeyImageExpansion<T>
implements IKeyImageExpansion<T> {
    private static final ALogger LOGGER = ALogger.getLogger(AbstractKeyImageExpansion.class);

    AbstractKeyImageExpansion() {
    }

    void toggleExpansionState(T t, Predicate<IDisplaySetContainerRuntime> predicate, PAsynchronousActionListener pAsynchronousActionListener) {
        EventQueue.invokeLater(() -> this.toggleExpansionStateImpl(t, predicate, pAsynchronousActionListener));
    }

    private void toggleExpansionStateImpl(T t, Predicate<IDisplaySetContainerRuntime> predicate, PAsynchronousActionListener pAsynchronousActionListener) {
        block3: {
            try {
                IDisplaySetContainerRuntime iDisplaySetContainerRuntime = this.getDisplaySetContainerRuntime(t);
                if (iDisplaySetContainerRuntime != null) {
                    boolean bl = !predicate.test(iDisplaySetContainerRuntime);
                    CursorUtil.setWaitCursor((Component)JVision2.getMainFrame());
                    IStudyData iStudyData = this.getStudy(t);
                    IActivityIndicator iActivityIndicator = AbstractKeyImageExpansion.createActivityIndicator(() -> !bl && iStudyData.getNumberOfAvailableImages() > iStudyData.getNumberOfLoadedImages());
                    new KeyImageExpansionSwingWorker(t, bl, iDisplaySetContainerRuntime, iActivityIndicator, pAsynchronousActionListener).execute();
                }
            }
            catch (Exception exception) {
                LOGGER.error("Toggling key image expansion state of " + t + " failed", (Throwable)exception);
                if (pAsynchronousActionListener == null) break block3;
                pAsynchronousActionListener.notifyActionFailed();
            }
        }
    }

    abstract IDisplaySetContainerRuntime getDisplaySetContainerRuntime(T var1);

    abstract IStudyData getStudy(T var1);

    private static IActivityIndicator createActivityIndicator(Supplier<Boolean> supplier) {
        IActivityIndicator iActivityIndicator = null;
        try {
            if (supplier.get().booleanValue()) {
                iActivityIndicator = ProgressUtil.createActivityIndicator((Component)JVision2.getMainFrame(), (int)LayoutConfig.getInstance().getScreenColumns(), (boolean)true, (IActivityIndicator.DisplayMode)IActivityIndicator.DisplayMode.LAYER);
                iActivityIndicator.setText(Messages.getString("Activity.LoadStudy.Text"));
                iActivityIndicator.show();
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Creating activity indicator failed", (Throwable)exception);
        }
        return iActivityIndicator;
    }

    abstract void setCollapsed(T var1, boolean var2, IDisplaySetContainerRuntime var3);

    private class KeyImageExpansionSwingWorker
    extends SwingWorker<Void, Void> {
        private final T data;
        private final boolean collapse;
        private final IDisplaySetContainerRuntime dscRuntime;
        private final IActivityIndicator ai;
        private final PAsynchronousActionListener listener;

        KeyImageExpansionSwingWorker(T t, boolean bl, IDisplaySetContainerRuntime iDisplaySetContainerRuntime, IActivityIndicator iActivityIndicator, PAsynchronousActionListener pAsynchronousActionListener) {
            this.data = t;
            this.collapse = bl;
            this.dscRuntime = iDisplaySetContainerRuntime;
            this.ai = iActivityIndicator;
            this.listener = pAsynchronousActionListener;
        }

        @Override
        protected Void doInBackground() {
            block3: {
                try {
                    AbstractKeyImageExpansion.this.setCollapsed(this.data, this.collapse, this.dscRuntime);
                    if (this.listener != null) {
                        this.listener.notifyActionFinished();
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Toggling key image expansion state of " + this.data + " failed", (Throwable)exception);
                    if (this.listener == null) break block3;
                    this.listener.notifyActionFailed();
                }
            }
            return null;
        }

        @Override
        protected void done() {
            if (this.ai != null) {
                this.ai.close();
            }
            CursorUtil.resetWaitCursor((Component)JVision2.getMainFrame());
        }
    }
}

