/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.keyimages;

import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.data.fetcher.IStore;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.model.RelativeInteger;
import com.agfa.pacs.impaxee.hanging.model.enums.PrimaryDimension;
import com.agfa.pacs.impaxee.keyimages.IKeyImageInfo;
import com.agfa.pacs.impaxee.keyimages.IKeyImageSetter;
import com.agfa.pacs.impaxee.keyimages.KeyImageInfo;
import com.agfa.pacs.impaxee.keyimages.KeyImageType;
import com.agfa.pacs.impaxee.keyimages.KeyObjectSaveResult;
import com.agfa.pacs.impaxee.utils.ConcurrentMultiValueHashMap;
import com.agfa.pacs.impaxee.utils.IConcurrentMultiValueMap;
import com.agfa.pacs.impaxee.xds.source.IXDSDocumentSource;
import com.agfa.pacs.impaxee.xds.source.XDSDocumentSourceException;
import com.agfa.pacs.impaxee.xds.source.XDSDocumentSourceFactory;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedImage;
import com.agfa.pacs.listtext.lta.util.referencedobject.KeyObjectAttributes;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObjectUtilities;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObject;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import com.tiani.util.message.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class KeyImageManager {
    private static ALogger log = ALogger.getLogger(KeyImageManager.class);
    private static final IStore STORE_MANAGER = DataManager.getInstance().getDataStore();
    private final IConcurrentMultiValueMap<KeyImageType, ReferringObject> referringObjects;
    private final Set<IFrameObjectData> keyImages;
    private boolean isInEditMode;
    private IStudyInfo study;
    private IConcurrentMultiValueMap<ReferringObject, IFrameObjectData> autoGeneratedKeyImagesMap;

    public KeyImageManager(IStudyInfo iStudyInfo) {
        this.study = iStudyInfo;
        this.referringObjects = new ConcurrentMultiValueHashMap<KeyImageType, ReferringObject>();
        this.keyImages = Collections.synchronizedSet(new HashSet());
        this.autoGeneratedKeyImagesMap = new ConcurrentMultiValueHashMap<ReferringObject, IFrameObjectData>();
    }

    public static KeyImageManager ofFrame(IFrameObjectData iFrameObjectData) {
        return iFrameObjectData.getParent().getParent().getKeyImageManager();
    }

    public static KeyImageManager ofDisplaySet(IDisplaySet iDisplaySet) {
        return iDisplaySet.getStudy().getKeyImageManager();
    }

    public boolean hasKeyImages() {
        return !this.getKeyImages().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasSavedKeyImages() {
        Set<IFrameObjectData> set = this.keyImages;
        synchronized (set) {
            IFrameObjectData iFrameObjectData;
            Iterator<IFrameObjectData> iterator = this.keyImages.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(iFrameObjectData = iterator.next()).getKeyImageInfo().isInitiallyMarked());
            return true;
        }
    }

    public List<IFrameObjectData> getKeyImages() {
        ArrayList<IFrameObjectData> arrayList = new ArrayList<IFrameObjectData>();
        HashSet<IFrameObjectData> hashSet = new HashSet<IFrameObjectData>(this.keyImages);
        for (IFrameObjectData iFrameObjectData : hashSet) {
            IKeyImageInfo iKeyImageInfo = iFrameObjectData.getKeyImageInfo();
            if (iKeyImageInfo == null || !iKeyImageInfo.isMarked()) continue;
            arrayList.add(iFrameObjectData);
        }
        return arrayList;
    }

    public synchronized List<IFrameObjectData> getKeyImages(KeyImageType keyImageType) {
        ArrayList<IFrameObjectData> arrayList = new ArrayList<IFrameObjectData>();
        for (IFrameObjectData iFrameObjectData : this.keyImages) {
            IKeyImageInfo iKeyImageInfo = iFrameObjectData.getKeyImageInfo();
            if (iKeyImageInfo == null || !iKeyImageInfo.isMarked(keyImageType)) continue;
            arrayList.add(iFrameObjectData);
        }
        return arrayList;
    }

    private static int makeAbsolute(RelativeInteger relativeInteger, int n) {
        if (relativeInteger == null) {
            return 0;
        }
        return relativeInteger.makeAbsolute(n);
    }

    public static Integer getFirstMarked(IDisplaySet iDisplaySet, RelativeInteger relativeInteger, PrimaryDimension primaryDimension) {
        ArrayList<IFrameObjectData> arrayList;
        boolean bl = primaryDimension == null || primaryDimension == PrimaryDimension.DEFAULT ? iDisplaySet.isPrimaryNavigationInSpace() : primaryDimension == PrimaryDimension.SPACE;
        IFrameObjectData[][] iFrameObjectDataArray = iDisplaySet.getFrames();
        if (bl) {
            arrayList = Arrays.asList(iFrameObjectDataArray[KeyImageManager.makeAbsolute(relativeInteger, iFrameObjectDataArray.length)]);
        } else {
            arrayList = new ArrayList(iFrameObjectDataArray.length);
            int n = KeyImageManager.makeAbsolute(relativeInteger, iFrameObjectDataArray[0].length);
            IFrameObjectData[][] iFrameObjectDataArray2 = iFrameObjectDataArray;
            int n2 = iFrameObjectDataArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IFrameObjectData[] iFrameObjectDataArray3 = iFrameObjectDataArray2[n3];
                if (n < iFrameObjectDataArray3.length) {
                    arrayList.add(iFrameObjectDataArray3[n]);
                }
                ++n3;
            }
        }
        return KeyImageManager.getFirstMarked(arrayList);
    }

    public static Integer getFirstMarked(Iterable<IFrameObjectData> iterable) {
        if (iterable != null) {
            int n = 0;
            for (IFrameObjectData iFrameObjectData : iterable) {
                if (iFrameObjectData.getKeyImageInfo().isMarked()) {
                    return n;
                }
                ++n;
            }
        }
        return null;
    }

    public static Integer getLastMarked(List<IFrameObjectData> list) {
        if (list != null) {
            int n = list.size() - 1;
            while (n >= 0) {
                if (list.get(n).getKeyImageInfo().isMarked()) {
                    return n;
                }
                --n;
            }
        }
        return null;
    }

    public boolean hasUnsavedKeyImages() {
        return this.getModifiedTypes().length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyImageType[] getModifiedTypes() {
        EnumSet<KeyImageType> enumSet = EnumSet.noneOf(KeyImageType.class);
        Set<IFrameObjectData> set = this.keyImages;
        synchronized (set) {
            for (IFrameObjectData iFrameObjectData : this.keyImages) {
                KeyImageType[] keyImageTypeArray = KeyImageType.values();
                int n = keyImageTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    KeyImageType keyImageType = keyImageTypeArray[n2];
                    if (iFrameObjectData.getKeyImageInfo().isModified(keyImageType)) {
                        enumSet.add(keyImageType);
                    }
                    ++n2;
                }
            }
        }
        return enumSet.toArray(new KeyImageType[enumSet.size()]);
    }

    public void markInitially(ReferringObject referringObject, IFrameObjectData iFrameObjectData, KeyImageType keyImageType) {
        IKeyImageInfo iKeyImageInfo = iFrameObjectData.getKeyImageInfo();
        if (!(iFrameObjectData instanceof IKeyImageSetter)) {
            throw new UnsupportedOperationException();
        }
        if (!(iKeyImageInfo instanceof KeyImageInfo)) {
            iKeyImageInfo = new KeyImageInfo();
        }
        ((KeyImageInfo)iKeyImageInfo).markInitially(keyImageType);
        ((IKeyImageSetter)((Object)iFrameObjectData)).setKeyImageInfo(iKeyImageInfo);
        this.keyImages.add(iFrameObjectData);
        this.getReferringObjects(keyImageType).add(referringObject);
        if (KeyImageType.AutoGeneratedBySession == keyImageType) {
            this.autoGeneratedKeyImagesMap.getOrCreate(referringObject).add(iFrameObjectData);
        }
    }

    public void mark(IFrameObjectData iFrameObjectData, KeyImageType keyImageType) {
        if (!this.isEditable() || !(iFrameObjectData instanceof IKeyImageSetter)) {
            return;
        }
        IKeyImageInfo iKeyImageInfo = iFrameObjectData.getKeyImageInfo();
        if (!(iKeyImageInfo instanceof KeyImageInfo)) {
            iKeyImageInfo = new KeyImageInfo();
        }
        this.keyImages.add(iFrameObjectData);
        ((KeyImageInfo)iKeyImageInfo).mark(keyImageType);
        ((IKeyImageSetter)((Object)iFrameObjectData)).setKeyImageInfo(iKeyImageInfo);
    }

    public void unmark(IFrameObjectData iFrameObjectData, KeyImageType keyImageType) {
        if (!this.isEditable()) {
            return;
        }
        this.unmarkEvenIfNotEditable(iFrameObjectData, keyImageType, false);
    }

    private void unmarkEvenIfNotEditable(IFrameObjectData iFrameObjectData, KeyImageType keyImageType, boolean bl) {
        if (!(iFrameObjectData instanceof IKeyImageSetter)) {
            return;
        }
        IKeyImageInfo iKeyImageInfo = iFrameObjectData.getKeyImageInfo();
        if (!(iKeyImageInfo instanceof KeyImageInfo)) {
            iKeyImageInfo = new KeyImageInfo();
        }
        KeyImageInfo keyImageInfo = (KeyImageInfo)iKeyImageInfo;
        keyImageInfo.unmark(keyImageType);
        if (bl) {
            keyImageInfo.resetModified(keyImageType);
        }
        if (!iKeyImageInfo.isMarked() && !iKeyImageInfo.isInitiallyMarked()) {
            this.keyImages.remove(iFrameObjectData);
        }
        ((IKeyImageSetter)((Object)iFrameObjectData)).setKeyImageInfo(iKeyImageInfo);
    }

    public boolean isInEditMode() {
        return this.isInEditMode;
    }

    public void startEditMode() {
        this.isInEditMode = true;
    }

    private void stopEditMode() {
        this.isInEditMode = false;
    }

    private boolean isEditable() {
        if (this.isInEditMode()) {
            return true;
        }
        if (!this.hasKeyImages() || Message.yesNo(Messages.getString("KeyImageManager.StartEditMode.Query")) == 0) {
            this.startEditMode();
            return true;
        }
        return false;
    }

    public boolean save(KeyImageType keyImageType, boolean bl) {
        return this.save(new ArrayList<IFrameObjectData>(this.keyImages), keyImageType, bl);
    }

    public Iterable<KeyObjectAttributes> saveKeyImagesAutomatically() {
        return this.save(new ArrayList<IFrameObjectData>(this.keyImages), KeyImageType.AutoGeneratedBySession, false, true).getKeyObjectAttributes();
    }

    private boolean save(List<IFrameObjectData> list, KeyImageType keyImageType, boolean bl) {
        return this.save(list, keyImageType, bl, false).isSaved();
    }

    private KeyObjectSaveResult save(List<IFrameObjectData> list, KeyImageType keyImageType, boolean bl, boolean bl2) {
        Collection<Object> collection;
        Object object;
        boolean bl3;
        IKeyImageInfo iKeyImageInfo;
        ArrayList<IFrameObjectData> arrayList = new ArrayList<IFrameObjectData>(list.size());
        ArrayList<KeyImageInfo> arrayList2 = new ArrayList<KeyImageInfo>(list.size());
        for (IFrameObjectData object22 : list) {
            iKeyImageInfo = object22.getKeyImageInfo();
            if (iKeyImageInfo.isModified(keyImageType)) {
                arrayList2.add((KeyImageInfo)iKeyImageInfo);
            }
            if (!keyImageType.isModifiable()) continue;
            if (iKeyImageInfo.isMarked(keyImageType)) {
                arrayList.add(object22);
            }
            if (!iKeyImageInfo.isInitiallyMarked(keyImageType)) continue;
            arrayList2.add((KeyImageInfo)iKeyImageInfo);
        }
        Set<ReferringObject> set = this.getReferringObjects(keyImageType);
        ArrayList<ReferringObject> arrayList3 = new ArrayList<ReferringObject>(set);
        iKeyImageInfo = null;
        HashMap<KeyObjectAttributes, List> hashMap = null;
        if (!arrayList.isEmpty()) {
            bl3 = false;
            if (keyImageType == KeyImageType.ForXDS) {
                iKeyImageInfo = this.compileKeyObject(KeyImageType.ForXDS, new ArrayList<IFrameObjectData>(arrayList), null);
                IXDSDocumentSource n = XDSDocumentSourceFactory.getInstance();
                try {
                    bl3 = n.provideAndRegister(iKeyImageInfo.toDataset());
                }
                catch (XDSDocumentSourceException iDataInfoSource) {
                    log.error("Exception during XDS provide and register", (Throwable)iDataInfoSource);
                }
            } else {
                int list2 = this.countArchivesOfFrameObjectDatas(arrayList);
                if (list2 == 1) {
                    iKeyImageInfo = this.compileKeyObject(keyImageType, new ArrayList<IFrameObjectData>(arrayList), null);
                    IDataInfoSource n = ((IFrameObjectData)arrayList.get(0)).getMainFrame().getQueryObject().getSource();
                    bl3 = STORE_MANAGER.store(n, iKeyImageInfo.toDataset());
                } else {
                    Object object2;
                    HashMap<Object, KeyObjectAttributes> object6 = new HashMap<Object, KeyObjectAttributes>(list2);
                    for (IFrameObjectData iFrameObjectData : arrayList) {
                        object2 = iFrameObjectData.getQueryObject().getSource().getSourceAET();
                        object = (List)object6.get(object2);
                        if (object == null) {
                            object = new ArrayList(arrayList.size() / list2);
                            object6.put(object2, (KeyObjectAttributes)object);
                        }
                        object.add(iFrameObjectData);
                    }
                    bl3 = true;
                    hashMap = new HashMap<KeyObjectAttributes, List>(list2);
                    for (List list3 : object6.values()) {
                        object2 = ((IFrameObjectData)list3.get(0)).getQueryObject().getSource();
                        object = this.compileKeyObject(keyImageType, list3, (IDataInfoSource)object2);
                        bl3 &= STORE_MANAGER.store((IDataInfoSource)object2, object.toDataset());
                        hashMap.put((KeyObjectAttributes)object, list3);
                    }
                }
            }
            if (!bl3) {
                if (bl) {
                    if (!ComponentFactory.instance.showYesNoDialog(Messages.getString("KeyImageManager.storeErrorTitle"), Messages.getString("KeyImageManager.storeErrorMessage"), null)) {
                        return KeyObjectSaveResult.FAILED;
                    }
                } else {
                    return KeyObjectSaveResult.FAILED;
                }
            }
        }
        bl3 = true;
        if (!arrayList3.isEmpty()) {
            try {
                List exception = ReferencedObjectUtilities.extractReferencedObjects((Collection)arrayList3);
                int n = this.countArchivesOfObjectInfos(exception);
                if (n == 1) {
                    bl3 = STORE_MANAGER.deleteInstances(exception);
                } else {
                    HashMap<KeyObjectAttributes, ArrayList<Object>> hashMap2 = new HashMap<KeyObjectAttributes, ArrayList<Object>>(n);
                    for (Object object3 : exception) {
                        object = object3.getSource().getSourceAET();
                        ArrayList<Object> arrayList4 = (ArrayList<Object>)hashMap2.get(object);
                        if (arrayList4 == null) {
                            arrayList4 = new ArrayList<Object>(exception.size() / n);
                            hashMap2.put((KeyObjectAttributes)object, arrayList4);
                        }
                        arrayList4.add(object3);
                    }
                    for (Object object3 : hashMap2.values()) {
                        bl3 &= STORE_MANAGER.deleteInstances((List<IObjectInfo>)object3);
                    }
                }
                if (bl3) {
                    set.removeAll(arrayList3);
                }
            }
            catch (Exception keyImageInfo) {
                log.error("Deletion of key object(s) failed.", (Throwable)keyImageInfo);
                bl3 = false;
            }
        }
        for (KeyImageInfo collection2 : arrayList2) {
            collection2.resetModified(keyImageType);
        }
        if (iKeyImageInfo != null) {
            this.markFrameAsKeyImage(set, arrayList, keyImageType, (KeyObjectAttributes)iKeyImageInfo);
            collection = Collections.singletonList(iKeyImageInfo);
        } else if (hashMap != null) {
            for (Map.Entry entry : hashMap.entrySet()) {
                this.markFrameAsKeyImage(set, (List)entry.getValue(), keyImageType, (KeyObjectAttributes)entry.getKey());
            }
            collection = hashMap.keySet();
        } else {
            collection = Collections.emptyList();
        }
        this.stopEditMode();
        return new KeyObjectSaveResult(collection, bl3);
    }

    private void markFrameAsKeyImage(Set<ReferringObject> set, List<IFrameObjectData> list, KeyImageType keyImageType, KeyObjectAttributes keyObjectAttributes) {
        ReferringObject referringObject = new ReferringObject(keyImageType.getType(), keyObjectAttributes.toObjectInfo());
        set.add(referringObject);
        for (IFrameObjectData iFrameObjectData : list) {
            this.markInitially(referringObject, iFrameObjectData, keyImageType);
        }
    }

    private int countArchivesOfObjectInfos(List<IObjectInfo> list) {
        HashSet<String> hashSet = new HashSet<String>(3);
        for (IObjectInfo iObjectInfo : list) {
            hashSet.add(iObjectInfo.getSource().getSourceAET());
        }
        return hashSet.size();
    }

    private int countArchivesOfFrameObjectDatas(List<IFrameObjectData> list) {
        HashSet<String> hashSet = new HashSet<String>(3);
        for (IFrameObjectData iFrameObjectData : list) {
            hashSet.add(iFrameObjectData.getQueryObject().getSource().getSourceAET());
        }
        return hashSet.size();
    }

    public static boolean storeKeyObjects(IStudyData iStudyData, KeyImageType keyImageType, Set<ReferencedImage> set, IDataInfoSource iDataInfoSource) {
        ISeriesData iSeriesData22;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (ISeriesData iSeriesData22 : iStudyData.getSeries()) {
            for (IImageObjectData object : iSeriesData22.getObjects()) {
                hashMap.put(object.getSOPInstanceUID(), iSeriesData22.getSeriesInstanceUID());
            }
        }
        iSeriesData22 = new KeyObjectAttributes(keyImageType.getType(), (IStudyInfo)iStudyData.getQueryObject());
        for (ReferencedImage referencedImage : set) {
            Object object = referencedImage.getFrames();
            iSeriesData22.insertReference(referencedImage.getSOPClassUID(), referencedImage.getSOPInstanceUID(), (String)hashMap.get(referencedImage.getSOPInstanceUID()), iStudyData.getStudyInstanceUID(), (int[])object);
        }
        if (iDataInfoSource == null) {
            iDataInfoSource = iStudyData.getQueryObject().getSource();
        }
        return STORE_MANAGER.store(iDataInfoSource, iSeriesData22.toDataset());
    }

    private KeyObjectAttributes compileKeyObject(KeyImageType keyImageType, List<IFrameObjectData> list, IDataInfoSource iDataInfoSource) {
        Object object;
        KeyObjectAttributes keyObjectAttributes = new KeyObjectAttributes(keyImageType.getType(), this.study, iDataInfoSource);
        HashMap<IImageObjectData, Object> hashMap = new HashMap<IImageObjectData, Object>(list.size());
        for (IFrameObjectData object2 : list) {
            if (object2.getMainFrame().getFrameCount() == 1) {
                hashMap.put(object2.getMainFrame(), null);
                continue;
            }
            object = (BitSet)hashMap.get(object2.getMainFrame());
            if (object == null) {
                object = new BitSet();
                hashMap.put(object2.getMainFrame(), object);
            }
            ((BitSet)object).set(object2.getFrameNumber() + 1);
        }
        if (!hashMap.isEmpty()) {
            for (Map.Entry entry : hashMap.entrySet()) {
                object = (IImageObjectData)entry.getKey();
                BitSet bitSet = (BitSet)entry.getValue();
                int[] nArray = null;
                if (bitSet != null) {
                    nArray = new int[bitSet.cardinality()];
                    int n = 0;
                    while (n < nArray.length) {
                        nArray[n] = bitSet.nextSetBit(n == 0 ? 0 : nArray[n - 1] + 1);
                        ++n;
                    }
                }
                keyObjectAttributes.insertReference(object.getSOPClassUID(), object.getSOPInstanceUID(), object.getParent().getSeriesInstanceUID(), object.getParent().getParent().getStudyInstanceUID(), nArray);
            }
        }
        if (KeyImageType.AutoGeneratedBySession == keyImageType) {
            keyObjectAttributes.setAutoGenerated(true);
        }
        return keyObjectAttributes;
    }

    private Set<ReferringObject> getReferringObjects(KeyImageType keyImageType) {
        return this.referringObjects.getOrCreate(keyImageType);
    }

    public Collection<ReferringObject> getAllReferringObjects() {
        return this.referringObjects.values();
    }

    public void removeAutoGeneratedKeyImages(String string) {
        Set<ReferringObject> set = this.referringObjects.get(KeyImageType.AutoGeneratedBySession);
        if (set == null) {
            return;
        }
        Optional<ReferringObject> optional = set.stream().filter(referringObject -> referringObject.getObject().getSOPInstanceUID().equals(string)).findAny();
        if (optional.isPresent()) {
            ReferringObject referringObject2 = optional.get();
            Set<IFrameObjectData> set2 = this.autoGeneratedKeyImagesMap.remove(referringObject2);
            if (set2 != null) {
                for (IFrameObjectData iFrameObjectData : set2) {
                    this.unmarkEvenIfNotEditable(iFrameObjectData, KeyImageType.AutoGeneratedBySession, true);
                }
            }
            set.remove(referringObject2);
            boolean bl = STORE_MANAGER.deleteInstances(Collections.singletonList(referringObject2.getObject()));
            if (bl) {
                log.debug("Removed auto-generated Key Image.");
            } else {
                log.error("Error on removing auto-generated Key Images.");
            }
        }
    }
}

