/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.keyimages;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObject;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObjectType;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import org.dcm4che3.data.Attributes;

public enum KeyImageType {
    OfInterest(ReferringObjectType.OF_INTEREST, IAIconFactory.DEFAULT_FACTORY.loadIcon("overlay_diagrelevant.svg"), true){

        @Override
        public boolean match(Attributes attributes) {
            return super.match(attributes) && !ReferringObject.isAutoGeneratedKeyImage((Attributes)attributes);
        }
    }
    ,
    ForPrinting(ReferringObjectType.FOR_PRINTING, IAIconFactory.DEFAULT_FACTORY.loadIcon("overlay_printrelevant.svg"), true),
    ForConference(ReferringObjectType.FOR_CONFERENCE, IAIconFactory.DEFAULT_FACTORY.loadIcon("overlay_conferencerelevant.svg"), false),
    ForXDS(ReferringObjectType.FOR_XDS, IAIconFactory.DEFAULT_FACTORY.loadIcon("overlay_xdsexport.svg"), true),
    AutoGeneratedBySession(ReferringObjectType.OF_INTEREST, IAIconFactory.DEFAULT_FACTORY.loadIcon("KeyImageAutoGenerated.svg"), true){

        @Override
        public boolean match(Attributes attributes) {
            return super.match(attributes) && ReferringObject.isAutoGeneratedKeyImage((Attributes)attributes);
        }
    };

    private ReferringObjectType type;
    private PIcon icon;
    private final boolean isModifiable;

    private KeyImageType(ReferringObjectType referringObjectType, PIcon pIcon, boolean bl) {
        this.type = referringObjectType;
        this.icon = pIcon;
        this.isModifiable = bl;
    }

    public static KeyImageType valueOf(ReferringObjectType referringObjectType) {
        KeyImageType[] keyImageTypeArray = KeyImageType.values();
        int n = keyImageTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KeyImageType keyImageType = keyImageTypeArray[n2];
            if (keyImageType.getType().equals((Object)referringObjectType)) {
                return keyImageType;
            }
            ++n2;
        }
        return null;
    }

    public ReferringObjectType getType() {
        return this.type;
    }

    public Code getCode() {
        return this.type.getDicomCode();
    }

    public PIcon getIcon() {
        return this.icon;
    }

    public String getDescription() {
        return this.type.getDescription();
    }

    public boolean isModifiable() {
        return this.isModifiable;
    }

    public boolean match(Attributes attributes) {
        return this.type.match(attributes);
    }

    public static KeyImageType valueOf(String string) {
        return Enum.valueOf(KeyImageType.class, string);
    }

    /* synthetic */ KeyImageType(String string, int n, ReferringObjectType referringObjectType, PIcon pIcon, boolean bl, KeyImageType keyImageType) {
        this(referringObjectType, pIcon, bl);
    }
}

