/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.keyimages;

import com.agfa.pacs.base.swing.layout.RowLayout;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.data.shared.store.IStoreHandler;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.keyimages.KeyImageType;
import com.agfa.pacs.impaxee.save.ISaveItem;
import com.agfa.pacs.impaxee.save.ISaveManager;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IStudyData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class SaveKeyImagesItemPanel
extends JPanel
implements ISaveItem {
    private static final ALogger log = ALogger.getLogger(SaveKeyImagesItemPanel.class);
    private static final int MARGIN = GUI.getScaledDiagnosticInt((int)10);
    private static final int MIN_WIDTH = GUI.getScaledDiagnosticInt((int)350);
    private final IStudyData study;
    private Map<KeyImageType, JCheckBox> checkBoxes;

    public SaveKeyImagesItemPanel(IStudyData iStudyData) {
        this.study = iStudyData;
        this.createComponents();
        this.installLayout();
    }

    private void createComponents() {
        this.checkBoxes = new EnumMap<KeyImageType, JCheckBox>(KeyImageType.class);
        KeyImageType[] keyImageTypeArray = this.study.getKeyImageManager().getModifiedTypes();
        if (keyImageTypeArray != null) {
            KeyImageType[] keyImageTypeArray2 = keyImageTypeArray;
            int n = keyImageTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                KeyImageType keyImageType = keyImageTypeArray2[n2];
                if (!this.checkBoxes.containsKey((Object)keyImageType)) {
                    this.checkBoxes.put(keyImageType, this.createCheckBox(keyImageType));
                }
                ++n2;
            }
        }
    }

    private void installLayout() {
        this.setBorder(SwingUtilities2.createEmptyBorder((int)MARGIN));
        this.setLayout((LayoutManager)new RowLayout(MARGIN));
        for (JCheckBox serializable2 : this.checkBoxes.values()) {
            this.add(serializable2);
        }
        Dimension dimension = this.getPreferredSize();
        if (dimension.width < MIN_WIDTH) {
            dimension.width = MIN_WIDTH;
            this.setPreferredSize(dimension);
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public List<IStoreHandler> getStoreHandlers() {
        return null;
    }

    @Override
    public boolean isSaveable() {
        return true;
    }

    @Override
    public boolean save(boolean bl) {
        int n = 0;
        KeyImageType[] keyImageTypeArray = this.study.getKeyImageManager().getModifiedTypes();
        if (keyImageTypeArray != null) {
            KeyImageType[] keyImageTypeArray2 = keyImageTypeArray;
            int n2 = keyImageTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                KeyImageType keyImageType = keyImageTypeArray2[n3];
                if (this.checkBoxes.containsKey((Object)keyImageType) && this.checkBoxes.get((Object)keyImageType).isSelected()) {
                    try {
                        if (!this.study.getKeyImageManager().save(keyImageType, bl)) {
                            ++n;
                        }
                    }
                    catch (Exception exception) {
                        ++n;
                        log.error("Saving '" + (Object)((Object)keyImageType) + "' key image references for study '" + this.study.getKey() + "' failed!", (Throwable)exception);
                    }
                }
                ++n3;
            }
        }
        return n == 0;
    }

    @Override
    public void setSaveManager(ISaveManager iSaveManager) {
    }

    private JCheckBox createCheckBox(KeyImageType keyImageType) {
        JCheckBox jCheckBox = ComponentFactory.instance.createCheckBox(keyImageType.getDescription());
        jCheckBox.setName(keyImageType.name());
        jCheckBox.setSelected(true);
        return jCheckBox;
    }
}

