/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.livesync;

import com.agfa.pacs.impaxee.livesync.IDisplayLiveSyncPositionHandler;
import com.agfa.pacs.impaxee.livesync.ILiveSyncPosition;
import com.agfa.pacs.impaxee.livesync.ImgView2LiveSyncPosition;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.PickingResult;
import com.tiani.jvision.image.View;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;

public class ImgView2LiveSyncPositionHandler
implements IDisplayLiveSyncPositionHandler {
    private VisDisplay2 display;

    public ImgView2LiveSyncPositionHandler(VisDisplay2 visDisplay2) {
        this.display = visDisplay2;
    }

    @Override
    public ILiveSyncPosition findLiveSyncPosition(PickingResult pickingResult) {
        int n = this.display.getVisCount();
        if (n == 0) {
            return null;
        }
        ImgView2 imgView2 = null;
        Double d = Double.MAX_VALUE;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            Double d2;
            View view = this.display.getVis(n3).getView();
            if (view instanceof ImgView2 && !view.getImageInformation().isLocalizer() && pickingResult.isCompatibleFrameOfReference(view) && (d2 = pickingResult.getDistanceFromPlane(view)) != null && d2 < d) {
                imgView2 = (ImgView2)view;
                d = d2;
                n2 = n3;
            }
            ++n3;
        }
        if (n2 < 0) {
            return null;
        }
        return new ImgView2LiveSyncPosition(imgView2, pickingResult, d, n2);
    }

    @Override
    public ILiveSyncPosition createLiveSyncPosition(PickingResult pickingResult, int n) {
        if (this.display.getVisCount() <= 1 || !this.display.getData().getPlugin().isDefaultPlugin()) {
            return null;
        }
        VisData visData = this.display.getVis(n);
        if (visData == null) {
            return null;
        }
        Double d = pickingResult.getDistanceFromPlane(visData.getView());
        if (d == null || d.isNaN()) {
            return null;
        }
        return new ImgView2LiveSyncPosition((ImgView2)visData.getView(), pickingResult, d, n);
    }
}

