/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.model.xml.shared;

import com.agfa.pacs.impaxee.descriptors.Descriptor;
import com.agfa.pacs.impaxee.descriptors.IDescriptorIDReference;
import com.agfa.pacs.impaxee.hanging.model.xml.Condition;
import com.agfa.pacs.impaxee.hanging.model.xml.ReferencedDescriptor;
import com.agfa.pacs.impaxee.model.xml.shared.IReferencedDescriptorsHandler;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.xml.minijaxb.AbstractIntermediateXMLElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractReferencedDescriptorsContainer
extends AbstractIntermediateXMLElement
implements IDescriptorIDReference,
IReferencedDescriptorsHandler {
    private static final ALogger log = ALogger.getLogger(AbstractReferencedDescriptorsContainer.class);
    public static boolean ignoreUnregisteredDescriptors = true;
    protected List<Condition> cachedConditions = new ArrayList<Condition>(2);
    protected List<ReferencedDescriptor> referencedDescriptors = new ArrayList<ReferencedDescriptor>(2);

    @Override
    public void addReferencedDescriptor(ReferencedDescriptor referencedDescriptor) {
        if (referencedDescriptor != null) {
            if (referencedDescriptor.referencedDescriptor() != null) {
                this.referencedDescriptors.add(referencedDescriptor);
                this.cachedConditions.addAll(referencedDescriptor.referencedDescriptor().conditions());
            } else if (!ignoreUnregisteredDescriptors) {
                this.referencedDescriptors.add(referencedDescriptor);
            } else {
                log.error("Invalid ID for referenced descriptor");
            }
        }
    }

    @Override
    public final void removeReferencedDescriptor(ReferencedDescriptor referencedDescriptor) {
        if (referencedDescriptor != null) {
            this.referencedDescriptors.remove((Object)referencedDescriptor);
            this.cachedConditions.removeAll(referencedDescriptor.referencedDescriptor().conditions());
        }
    }

    @Override
    public void removeDescriptor(Descriptor descriptor) {
        if (descriptor != null) {
            Iterator<ReferencedDescriptor> iterator = this.referencedDescriptors.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getId().equals(descriptor.getId())) continue;
                iterator.remove();
            }
            this.cachedConditions.removeAll(descriptor.conditions());
        }
    }

    @Override
    public ReferencedDescriptor[] referencedDescriptors() {
        return this.referencedDescriptors.toArray(new ReferencedDescriptor[this.referencedDescriptors.size()]);
    }

    @Override
    public Collection<Long> referencedDescriptorIDs() {
        List<ReferencedDescriptor> list = this.referencedDescriptorList();
        HashSet<Long> hashSet = new HashSet<Long>(list.size());
        for (ReferencedDescriptor referencedDescriptor : list) {
            hashSet.add(referencedDescriptor.getId());
        }
        return hashSet;
    }

    public final ReferencedDescriptor getReferencedDescriptor(int n) {
        if (n >= 0 && n < this.referencedDescriptors.size()) {
            return this.referencedDescriptors.get(n);
        }
        return null;
    }

    public List<ReferencedDescriptor> referencedDescriptorList() {
        return this.referencedDescriptors;
    }

    public int conditionCount() {
        return this.cachedConditions != null ? this.cachedConditions.size() : 0;
    }

    public List<Condition> cachedConditions() {
        return this.cachedConditions;
    }

    public void clearConditions() {
        this.cachedConditions.clear();
    }

    public void rebuildConditions() {
        this.clearConditions();
        for (ReferencedDescriptor referencedDescriptor : this.referencedDescriptors) {
            if (referencedDescriptor.referencedDescriptor() != null) {
                this.cachedConditions.addAll(referencedDescriptor.referencedDescriptor().conditions());
                continue;
            }
            log.error("Invalid ID for referenced descriptor");
        }
    }

    public void updateReferencedDescriptors(long l, long l2) {
        if (l == l2) {
            return;
        }
        ReferencedDescriptor[] referencedDescriptorArray = this.referencedDescriptors();
        int n = referencedDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReferencedDescriptor referencedDescriptor = referencedDescriptorArray[n2];
            if (referencedDescriptor.getId() == l) {
                referencedDescriptor.setId(l2);
            }
            ++n2;
        }
    }

    public String toString() {
        return this.referencedDescriptors + ": " + this.cachedConditions;
    }
}

