/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.mousemodeinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public enum MouseSubModes {
    DEFAULT("MOUSE_MODE_NORMAL", Flag.QUICK_ABORT_DISABLED),
    ZOOM_PAN("PAN_SUBMODE", Flag.QUICK_ABORT_DISABLED),
    FREE_ROTATION("FREE_ROTATION_PRECHARGE", new Flag[0]),
    ZOOM_RECT("ZOOM_BY_RECTANGLE", new Flag[0]),
    THREE_D_FIT("3D_FIT", new Flag[0]),
    REGISTRATION("REGISTRATION", new Flag[0]),
    MEASURE_DISTANCE(Flag.MEASUREMENT, Flag.DRAWING),
    MEASURE_ANGLE(Flag.MEASUREMENT, Flag.DRAWING),
    MEASURE_COBB_ANGLE(Flag.MEASUREMENT, Flag.DRAWING),
    MEASURE_NORMAL_DISTANCE(Flag.MEASUREMENT, Flag.DRAWING),
    MEASURE_RATIO(Flag.MEASUREMENT, Flag.DRAWING),
    MEASURE_BIDIMENSIONAL_LENGTH(Flag.MEASUREMENT, Flag.DRAWING),
    MEASURE_HORIZONTAL_DISTANCE(Flag.MEASUREMENT, Flag.DRAWING),
    MEASURE_DOUBLE_CENTERLINE(Flag.MEASUREMENT, Flag.DRAWING),
    DRAW_CENTERLINE(Flag.DRAWING),
    DRAW_ARROW(Flag.DRAWING),
    DRAW_TEXT(Flag.DRAWING),
    DRAW_CIRCLE(Flag.DRAWING),
    DRAW_CIRCLE_3POINT(Flag.DRAWING),
    DRAW_ELLIPSE(Flag.DRAWING),
    DRAW_RECTANGLE(Flag.DRAWING),
    DRAW_POLYGON(Flag.DRAWING),
    DRAW_SPLINECURVE(Flag.DRAWING),
    DRAW_MAGNETIC_CONTOUR(Flag.DRAWING),
    LEFT(Flag.DRAWING),
    RIGHT(Flag.DRAWING),
    STRAIGHTEN_IMAGE(Flag.DRAWING),
    CALIBRATION_SPHERE(Flag.PLUGIN),
    CALIBRATION_CATHETERFIRSTLINE(Flag.PLUGIN),
    CALIBRATION_CATHETERSECONDLINE(Flag.PLUGIN),
    CALIBRATION_MARKER(Flag.PLUGIN),
    CALIBRATION_LINE(Flag.PLUGIN),
    SEGMENTATION_STARTPOINT(Flag.PLUGIN),
    SEGMENTATION_ENDPOINT(Flag.PLUGIN),
    DRAW_DENT_SPLINE(Flag.PLUGIN),
    SET_POINT(Flag.PLUGIN),
    DRAW_EMPR_SPLINE(Flag.PLUGIN, Flag.QUICK_ABORT_DISABLED),
    DRAW_REFORMAT_LINE(Flag.PLUGIN),
    EDIT_EMPR_SPLINE(Flag.PLUGIN, Flag.QUICK_ABORT_DISABLED),
    EMPR_SEGMENTATION_PICK_STRUCTURE(Flag.PLUGIN, Flag.QUICK_ABORT_DISABLED),
    EMPR_SEGMENTATION_PICK_BRUSH(Flag.PLUGIN, Flag.QUICK_ABORT_DISABLED),
    EMPR_SEGMENTATION_VOLUMETRY_GROW(Flag.PLUGIN, Flag.QUICK_ABORT_DISABLED),
    EMPR_SEGMENTATION_VOLUMETRY_MODIFY(Flag.PLUGIN, Flag.QUICK_ABORT_DISABLED),
    EMPR_SEGMENTATION_DRAW_BACKGROUND_POLYGON(Flag.PLUGIN, Flag.QUICK_ABORT_DISABLED),
    EMPR_SEGMENTATION_DRAW_STRUCTURE_POLYGON(Flag.PLUGIN, Flag.QUICK_ABORT_DISABLED),
    EMPR_SEGMENTATION_ADDITION_FREEHAND_POLYGON(Flag.PLUGIN, Flag.QUICK_ABORT_DISABLED),
    EMPR_SEGMENTATION_SUBTRACTION_FREEHAND_POLYGON(Flag.PLUGIN, Flag.QUICK_ABORT_DISABLED),
    EMPR_SEGMENTATION_CUT_INTERIOR_POLYGON(Flag.PLUGIN, Flag.QUICK_ABORT_DISABLED),
    EMPR_SEGMENTATION_CUT_SURROUNDING_POLYGON(Flag.PLUGIN, Flag.QUICK_ABORT_DISABLED),
    EMPR_SEGMENTATION_CUT_INTERIOR_2D(Flag.PLUGIN, Flag.QUICK_ABORT_DISABLED),
    EMPR_SEGMENTATION_CUT_SURROUNDING_2D(Flag.PLUGIN, Flag.QUICK_ABORT_DISABLED),
    EMPR_SEGMENTATION_ADD_MAGNETIC_CONTOUR(Flag.PLUGIN, Flag.QUICK_ABORT_DISABLED),
    EMPR_SEGMENTATION_SUBTRACT_MAGNETIC_CONTOUR(Flag.PLUGIN, Flag.QUICK_ABORT_DISABLED),
    ELLIPSE_1(Flag.PLUGIN),
    ELLIPSE_2(Flag.PLUGIN),
    CENTER_MIRRORLINE(Flag.PLUGIN),
    DRAW_SPINE_LABEL(Flag.PLUGIN);

    private static final String DRAWING_MODE_ID_PREFIX = "MOUSE_MODE_";
    private static Collection<MouseSubModes> measurementModes;
    private static List<MouseSubModes> drawingModes;
    private final String actionID;
    private final boolean pluginMouseMode;
    private final boolean isMeasurement;
    private final boolean isDrawingMode;
    private final boolean isQuickAbortEnabled;

    private MouseSubModes(Flag ... flagArray) {
        this((String)null, flagArray);
    }

    private MouseSubModes(String string2, Flag ... flagArray) {
        this.pluginMouseMode = ArrayUtils.contains((Object[])flagArray, (Object)((Object)Flag.PLUGIN));
        this.isMeasurement = ArrayUtils.contains((Object[])flagArray, (Object)((Object)Flag.MEASUREMENT));
        this.isDrawingMode = ArrayUtils.contains((Object[])flagArray, (Object)((Object)Flag.DRAWING));
        this.isQuickAbortEnabled = !ArrayUtils.contains((Object[])flagArray, (Object)((Object)Flag.QUICK_ABORT_DISABLED));
        this.actionID = this.isDrawingMode ? DRAWING_MODE_ID_PREFIX + this.name() : string2;
    }

    public String getActionID() {
        return this.actionID;
    }

    public String toString() {
        return this.name();
    }

    public boolean isPluginMouseMode() {
        return this.pluginMouseMode;
    }

    public boolean isMeasurement() {
        return this.isMeasurement;
    }

    public boolean isDrawingMode() {
        return this.isDrawingMode;
    }

    public boolean isQuickAbortEnabled() {
        return this.isQuickAbortEnabled;
    }

    public static Collection<MouseSubModes> getMeasurementSubModes() {
        if (measurementModes == null) {
            HashSet<MouseSubModes> hashSet = new HashSet<MouseSubModes>();
            MouseSubModes[] mouseSubModesArray = MouseSubModes.values();
            int n = mouseSubModesArray.length;
            int n2 = 0;
            while (n2 < n) {
                MouseSubModes mouseSubModes = mouseSubModesArray[n2];
                if (mouseSubModes.isMeasurement()) {
                    hashSet.add(mouseSubModes);
                }
                ++n2;
            }
            measurementModes = hashSet;
        }
        return measurementModes;
    }

    public static List<MouseSubModes> getStandardDrawingSubModes() {
        if (drawingModes == null) {
            ArrayList<MouseSubModes> arrayList = new ArrayList<MouseSubModes>();
            MouseSubModes[] mouseSubModesArray = MouseSubModes.values();
            int n = mouseSubModesArray.length;
            int n2 = 0;
            while (n2 < n) {
                MouseSubModes mouseSubModes = mouseSubModesArray[n2];
                if (mouseSubModes.isDrawingMode) {
                    arrayList.add(mouseSubModes);
                }
                ++n2;
            }
            drawingModes = arrayList;
        }
        return drawingModes;
    }

    public static MouseSubModes getMouseSubModeForActionID(String string) {
        MouseSubModes[] mouseSubModesArray = MouseSubModes.values();
        int n = mouseSubModesArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseSubModes mouseSubModes = mouseSubModesArray[n2];
            if (string.equals(mouseSubModes.actionID)) {
                return mouseSubModes;
            }
            ++n2;
        }
        return null;
    }

    private static enum Flag {
        MEASUREMENT,
        DRAWING,
        PLUGIN,
        QUICK_ABORT_DISABLED;

    }
}

