/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.plugin;

import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.gui.controls.hotregion.HotRegion;
import com.tiani.jvision.actioncontext.ActionContextManager;
import com.tiani.jvision.image.View;
import com.tiani.jvision.info.IMutableImageState;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisHRSet;
import com.tiani.jvision.vis.VisMouseHandler;
import com.tiani.jvision.vis.dnd.VisDisplayDropTargetListener;
import com.tiani.jvision.vis.dnd.VisDragGestureRecognizer;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;

public abstract class AbstractPanelPluginView
extends View {
    private static final ALogger LOG = ALogger.getLogger(AbstractPanelPluginView.class);
    private Vis2 vis2;
    private Component contentPane;
    private DragAndDropHandler dndHandler;

    public AbstractPanelPluginView(IFrameObjectData iFrameObjectData) {
        super(iFrameObjectData);
    }

    @Override
    public VisHRSet getHRSet(VisHRSet visHRSet, Vis2 vis2) {
        return null;
    }

    @Override
    public BufferedImage getImage() {
        return null;
    }

    @Override
    public BufferedImage captureImage() {
        Rectangle rectangle = this.getVisView().getVisDisplay().getBounds();
        rectangle.setLocation(this.getVisView().getVisDisplay().getLocationOnScreen());
        try {
            return new Robot().createScreenCapture(rectangle);
        }
        catch (AWTException aWTException) {
            LOG.error("Error on capturing image", (Throwable)aWTException);
            return null;
        }
    }

    @Override
    public void cleanUp() {
        if (this.isInstalledInVis()) {
            if (this.dndHandler != null) {
                this.dndHandler.uninstall();
            }
            this.restoreVis();
        }
        super.cleanUp();
    }

    @Override
    public boolean isFunctional() {
        return true;
    }

    @Override
    public boolean showContextMenu() {
        return false;
    }

    @Override
    public void visSet(Vis2 vis2) {
        if (this.isInstalledInVis() && this.dndHandler != null) {
            this.dndHandler.uninstall();
        }
        if (vis2 != null) {
            this.vis2 = vis2;
            this.contentPane = this.getContentPane(vis2.hasData() ? vis2.getData().getFrameData() : null);
            this.setupVis(this.vis2, this.contentPane);
            Component component = this.getDragAndDropComponent(this.contentPane);
            if (component != null) {
                this.dndHandler = DragAndDropHandler.install(this.vis2, component, this.getDropTargetListener(this.vis2));
            }
        }
        super.visSet(vis2);
    }

    @Override
    public void reset() {
    }

    @Override
    public IMutableImageState getImageState() {
        return ImageState.getDefaultImageState();
    }

    @Override
    public String getVisualType() {
        return "";
    }

    @Override
    public void paint(RGBBufferedImageHolder rGBBufferedImageHolder) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void onCanvasSizeChanged(boolean bl) {
    }

    @Override
    public void handleHotRegionPressed(HotRegion hotRegion, MouseEvent mouseEvent) {
    }

    @Override
    public void handleHotRegionDragged(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2, int n3, int n4) {
    }

    @Override
    public void handleHotRegionReleased(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2) {
    }

    public final boolean isInstalledInVis() {
        return this.vis2 != null && this.contentPane != null && SwingUtilities.isDescendingFrom(this.contentPane, this.vis2);
    }

    private void setupVis(Vis2 vis2, Component component) {
        VisMouseHandler visMouseHandler = vis2.getMouseHandler();
        if (visMouseHandler != null) {
            visMouseHandler.setVisible(false);
        }
        vis2.removeAll();
        vis2.setLayout(new BorderLayout());
        vis2.add(component, "Center");
        vis2.setBorder(ComponentFactory.instance.createEmptyBorder(1));
        vis2.revalidate();
    }

    private void restoreVis() {
        this.vis2.setBorder(null);
        this.vis2.removeAll();
        this.vis2.setLayout(null);
        VisMouseHandler visMouseHandler = this.vis2.getMouseHandler();
        if (visMouseHandler != null) {
            visMouseHandler.setVisible(true);
        }
    }

    protected abstract Component getContentPane(IFrameObjectData var1);

    protected Component getDragAndDropComponent(Component component) {
        return component;
    }

    protected DropTargetListener getDropTargetListener(Vis2 vis2) {
        return new DefaultDropTargetListener(vis2);
    }

    protected static class DefaultDropTargetListener
    extends VisDisplayDropTargetListener {
        private final Vis2 vis2;

        public DefaultDropTargetListener(Vis2 vis2) {
            super(vis2.getVisDisplay());
            this.vis2 = vis2;
        }

        public final Vis2 getVis() {
            return this.vis2;
        }
    }

    public class DefaultMouseHandler
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (AbstractPanelPluginView.this.vis2 != null && AbstractPanelPluginView.this.vis2.hasData() && VisData.getLastModified() != AbstractPanelPluginView.this.vis2.getData()) {
                AbstractPanelPluginView.this.vis2.makeTheLastModified();
                ActionContextManager.singleton.contextChanged(AbstractPanelPluginView.this.vis2.getVisDisplay().getData());
            }
        }

        protected boolean isLastModified() {
            return AbstractPanelPluginView.this.vis2 != null && AbstractPanelPluginView.this.vis2.hasData() && JVision2.getMainFrame().getLastModifiedDisplay() == AbstractPanelPluginView.this.vis2.getVisDisplay();
        }
    }

    private static class DragAndDropHandler {
        private final DropTarget dt;
        private final VisDragGestureRecognizer dragRecognizer;

        private DragAndDropHandler(DropTarget dropTarget, VisDragGestureRecognizer visDragGestureRecognizer) {
            this.dt = dropTarget;
            this.dragRecognizer = visDragGestureRecognizer;
        }

        public static DragAndDropHandler install(Vis2 vis2, Component component, DropTargetListener dropTargetListener) {
            return new DragAndDropHandler(new DropTarget(component, dropTargetListener), new VisDragGestureRecognizer(vis2, new DragSource(), component, 0x40000003));
        }

        public void uninstall() {
            this.dragRecognizer.setComponent(null);
            Component component = this.dt.getComponent();
            if (component != null) {
                component.setDropTarget(null);
            }
        }
    }
}

