/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.plugin;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.gui.selection.DisplaySetSelectionData;
import com.agfa.pacs.impaxee.gui.selection.ISelectionDialogConfigurator;
import com.agfa.pacs.impaxee.gui.selection.SelectionDialog;
import com.agfa.pacs.impaxee.gui.selection.StudySelectionData;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.plugin.ExportForExternalAppMode;
import com.agfa.pacs.impaxee.plugin.ExportForExternalAppState;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.image.ExternalAppWaitForImagesView;
import com.tiani.jvision.main.JVision2;
import com.tiani.util.message.Message;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ExportForExternalAppDialog
implements WindowListener {
    private static final ALogger log = ALogger.getLogger(ExportForExternalAppDialog.class);
    ExternalAppWaitForImagesView listener;
    String externalApplicationName;
    String externalProcessName;
    private final SelectionDialog<?> dialog;

    public ExportForExternalAppDialog(ExternalAppWaitForImagesView externalAppWaitForImagesView, String string, String string2, ExportForExternalAppMode exportForExternalAppMode) {
        this.listener = externalAppWaitForImagesView;
        this.externalApplicationName = string;
        this.externalProcessName = string2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Messages.getString("ExportForExternalAppDialog.Title1"));
        stringBuilder.append(' ');
        stringBuilder.append(string);
        stringBuilder.append(' ');
        stringBuilder.append(Messages.getString("ExportForExternalAppDialog.Title2"));
        IDisplaySet iDisplaySet = externalAppWaitForImagesView.getDisplayData().getDisplaySet();
        switch (exportForExternalAppMode) {
            case EXPORT_DISPLAYSETS_OF_STUDIES: {
                this.dialog = new SelectionDialog<IStudyData>((Frame)JVision2.getMainFrame(), stringBuilder.toString(), new ExportStudiesAction(iDisplaySet.getStudy()));
                break;
            }
            case EXPORT_DISPLAYSETS: {
                this.dialog = new SelectionDialog<IDisplaySet>((Frame)JVision2.getMainFrame(), stringBuilder.toString(), new ExportDisplaySetsAction(iDisplaySet));
                break;
            }
            default: {
                this.dialog = null;
            }
        }
        if (this.dialog != null) {
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.addWindowListener(this);
        }
    }

    public Window getDialog() {
        return this.dialog;
    }

    private boolean checkIfExternalProcessIsRunning(String string) {
        try {
            return this.isProcessRunning(ExportForExternalAppDialog.createTaskListProcess(), string);
        }
        catch (Exception exception) {
            log.warn("Problem determining if " + this.externalApplicationName + " is already running", (Throwable)exception);
            return false;
        }
    }

    private static Process createTaskListProcess() throws IOException {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(new String[]{"tasklist.exe"});
        }
        catch (IOException iOException) {
            try {
                process = Runtime.getRuntime().exec(new String[]{"tlist.exe"});
            }
            catch (IOException iOException2) {
                process = Runtime.getRuntime().exec(new String[]{"ps", "aux"});
            }
        }
        return process;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isProcessRunning(Process process, String string) throws IOException {
        String string2 = null;
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            try {
                do {
                    if ((string2 = bufferedReader.readLine()) != null) continue;
                    return false;
                } while (!StringUtils.isNotBlank((CharSequence)string2) || !string2.contains(string));
                Message.warning(MessageFormat.format(Messages.getString("ExportForExternalAppDialog.Title"), this.externalApplicationName), MessageFormat.format(Messages.getString("ExportForExternalAppDialog.Message"), this.externalApplicationName));
                return true;
            }
            finally {
                if (bufferedReader == null) return true;
                bufferedReader.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    boolean loadDisplaySets(Iterable<IDisplaySet> iterable) {
        boolean bl;
        boolean bl2 = bl = !this.checkIfExternalProcessIsRunning(this.externalProcessName);
        if (bl) {
            this.listener.propertyChange(new PropertyChangeEvent(this, ExportForExternalAppState.EXPORT.getMode(), null, iterable));
        }
        return bl;
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.listener.propertyChange(new PropertyChangeEvent(this, ExportForExternalAppState.CANCELED.getMode(), null, null));
        this.dialog.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    private class ExportDisplaySetsAction
    extends DisplaySetSelectionData
    implements ISelectionDialogConfigurator<IDisplaySet> {
        ExportDisplaySetsAction(IDisplaySet iDisplaySet) {
            super(iDisplaySet);
        }

        @Override
        public String getLoadedDataTitle() {
            return Messages.getString("ExportForExternalAppDialog.loadedSeries");
        }

        @Override
        public String getAdditionalDataTitle() {
            return Messages.getString("ExportForExternalAppDialog.loadAdditional");
        }

        @Override
        public String getTitle() {
            return Messages.getString("ExportForExternalAppDialog.ExportDisplaySetsAction.Title");
        }

        @Override
        public String getToolTip() {
            return Messages.getString("ExportForExternalAppDialog.ExportDisplaySetsAction.ToolTip");
        }

        @Override
        public boolean confirmSelection(List<IDisplaySet> list) {
            return ExportForExternalAppDialog.this.loadDisplaySets(list);
        }
    }

    private class ExportStudiesAction
    extends StudySelectionData
    implements ISelectionDialogConfigurator<IStudyData> {
        ExportStudiesAction(IStudyData iStudyData) {
            super(iStudyData);
        }

        @Override
        public String getLoadedDataTitle() {
            return Messages.getString("ExportForExternalAppDialog.loadedStudy");
        }

        @Override
        public String getAdditionalDataTitle() {
            return Messages.getString("ExportForExternalAppDialog.loadAdditional");
        }

        @Override
        public String getTitle() {
            return Messages.getString("ExportForExternalAppDialog.ExportStudiesAction.Title");
        }

        @Override
        public String getToolTip() {
            return Messages.getString("ExportForExternalAppDialog.ExportStudiesAction.ToolTip");
        }

        @Override
        public boolean confirmSelection(List<IStudyData> list) {
            ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>();
            IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(((IStudyData)this.getLoadedData()).getParent().getKey());
            ISplitAndSortRuntime iSplitAndSortRuntime = iPatientRepresentation.getDecompositionRuntime();
            IDisplaySet[] iDisplaySetArray = iSplitAndSortRuntime.getDisplaySets();
            for (IStudyData iStudyData : list) {
                IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray;
                int n = iDisplaySetArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IDisplaySet iDisplaySet = iDisplaySetArray2[n2];
                    if (iDisplaySet.getStudy() == iStudyData && !arrayList.contains(iDisplaySet)) {
                        arrayList.add(iDisplaySet);
                    }
                    ++n2;
                }
            }
            return ExportForExternalAppDialog.this.loadDisplaySets(arrayList);
        }
    }
}

