/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.plugin;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PSelectableAction;
import com.agfa.pacs.impaxee.data.fetcher.AbstractLosslessImageFetcher;
import com.agfa.pacs.impaxee.hanging.model.IDisplayState;
import com.agfa.pacs.impaxee.plugin.IPlugin;
import com.tiani.jvision.toptoolbar.PluginActions;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.EventQueue;
import java.text.MessageFormat;

public class PluginStarter
extends AbstractLosslessImageFetcher {
    protected final IPlugin plugin;
    protected final IDisplayState initialDisplayState;

    public PluginStarter(IPlugin iPlugin, VisDisplay2 visDisplay2) {
        this(iPlugin, visDisplay2, null);
    }

    protected PluginStarter(IPlugin iPlugin, VisDisplay2 visDisplay2, IDisplayState iDisplayState) {
        super(visDisplay2, visDisplay2.getData() == null ? null : visDisplay2.getData().getDisplaySet());
        this.plugin = iPlugin;
        this.initialDisplayState = iDisplayState;
    }

    public boolean start() {
        if (!this.display.hasData()) {
            return false;
        }
        if (!this.isDefaultPlugin() && this.display.getData().getDisplaySet().isBeingLossyPrefetched()) {
            EventQueue.invokeLater(this::startLosslessImageDownload);
        } else {
            this.executeAction();
        }
        return true;
    }

    @Override
    protected void executeAction() {
        this.display.getData().setType(this.plugin, this.getActivationMode(), this.initialDisplayState);
    }

    protected ActivationMode getActivationMode() {
        return ActivationMode.MANUAL;
    }

    @Override
    protected String getLossyImageWarningMessage() {
        return MessageFormat.format(Messages.getString("PluginStarter.LossyImageWarning.Message"), this.plugin.getDescription());
    }

    @Override
    protected void abortLosslessImageDownload() {
        this.revertToPreviousPlugin();
    }

    protected void revertToPreviousPlugin() {
        String string = PluginActions.getPluginActionID(this.plugin.getPluginName());
        this.setSelectionState(string, false);
        String string2 = this.display.hasData() ? PluginActions.getPluginActionID(this.display.getData().getPlugin().getPluginName()) : PluginActions.PLUGIN_OFF;
        this.setSelectionState(string2, true);
    }

    private void setSelectionState(String string, boolean bl) {
        if (this.display.hasAction(string)) {
            PAction pAction = this.display.getAction(string);
            ((PSelectableAction)((Object)pAction)).setSelected(bl);
            pAction.forcedSelectionChanged();
        }
    }

    private boolean isDefaultPlugin() {
        return this.plugin == null || this.plugin.isDefaultPlugin();
    }

    @Override
    protected String getLosslessImageDownloadErrorMessage() {
        return MessageFormat.format(Messages.getString("PluginStarter.LosslessImageDownloadError.Message"), this.plugin.getDescription());
    }
}

