/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.presentationstate;

import com.agfa.pacs.impaxee.gsts.GrayScaleTransformationSequence;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.presentationstate.IPresentationState;
import com.agfa.pacs.impaxee.presentationstate.PresentationStateType;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedImage;
import com.agfa.pacs.listtext.dicomobject.lut.IRescaleSlopeInterceptProvider;
import com.agfa.pacs.listtext.dicomobject.module.ps.DisplayedArea;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicAnnotation;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicLayer;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.ModalityLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.RescaleType;
import com.agfa.pacs.listtext.dicomobject.module.ps.SpatialTransformationModule;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.WindowDef;
import com.tiani.jvision.image.WindowHandlerBase;
import com.tiani.jvision.overlay.IGraphicObjectContainer;
import com.tiani.jvision.overlay.ITextObjectContainer;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlayConfig;
import com.tiani.jvision.overlay.PresentationObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractPresentationState
implements IPresentationState {
    public static final String LAYER_NAME = "ROI";
    private final Set<View.CAPTURE_STATES> captureStates;
    private final boolean hasColorLUT;
    private int layerCounter;

    protected AbstractPresentationState(Set<View.CAPTURE_STATES> set, boolean bl) {
        this.captureStates = set;
        this.hasColorLUT = bl;
    }

    protected abstract IFrameObjectData getFrameData();

    @Override
    public boolean isIndexedColor() {
        return this.hasColorLUT;
    }

    @Override
    public DisplayedArea createDisplayedArea() {
        if (!this.captureStates.contains((Object)View.CAPTURE_STATES.ZOOM_PAN)) {
            return null;
        }
        return this.createDisplayedAreaImpl();
    }

    protected abstract DisplayedArea createDisplayedAreaImpl();

    @Override
    public ReferencedImage createReferencedImage() {
        IFrameObjectData iFrameObjectData = this.getFrameData();
        IImageInformation iImageInformation = iFrameObjectData.getImageInformation();
        ReferencedImage referencedImage = new ReferencedImage();
        referencedImage.setSOPClassUID(iImageInformation.getSOPClassUID());
        referencedImage.setSOPInstanceUID(iImageInformation.getSOPInstanceUID());
        if (iFrameObjectData.getMainFrame().getFrameCount() != 1) {
            referencedImage.setFrame(iFrameObjectData.getFrameNumber() + 1);
        }
        return referencedImage;
    }

    @Override
    public SpatialTransformationModule createSpatialTransformationModule() {
        if (!this.captureStates.contains((Object)View.CAPTURE_STATES.TRANSFORMATION)) {
            return null;
        }
        return this.createSpatialTransformationModuleImpl();
    }

    protected abstract SpatialTransformationModule createSpatialTransformationModuleImpl();

    @Override
    public int getColumns() {
        return this.getFrameData().getImageInformation().getColumns();
    }

    @Override
    public List<GraphicAnnotation> getGraphicAnnotations(List<GraphicLayer> list, PresentationStateType presentationStateType) {
        this.layerCounter = 1;
        HashMap<String, GraphicAnnotation> hashMap = new HashMap<String, GraphicAnnotation>();
        HashMap<Color, String> hashMap2 = new HashMap<Color, String>();
        hashMap2.put(null, LAYER_NAME);
        boolean bl = false;
        for (GraphicLayer object : list) {
            if (!object.getGraphicLayer().equals(LAYER_NAME)) {
                hashMap2.put(object.getColor(ComponentFactory.instance.isOnColorMonitor()), object.getGraphicLayer());
                continue;
            }
            bl = true;
        }
        if (!bl) {
            GraphicLayer graphicLayer = new GraphicLayer();
            graphicLayer.setGraphicLayerRecommendedDisplayRGBValue(GraphicLayer.to16BitRgbValue((Color)OverlayConfig.mappingColor));
            graphicLayer.setGraphicLayer(LAYER_NAME);
            list.add(graphicLayer);
        }
        for (Overlay overlay : this.getOverlays()) {
            String string;
            if (!overlay.isVisible() || "__JV_BURN__".equals(string = overlay.getLayerLabel()) || "__JV_DELETED__".equals(string) || !(overlay instanceof PresentationObject)) continue;
            PresentationObject presentationObject = (PresentationObject)overlay;
            if (presentationObject.isROI() && (presentationObject instanceof ITextObjectContainer || presentationObject instanceof IGraphicObjectContainer)) {
                Object object;
                GraphicAnnotation graphicAnnotation;
                string = this.setGraphicLayerColorAndName(presentationObject, list, hashMap2);
                if (!hashMap.containsKey(string)) {
                    graphicAnnotation = new GraphicAnnotation();
                    graphicAnnotation.setGraphicLayer(string);
                    graphicAnnotation.setSaved(true);
                    hashMap.put(string, graphicAnnotation);
                } else {
                    graphicAnnotation = (GraphicAnnotation)hashMap.get(string);
                }
                if (!presentationObject.isSaved()) {
                    graphicAnnotation.setSaved(false);
                }
                if (presentationObject instanceof ITextObjectContainer) {
                    object = ((ITextObjectContainer)((Object)presentationObject)).storeROI();
                    graphicAnnotation.textObjects().add(object);
                }
                if (presentationObject instanceof IGraphicObjectContainer && (object = ((IGraphicObjectContainer)((Object)presentationObject)).storeROI()) != null) {
                    graphicAnnotation.graphicObjects().addAll(object);
                }
            }
            if (presentationStateType != PresentationStateType.PERMANENT) continue;
            presentationObject.setSaved(true);
        }
        return new ArrayList<GraphicAnnotation>(hashMap.values());
    }

    protected abstract List<Overlay> getOverlays();

    private String setGraphicLayerColorAndName(PresentationObject presentationObject, List<GraphicLayer> list, Map<Color, String> map) {
        String string;
        if (presentationObject.isColorUserDefined()) {
            Color color = presentationObject.objCol;
            if (!map.containsKey(color)) {
                int[] nArray = GraphicLayer.to16BitRgbValue((Color)color);
                GraphicLayer graphicLayer = new GraphicLayer();
                graphicLayer.setGraphicLayerOrder(Integer.toString(this.layerCounter));
                graphicLayer.setGraphicLayerRecommendedDisplayRGBValue(nArray);
                string = LAYER_NAME + this.layerCounter;
                map.put(color, string);
                graphicLayer.setGraphicLayer(string);
                list.add(graphicLayer);
                ++this.layerCounter;
            } else {
                String string2;
                string = string2 = map.get(color);
            }
        } else {
            string = LAYER_NAME;
        }
        return string;
    }

    @Override
    public ModalityLUT getModalityLUT() {
        WindowHandlerBase windowHandlerBase = this.getWindowHandler();
        if (windowHandlerBase == null) {
            return null;
        }
        IImageInformation iImageInformation = this.getFrameData().getImageInformation();
        GrayScaleTransformationSequence grayScaleTransformationSequence = windowHandlerBase.getGSTS();
        ModalityLUT modalityLUT = grayScaleTransformationSequence != null ? grayScaleTransformationSequence.createModalityLUT() : iImageInformation.getModalityLUT();
        if (modalityLUT != null && modalityLUT.getRescaleIntercept() != null && iImageInformation.getImageClass() == IImageInformation.ImageClass.CT) {
            modalityLUT = new ModalityLUT((IRescaleSlopeInterceptProvider)modalityLUT);
            if (WindowDef.hasHounsfieldUnits(iImageInformation)) {
                modalityLUT.setRescaleType(RescaleType.HounsfieldUnits);
            } else {
                modalityLUT.setRescaleType(RescaleType.Unspecified);
            }
        }
        return modalityLUT;
    }

    protected abstract WindowHandlerBase getWindowHandler();

    @Override
    public PresentationLUT getPresentationLUT() {
        if (!this.captureStates.contains((Object)View.CAPTURE_STATES.INVERT)) {
            return null;
        }
        return this.getPresentationLUTImpl();
    }

    protected abstract PresentationLUT getPresentationLUTImpl();

    @Override
    public int getRows() {
        return this.getFrameData().getImageInformation().getRows();
    }

    @Override
    public String getSeriesInstanceUID() {
        return this.getFrameData().getImageInformation().getSeriesInstanceUID();
    }

    @Override
    public IVOILUT getVOILUT(boolean bl) {
        if (!this.captureStates.contains((Object)View.CAPTURE_STATES.WINDOW_LEVEL)) {
            return null;
        }
        WindowHandlerBase windowHandlerBase = this.getWindowHandler();
        if (windowHandlerBase == null) {
            return null;
        }
        return windowHandlerBase.getVOILUTForPresentationState(bl);
    }
}

