/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.presentationstate;

import com.agfa.pacs.listtext.dicomobject.module.ps.SpatialTransformationModule;
import com.agfa.pacs.listtext.dicomobject.type.YN;

public enum DisplayedAreaOrientation {
    REGULAR{

        @Override
        public boolean isCompatibleSpatialTransformation(int n, YN yN) {
            return n == 0 && yN == YN.No || n == 90 && yN == YN.Yes;
        }
    }
    ,
    TOP_BOTTOM_SWAPPED{

        @Override
        public boolean isCompatibleSpatialTransformation(int n, YN yN) {
            return n == 90 && yN == YN.No || n == 180 && yN == YN.Yes;
        }
    }
    ,
    LEFT_RIGHT_SWAPPED{

        @Override
        public boolean isCompatibleSpatialTransformation(int n, YN yN) {
            return n == 270 && yN == YN.No || n == 0 && yN == YN.Yes;
        }
    }
    ,
    ALL_SWAPPED{

        @Override
        public boolean isCompatibleSpatialTransformation(int n, YN yN) {
            return n == 180 && yN == YN.No || n == 270 && yN == YN.Yes;
        }
    };


    private DisplayedAreaOrientation() {
    }

    public static DisplayedAreaOrientation get(SpatialTransformationModule spatialTransformationModule) {
        if (spatialTransformationModule == null) {
            return REGULAR;
        }
        int n = spatialTransformationModule.getImageRotation();
        YN yN = spatialTransformationModule.getImageHorizontalFlip();
        DisplayedAreaOrientation[] displayedAreaOrientationArray = DisplayedAreaOrientation.values();
        int n2 = displayedAreaOrientationArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DisplayedAreaOrientation displayedAreaOrientation = displayedAreaOrientationArray[n3];
            if (displayedAreaOrientation.isCompatibleSpatialTransformation(n, yN)) {
                return displayedAreaOrientation;
            }
            ++n3;
        }
        return null;
    }

    public abstract boolean isCompatibleSpatialTransformation(int var1, YN var2);

    /* synthetic */ DisplayedAreaOrientation(String string, int n, DisplayedAreaOrientation displayedAreaOrientation) {
        this();
    }
}

