/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.presentationstate;

import com.agfa.pacs.impaxee.presentationstate.DisplayedAreaOrientation;
import com.agfa.pacs.listtext.dicomobject.module.ps.SpatialTransformationModule;
import com.tiani.jvision.image.fithandler.ImageDef;

public class PresentationStateImageBounds {
    public final int top;
    public final int left;
    public final int bottom;
    public final int right;

    public PresentationStateImageBounds(int n, int n2, int n3, int n4) {
        this.top = n;
        this.left = n2;
        this.bottom = n3;
        this.right = n4;
    }

    public PresentationStateImageBounds transform(ImageDef imageDef) {
        return this.transform(imageDef.toSpatialTransformationModule());
    }

    public PresentationStateImageBounds transform(SpatialTransformationModule spatialTransformationModule) {
        PresentationStateImageBounds presentationStateImageBounds;
        int n = Math.min(this.left, this.right);
        int n2 = Math.max(this.left, this.right);
        int n3 = Math.min(this.top, this.bottom);
        int n4 = Math.max(this.top, this.bottom);
        switch (DisplayedAreaOrientation.get(spatialTransformationModule)) {
            case REGULAR: {
                presentationStateImageBounds = new PresentationStateImageBounds(n3, n, n4, n2);
                break;
            }
            case TOP_BOTTOM_SWAPPED: {
                presentationStateImageBounds = new PresentationStateImageBounds(n4, n, n3, n2);
                break;
            }
            case LEFT_RIGHT_SWAPPED: {
                presentationStateImageBounds = new PresentationStateImageBounds(n3, n2, n4, n);
                break;
            }
            case ALL_SWAPPED: {
                presentationStateImageBounds = new PresentationStateImageBounds(n4, n2, n3, n);
                break;
            }
            default: {
                presentationStateImageBounds = null;
            }
        }
        return presentationStateImageBounds;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[(" + this.left + ',' + this.top + "),(" + this.right + ',' + this.bottom + ")]";
    }
}

