/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.presentationstate;

import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.impaxee.presentationstate.IPresentationState;
import com.agfa.pacs.impaxee.presentationstate.IPresentationStateProvider;
import com.agfa.pacs.impaxee.presentationstate.PresentationStatePool;
import com.agfa.pacs.impaxee.presentationstate.PresentationStateType;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedImage;
import com.agfa.pacs.listtext.dicomobject.iod.ps.SoftcopyPresentationStateInformationObject;
import com.agfa.pacs.listtext.dicomobject.module.ps.DisplayedArea;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicAnnotation;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicAnnotationModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicLayer;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.ModalityLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.SpatialTransformationModule;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.vis.VisData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class PresentationStatePoolCollector {
    private final Map<IStudyData, PresentationStatePool> psps;
    private final String label;
    private final String creator;
    private final String description;
    private final PresentationStateType type;
    private final Date creationDate = new Date();
    private boolean isMissingData;

    public PresentationStatePoolCollector(String string, String string2, String string3, PresentationStateType presentationStateType) {
        this.psps = new HashMap<IStudyData, PresentationStatePool>();
        this.label = string2;
        this.creator = string;
        this.description = string3;
        this.type = presentationStateType;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void addVisData(VisData visData) {
        IStudyData iStudyData = visData.getFrameData().getParent().getParent();
        IPresentationStateProvider iPresentationStateProvider = visData.getView().getPresentationStateProvider(this.type);
        IPresentationState iPresentationState = iPresentationStateProvider != null ? iPresentationStateProvider.getPresentationState() : this.hijackPresentationStatesOfFirstView(visData);
        if (iPresentationState != null) {
            this.addPresentationStateProvider(iStudyData, iPresentationState);
        } else {
            this.isMissingData = iPresentationStateProvider != null;
        }
    }

    private void addPresentationStateProvider(IStudyData iStudyData, IPresentationState iPresentationState) {
        PresentationStatePool presentationStatePool = this.psps.get(iStudyData);
        if (presentationStatePool == null) {
            presentationStatePool = new PresentationStatePool(iStudyData, false, this.creator, this.label, this.description, this.creationDate, this.type);
            this.psps.put(iStudyData, presentationStatePool);
        }
        presentationStatePool.addPresentationState(iPresentationState);
    }

    public List<Attributes> getPresentationStateDicomObjects() {
        ArrayList<Attributes> arrayList = new ArrayList<Attributes>();
        for (PresentationStatePool presentationStatePool : this.psps.values()) {
            List<SoftcopyPresentationStateInformationObject> list = presentationStatePool.getPresentationStateObjects();
            for (SoftcopyPresentationStateInformationObject softcopyPresentationStateInformationObject : list) {
                Attributes attributes = softcopyPresentationStateInformationObject.toDataset();
                attributes.setString(131088, VR.UI, "1.2.840.10008.1.2.1");
                arrayList.add(attributes);
            }
        }
        return arrayList;
    }

    public List<Pair<IStudyData, Set<ReferencedImage>>> getImagesWithAnnotations() {
        ArrayList<Pair<IStudyData, Set<ReferencedImage>>> arrayList = new ArrayList<Pair<IStudyData, Set<ReferencedImage>>>(1);
        for (PresentationStatePool presentationStatePool : this.psps.values()) {
            HashMap<String, ReferencedImage> hashMap = new HashMap<String, ReferencedImage>(5);
            List<SoftcopyPresentationStateInformationObject> list = presentationStatePool.getPresentationStateObjects();
            for (SoftcopyPresentationStateInformationObject softcopyPresentationStateInformationObject : list) {
                GraphicAnnotationModule graphicAnnotationModule = (GraphicAnnotationModule)softcopyPresentationStateInformationObject.getModule(GraphicAnnotationModule.class);
                if (graphicAnnotationModule == null) continue;
                List list2 = graphicAnnotationModule.graphicAnnotations();
                for (GraphicAnnotation graphicAnnotation : list2) {
                    Collection collection = graphicAnnotation.referencedImages().values();
                    for (ReferencedImage referencedImage : collection) {
                        if (hashMap.containsKey(referencedImage.getSOPInstanceUID())) {
                            if (referencedImage.getFrames() == null) continue;
                            ReferencedImage referencedImage2 = (ReferencedImage)hashMap.get(referencedImage.getSOPInstanceUID());
                            referencedImage2.setFrames(referencedImage.getFrames());
                            continue;
                        }
                        hashMap.put(referencedImage.getSOPInstanceUID(), referencedImage);
                    }
                }
            }
            if (hashMap.size() <= 0) continue;
            arrayList.add((Pair<IStudyData, Set<ReferencedImage>>)new ImmutablePair((Object)presentationStatePool.getStudyData(), new HashSet(hashMap.values())));
        }
        return arrayList;
    }

    public void storeInStudies(int n) {
        for (PresentationStatePool presentationStatePool : this.psps.values()) {
            presentationStatePool.storeInStudy(n);
        }
    }

    public Map<IStudyData, List<IObjectData>> getObjectData() {
        HashMap<IStudyData, List<IObjectData>> hashMap = new HashMap<IStudyData, List<IObjectData>>();
        for (PresentationStatePool presentationStatePool : this.psps.values()) {
            hashMap.put(presentationStatePool.getStudyData(), presentationStatePool.getObjectDatas());
        }
        return hashMap;
    }

    public boolean isEmpty() {
        return this.psps.isEmpty();
    }

    public boolean isMissingData() {
        return this.isMissingData;
    }

    private IPresentationState hijackPresentationStatesOfFirstView(VisData visData) {
        IPresentationState iPresentationState;
        IPresentationStateProvider iPresentationStateProvider;
        VisData visData2 = visData.getParent().getFirstVis();
        if (visData2 != null && (iPresentationStateProvider = visData2.getView().getPresentationStateProvider(this.type)) != null && (iPresentationState = iPresentationStateProvider.getPresentationState()) != null) {
            return new HijackingPresentationState(iPresentationState, visData, visData2.getFrameData().getRawDataContainer().getPixelDataFrame());
        }
        return null;
    }

    private static class HijackingPresentationState
    implements IPresentationState {
        private IPresentationState ps;
        private VisData vd;
        private IPixelDataFrame pdf;

        public HijackingPresentationState(IPresentationState iPresentationState, VisData visData, IPixelDataFrame iPixelDataFrame) {
            this.ps = iPresentationState;
            this.vd = visData;
            this.pdf = iPixelDataFrame;
        }

        @Override
        public DisplayedArea createDisplayedArea() {
            return this.ps.createDisplayedArea();
        }

        @Override
        public ReferencedImage createReferencedImage() {
            ReferencedImage referencedImage = new ReferencedImage();
            referencedImage.setSOPClassUID(this.vd.getImageInformation().getSOPClassUID());
            referencedImage.setSOPInstanceUID(this.vd.getImageInformation().getSOPInstanceUID());
            if (this.vd.getFrameData().getMainFrame().getFrameCount() != 1) {
                referencedImage.setFrame(this.vd.getFrameData().getFrameNumber() + 1);
            }
            return referencedImage;
        }

        @Override
        public SpatialTransformationModule createSpatialTransformationModule() {
            return this.ps.createSpatialTransformationModule();
        }

        @Override
        public int getColumns() {
            return this.ps.getColumns();
        }

        @Override
        public List<GraphicAnnotation> getGraphicAnnotations(List<GraphicLayer> list, PresentationStateType presentationStateType) {
            return null;
        }

        @Override
        public ModalityLUT getModalityLUT() {
            return this.ps.getModalityLUT();
        }

        @Override
        public PresentationLUT getPresentationLUT() {
            return this.ps.getPresentationLUT();
        }

        @Override
        public int getRows() {
            return this.ps.getRows();
        }

        @Override
        public String getSeriesInstanceUID() {
            return this.vd.getSequenceData().getSeriesInstanceUID();
        }

        @Override
        public IVOILUT getVOILUT(boolean bl) {
            IVOILUT iVOILUT;
            IImageInformation iImageInformation = this.vd.getImageInformation();
            IPixelDataFrame iPixelDataFrame = this.pdf;
            this.pdf = null;
            if (iImageInformation.getImageClass() == IImageInformation.ImageClass.MR && (iVOILUT = this.vd.getView().createVOILUTForHijackedPresentationState(bl, iPixelDataFrame)) != null) {
                return iVOILUT;
            }
            return this.ps.getVOILUT(bl);
        }

        @Override
        public boolean isIndexedColor() {
            return this.ps.isIndexedColor();
        }
    }
}

