/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.presentationstate;

import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.impaxee.presentationstate.AbstractPresentationState;
import com.agfa.pacs.impaxee.presentationstate.PresentationStateImageBounds;
import com.agfa.pacs.listtext.dicomobject.module.ps.DisplayedArea;
import com.agfa.pacs.listtext.dicomobject.module.ps.IDisplayedArea;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationSizeMode;
import com.agfa.pacs.listtext.dicomobject.module.ps.SpatialTransformationModule;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.WindowHandlerBase;
import com.tiani.jvision.image.fithandler.AreaFitHandler;
import com.tiani.jvision.image.fithandler.FullVisualFitHandler;
import com.tiani.jvision.image.fithandler.ImageDef;
import com.tiani.jvision.image.fithandler.PixelIdentityFitHandler;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.image.fithandler.TrueSizeFitHandler;
import com.tiani.jvision.info.IMutableImageState;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.renderer.IRDCRenderer;
import java.util.List;
import java.util.Set;
import org.dcm4che3.data.Attributes;

public class RDCPresentationState
extends AbstractPresentationState {
    private static final double FLOATING_POINT_TOLERANCE = 0.01;
    protected final IRDCRenderer renderer;

    public RDCPresentationState(IRDCRenderer iRDCRenderer, Set<View.CAPTURE_STATES> set) {
        super(set, RDCPresentationState.hasColorLUT(iRDCRenderer));
        this.renderer = iRDCRenderer;
    }

    private static boolean hasColorLUT(IRDCRenderer iRDCRenderer) {
        Attributes attributes = iRDCRenderer.getImageInformation().getDataset();
        return attributes.contains(2625795) && attributes.contains(2625794) && attributes.contains(2625793);
    }

    public static boolean isSupported(IFrameObjectData iFrameObjectData) {
        return UIDUtilities.getBaseType((String)iFrameObjectData.getSOPClassUID()) == UIDType.Image;
    }

    @Override
    protected IFrameObjectData getFrameData() {
        return this.renderer.getFrameObjectData();
    }

    protected ImageDef getActiveImageDef() {
        return this.renderer.getActiveImageDef();
    }

    @Override
    public boolean isIndexedColor() {
        return super.isIndexedColor() && this.getCurrentPresentationState().getForceLUT();
    }

    private IFramePresentationState getCurrentPresentationState() {
        return this.renderer.getCurrentFramePresentationState();
    }

    @Override
    protected DisplayedArea createDisplayedAreaImpl() {
        IDisplayedArea iDisplayedArea;
        IMutableImageState iMutableImageState = this.renderer.getImageState();
        SpacingDef spacingDef = iMutableImageState.getCurrentSpacingDef();
        ImageDef imageDef = this.getActiveImageDef();
        AreaFitHandler areaFitHandler = this.renderer.getAreaFitHandler();
        PresentationStateImageBounds presentationStateImageBounds = this.isDefaultDisplayedArea() ? new PresentationStateImageBounds(1, 1, imageDef.getRowCount(), imageDef.getColumnCount()).transform(imageDef) : this.getTopLeftBottomRightCorners();
        int n = presentationStateImageBounds.left;
        int n2 = presentationStateImageBounds.top;
        int n3 = presentationStateImageBounds.right;
        int n4 = presentationStateImageBounds.bottom;
        if (this.renderer.isBorderLockMode()) {
            int n5 = imageDef.getUntransformedColumns();
            int n6 = imageDef.getUntransformedRows();
            if (n < 0 && (double)Math.abs(n3 + n - n5) < 0.01 * (double)n5) {
                n3 += n;
                n = 0;
            } else if (n3 < 0 && (double)Math.abs(n3 + n - n5) < 0.01 * (double)n5) {
                n += n3;
                n3 = 0;
            }
            if (n2 < 0 && (double)Math.abs(n4 + n2 - n6) < 0.01 * (double)n6) {
                n4 += n2;
                n2 = 0;
            } else if (n4 < 0 && (double)Math.abs(n4 + n2 - n6) < 0.01 * (double)n6) {
                n2 += n4;
                n4 = 0;
            }
        }
        DisplayedArea displayedArea = new DisplayedArea();
        displayedArea.setDisplayedAreaTopLeftHandCorner(new int[]{n, n2});
        displayedArea.setDisplayedAreaBottomRightHandCorner(new int[]{n3, n4});
        double[] dArray = new double[]{spacingDef.getDataPixelSizeY(), spacingDef.getDataPixelSizeX()};
        PresentationSizeMode presentationSizeMode = null;
        if (areaFitHandler instanceof TrueSizeFitHandler) {
            presentationSizeMode = PresentationSizeMode.TrueSize;
            displayedArea.setPresentationPixelSpacing(dArray);
        } else if (areaFitHandler instanceof PixelIdentityFitHandler) {
            presentationSizeMode = PresentationSizeMode.Magnify;
            displayedArea.setPresentationPixelMagnificationRatio(Float.valueOf(1.0f));
        } else if (areaFitHandler instanceof FullVisualFitHandler) {
            presentationSizeMode = PresentationSizeMode.ScaleToFit;
        }
        displayedArea.setPresentationSizeMode(presentationSizeMode);
        if (spacingDef.getSizeUnit() != SpacingDef.Unit.pix) {
            displayedArea.setPresentationPixelSpacing(dArray);
        }
        int[] nArray = null;
        IFramePresentationState iFramePresentationState = this.getCurrentPresentationState();
        if (iFramePresentationState == null) {
            iFramePresentationState = this.renderer.getFrameObjectData().getFramePresentationState();
        }
        if ((iDisplayedArea = iFramePresentationState.getDisplayedArea()) != null && (nArray = iDisplayedArea.getPresentationPixelAspectRatio()) != null && dArray[0] == 1.0 && dArray[1] == 1.0) {
            dArray = null;
        }
        if (spacingDef.getSizeUnit() == SpacingDef.Unit.pix) {
            if (nArray != null) {
                displayedArea.setPresentationPixelAspectRatio(nArray);
            } else if (presentationSizeMode == PresentationSizeMode.ScaleToFit || presentationSizeMode == PresentationSizeMode.Magnify) {
                displayedArea.setPresentationPixelAspectRatio(new int[]{1, 1});
            }
        }
        return displayedArea;
    }

    protected boolean isDefaultDisplayedArea() {
        double[] dArray = this.getActiveImageDef().getTransformedViewportCenter();
        return dArray[0] == 0.5 && dArray[1] == 0.5 && this.renderer.getAreaFitHandler().isDefaultZoomFactor();
    }

    protected PresentationStateImageBounds getTopLeftBottomRightCorners() {
        AreaFitHandler areaFitHandler = this.renderer.getAreaFitHandler();
        if (areaFitHandler instanceof FullVisualFitHandler) {
            return ((FullVisualFitHandler)areaFitHandler).getDisplayedAreaForPS(this.getActiveImageDef());
        }
        IMutableImageState iMutableImageState = this.renderer.getImageState();
        double[] dArray = new double[]{0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0};
        iMutableImageState.screenToImage(dArray, dArray2, null);
        int n = (int)Math.round(dArray2[0]);
        int n2 = (int)Math.round(dArray2[1]);
        dArray[0] = dArray[0] + (double)iMutableImageState.getViewWidth();
        dArray[1] = dArray[1] + (double)iMutableImageState.getViewHeight();
        iMutableImageState.screenToImage(dArray, dArray2, null);
        int n3 = (int)Math.round(dArray2[0]);
        int n4 = (int)Math.round(dArray2[1]);
        return new PresentationStateImageBounds(++n2, ++n, n4, n3);
    }

    @Override
    protected SpatialTransformationModule createSpatialTransformationModuleImpl() {
        return this.getActiveImageDef().toSpatialTransformationModule();
    }

    @Override
    protected List<Overlay> getOverlays() {
        return this.renderer.getOverlays();
    }

    @Override
    protected WindowHandlerBase getWindowHandler() {
        return this.renderer.getWindowHandler();
    }

    @Override
    protected PresentationLUT getPresentationLUTImpl() {
        return this.renderer.getPresentationLUT();
    }
}

