/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.rotation;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.rotation.FreeRotationAngle;
import com.agfa.pacs.impaxee.rotation.FreeRotationPreChargeHandler;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.util.Objects;

class FreeRotationAction
extends AbstractPAction {
    private static final String ID_PREFIX_ABSOLUTE = "FREE_ROTATION_ABSOLUTE_";
    private static final String ID_PREFIX_RELATIVE = "FREE_ROTATION_RELATIVE_";
    private final String id;
    private final FreeRotationAngle angle;

    private FreeRotationAction(String string, FreeRotationAngle freeRotationAngle) {
        this.id = string;
        this.angle = freeRotationAngle;
    }

    static FreeRotationAction absolute(int n) {
        return new FreeRotationAction(ID_PREFIX_ABSOLUTE + n, FreeRotationAngle.absolute(Math.toRadians(n)));
    }

    static FreeRotationAction relative(int n) {
        return new FreeRotationAction(ID_PREFIX_RELATIVE + n, FreeRotationAngle.relative(Math.toRadians(n)));
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getGroupName() {
        return IMAGE_DISPLAY_GROUP;
    }

    @Override
    public String getCaption() {
        return Objects.toString(this.angle);
    }

    @Override
    public String getToolTipText() {
        return this.getCaption();
    }

    @Override
    public boolean isAvailable() {
        return Product.isRunningAutoTests();
    }

    @Override
    public boolean perform(Component component) {
        VisData visData = AbstractPDataAction.getCurrentImage();
        if (visData == null) {
            return false;
        }
        Vis2 vis2 = visData.getVisual();
        if (vis2 == null) {
            return false;
        }
        this.notifyActionPerformed();
        FreeRotationPreChargeHandler freeRotationPreChargeHandler = FreeRotationPreChargeHandler.create(vis2);
        if (freeRotationPreChargeHandler == null) {
            return false;
        }
        freeRotationPreChargeHandler.applyRotation(this.angle);
        return true;
    }
}

