/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.rotation;

import com.agfa.pacs.impaxee.rotation.FreeRotationImageState;
import com.agfa.pacs.impaxee.rotation.FreeRotationRenderer;
import com.agfa.pacs.tools.DoubleEquals;
import java.text.DecimalFormat;

public class FreeRotationAngle {
    private static final double ANGLE_COMPARISON_TOLERANCE = Math.toRadians(0.5);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.##");
    private final double theta;
    private final boolean isRelative;

    private FreeRotationAngle(double d, boolean bl) {
        this.theta = d;
        this.isRelative = bl;
    }

    public static FreeRotationAngle create(FreeRotationRenderer freeRotationRenderer) {
        double d = ((FreeRotationImageState)freeRotationRenderer.getImageState()).getRotationAngle();
        if (DoubleEquals.equals((double)d, (double)0.0, (double)ANGLE_COMPARISON_TOLERANCE)) {
            return null;
        }
        return FreeRotationAngle.absolute(d);
    }

    public static FreeRotationAngle absolute(double d) {
        return new FreeRotationAngle(d, false);
    }

    public static FreeRotationAngle relative(double d) {
        return new FreeRotationAngle(d, true);
    }

    double getRotationAngle() {
        return this.theta;
    }

    boolean isRelative() {
        return this.isRelative;
    }

    public String toString() {
        return (this.isRelative ? "Relative" : "Absolute") + " rotation by " + DECIMAL_FORMAT.format(Math.toDegrees(this.theta)) + '\u00b0';
    }
}

