/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.rotation;

import com.agfa.hap.pacs.data.valuemapping.IValueMapping;
import com.agfa.pacs.impaxee.rotation.FreeRotationAngle;
import com.agfa.pacs.math.Matrix2d;
import com.tiani.jvision.image.IWindowSettings;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.info.AbstractImageState;
import com.tiani.jvision.info.IImageState;
import com.tiani.jvision.info.IMutableImageState;
import com.tiani.jvision.info.ImageState;
import java.util.List;
import javax.vecmath.Point2i;
import javax.vecmath.Vector2d;

class FreeRotationImageState
extends AbstractImageState
implements IMutableImageState {
    private final ImageState imageState;
    private final double[] columnVector;
    private final double[] rowVector;
    private final Matrix2d rotatedToUnrotatedTransform = new Matrix2d();
    private final Matrix2d unrotatedToRotatedTransform = new Matrix2d();
    private double screenPixelSizeX;
    private double screenPixelSizeY;
    private double theta;
    private long lastUpdated = -1L;

    FreeRotationImageState(ImageState imageState, int n, int n2) {
        this.imageState = imageState;
        this.columnVector = new double[2];
        this.rowVector = new double[2];
        this.setViewSize(n, n2);
    }

    void setRotationAngle(FreeRotationAngle freeRotationAngle) {
        double d = freeRotationAngle.isRelative() ? this.theta + freeRotationAngle.getRotationAngle() : freeRotationAngle.getRotationAngle();
        this.setRotationAngle(d);
    }

    void setRotationAngle(double d) {
        while (d > Math.PI) {
            d -= Math.PI * 2;
        }
        this.theta = d;
        this.rotatedToUnrotatedTransform.set(Math.cos(d), Math.sin(d), -Math.sin(d), Math.cos(d));
        this.unrotatedToRotatedTransform.set(this.rotatedToUnrotatedTransform);
        this.unrotatedToRotatedTransform.invert();
        this.updated();
    }

    double getRotationAngle() {
        return this.theta;
    }

    @Override
    public final void setViewSize(int n, int n2) {
        if (this.getViewWidth() != n || this.getViewHeight() != n2) {
            super.setViewSize(n, n2);
            this.updated();
        }
    }

    @Override
    public Matrix2d getTransform() {
        Matrix2d matrix2d = this.imageState.getTransform();
        if (matrix2d == null) {
            return this.unrotatedToRotatedTransform;
        }
        Matrix2d matrix2d2 = new Matrix2d();
        matrix2d2.mul(this.unrotatedToRotatedTransform, matrix2d);
        return matrix2d2;
    }

    @Override
    public void updated() {
        this.imageState.updated();
    }

    private void updateIfNecessary() {
        if (this.lastUpdated != this.imageState.getUpdateStamp()) {
            double[] dArray = new double[]{0.0, 0.0};
            this.screenToImage(dArray, this.visOrig, null);
            this.rotateImageOrientationVector(this.imageState.getColumVectorX(), this.imageState.getColumVectorY(), this.columnVector);
            this.rotateImageOrientationVector(this.imageState.getRowVectorX(), this.imageState.getRowVectorY(), this.rowVector);
            Matrix2d matrix2d = new Matrix2d(this.imageState.getScreenToImageTransform());
            matrix2d.mul(this.rotatedToUnrotatedTransform);
            Vector2d vector2d = new Vector2d(1.0, 0.0);
            matrix2d.transform(vector2d);
            vector2d.x *= this.getDataPixelSizeX();
            vector2d.y *= this.getDataPixelSizeY();
            this.screenPixelSizeX = vector2d.length();
            vector2d.x = 0.0;
            vector2d.y = 1.0;
            matrix2d.transform(vector2d);
            vector2d.x *= this.getDataPixelSizeX();
            vector2d.y *= this.getDataPixelSizeY();
            this.screenPixelSizeY = vector2d.length();
            this.lastUpdated = this.imageState.getUpdateStamp();
        }
    }

    private void rotateImageOrientationVector(double d, double d2, double[] dArray) {
        double[] dArray2 = new double[]{0.0, 0.0};
        double[] dArray3 = new double[]{d, d2};
        this.rotatedToUnrotatedTransform.transform(dArray2);
        this.rotatedToUnrotatedTransform.transform(dArray3);
        dArray[0] = dArray3[0] - dArray2[0];
        dArray[1] = dArray3[1] - dArray2[1];
    }

    private void unrotatedToRotated(double[] dArray, double[] dArray2) {
        this.transform(dArray, dArray2, this.imageState, this, this.unrotatedToRotatedTransform);
    }

    Point2i rotatedToUnrotated(int n, int n2) {
        double[] dArray = new double[2];
        this.rotatedToUnrotated(new double[]{n, n2}, dArray);
        return new Point2i((int)Math.round(dArray[0]), (int)Math.round(dArray[1]));
    }

    private void rotatedToUnrotated(double[] dArray, double[] dArray2) {
        this.transform(dArray, dArray2, this, this.imageState, this.rotatedToUnrotatedTransform);
    }

    private void transform(double[] dArray, double[] dArray2, IImageState iImageState, IImageState iImageState2, Matrix2d matrix2d) {
        dArray2[0] = dArray[0] - (double)iImageState.getViewWidth() / 2.0;
        dArray2[1] = dArray[1] - (double)iImageState.getViewHeight() / 2.0;
        matrix2d.transform(dArray2);
        dArray2[0] = dArray2[0] + (double)iImageState2.getViewWidth() / 2.0;
        dArray2[1] = dArray2[1] + (double)iImageState2.getViewHeight() / 2.0;
    }

    @Override
    public void screenToImage(double[] dArray, double[] dArray2, Object object) {
        double[] dArray3 = new double[2];
        this.rotatedToUnrotated(dArray, dArray3);
        this.imageState.screenToImage(dArray3, dArray2, object);
    }

    @Override
    public void imageToScreen(double[] dArray, double[] dArray2, Object object) {
        double[] dArray3 = new double[2];
        this.imageState.imageToScreen(dArray, dArray3, object);
        this.unrotatedToRotated(dArray3, dArray2);
    }

    @Override
    public void imageToScreen(float f, float f2, double[] dArray, Object object) {
        double[] dArray2 = new double[2];
        this.imageState.imageToScreen(f, f2, dArray2, object);
        this.unrotatedToRotated(dArray2, dArray);
    }

    @Override
    protected Matrix2d getImageToScreenTransform() {
        Matrix2d matrix2d = new Matrix2d(this.unrotatedToRotatedTransform);
        matrix2d.mul(this.imageState.getImageToScreenTransform());
        return matrix2d;
    }

    @Override
    public double getVisOriginX() {
        this.updateIfNecessary();
        return super.getVisOriginX();
    }

    @Override
    public double getVisOriginY() {
        this.updateIfNecessary();
        return super.getVisOriginY();
    }

    @Override
    public double getColumVectorX() {
        this.updateIfNecessary();
        return this.columnVector[0];
    }

    @Override
    public double getColumVectorY() {
        this.updateIfNecessary();
        return this.columnVector[1];
    }

    @Override
    public double getRowVectorX() {
        this.updateIfNecessary();
        return this.rowVector[0];
    }

    @Override
    public double getRowVectorY() {
        this.updateIfNecessary();
        return this.rowVector[1];
    }

    @Override
    public void setToCommon(IMutableImageState iMutableImageState, IMutableImageState iMutableImageState2) {
        this.imageState.setToCommon(iMutableImageState, iMutableImageState2);
    }

    @Override
    public SpacingDef getCurrentSpacingDef() {
        return this.imageState.getCurrentSpacingDef();
    }

    @Override
    public void selectCurrentSpacingDef(SpacingDef spacingDef) {
        this.imageState.selectCurrentSpacingDef(spacingDef);
    }

    @Override
    public IValueMapping getCurrentValueMapping() {
        return this.imageState.getCurrentValueMapping();
    }

    @Override
    public void setCurrentValueMapping(IValueMapping iValueMapping) {
        this.imageState.setCurrentValueMapping(iValueMapping);
    }

    @Override
    public double getScreenPixelSizeX() {
        this.updateIfNecessary();
        return this.screenPixelSizeX;
    }

    @Override
    public double getScreenPixelSizeY() {
        this.updateIfNecessary();
        return this.screenPixelSizeY;
    }

    @Override
    public void setScreenPixelSize(double d, double d2) {
        this.imageState.setScreenPixelSize(d, d2);
    }

    @Override
    public double getDataPixelSizeX() {
        return this.imageState.getDataPixelSizeX();
    }

    @Override
    public double getDataPixelSizeY() {
        return this.imageState.getDataPixelSizeY();
    }

    @Override
    public double getDataPixelSizeY(Object object) {
        return this.imageState.getDataPixelSizeY(object);
    }

    @Override
    public double getDataPixelSizeX(Object object) {
        return this.imageState.getDataPixelSizeX(object);
    }

    @Override
    public String getDimensionUnit() {
        return this.imageState.getDimensionUnit();
    }

    @Override
    public SpacingDef.Unit getSizeUnit() {
        return this.imageState.getSizeUnit();
    }

    @Override
    public List<SpacingDef> spacingDefs() {
        return this.imageState.spacingDefs();
    }

    @Override
    public IWindowSettings getWindow() {
        return this.imageState.getWindow();
    }

    @Override
    public long getUpdateStamp() {
        return this.imageState.getUpdateStamp();
    }
}

