/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.rotation;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.rotation.FreeRotationAngle;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.util.message.Message;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

public class FreeRotationPreChargeHandler
extends MouseInputAdapter {
    static final Cursor CURSOR = FreeRotationPreChargeHandler.createCursor();
    private static final int PIXEL_PER_DEGREE = 10;
    private static final double PIXEL_TO_RADIANS_FACTOR = Math.toRadians(0.1);
    private final ImgView2 view;
    private int latestY;
    private RotationDirection direction = RotationDirection.CLOCKWISE;

    private FreeRotationPreChargeHandler(ImgView2 imgView2) {
        this.view = imgView2;
    }

    private static Cursor createCursor() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.createImage(FreeRotationPreChargeHandler.class.getClassLoader().getResource("/icons/free_rotation_cursor.gif"));
        return toolkit.createCustomCursor(image, new Point(15, 15), "free_rotation");
    }

    public static FreeRotationPreChargeHandler create(Vis2 vis2) {
        if (vis2 == null || !vis2.hasData()) {
            return null;
        }
        if (vis2.getVisDisplay().getVisScreen() == null) {
            return null;
        }
        VisDisplayData visDisplayData = vis2.getData().getParent();
        if (!visDisplayData.getPlugin().isDefaultPlugin()) {
            FreeRotationPreChargeHandler.warnOfUnsupportedPlugin();
            return null;
        }
        if (visDisplayData.getDisplaySet().isBeingLossyPrefetched()) {
            Message.info(Messages.getString("FreeRotationPreChargeHandler.LossyDataNotSupported.Title"), Messages.getString("FreeRotationPreChargeHandler.LossyDataNotSupported.Message"));
            return null;
        }
        View view = vis2.getView();
        if (!(view instanceof ImgView2)) {
            FreeRotationPreChargeHandler.warnOfUnsupportedPlugin();
            return null;
        }
        return new FreeRotationPreChargeHandler((ImgView2)view);
    }

    private static void warnOfUnsupportedPlugin() {
        Message.info(Messages.getString("FreeRotationPreChargeHandler.NonDefaultPlugin.Title"), Messages.getString("FreeRotationPreChargeHandler.NonDefaultPlugin.Message"));
    }

    public void applyRotation(FreeRotationAngle freeRotationAngle) {
        if (freeRotationAngle != null) {
            this.view.handleFreeRotationStart();
        }
        this.view.handleFreeRotationEnd(freeRotationAngle);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.view.handleFreeRotationStart();
        this.setLatestMousePosition(mouseEvent);
        this.direction = mouseEvent.getX() < this.view.getcwidth() / 2 ? RotationDirection.CLOCKWISE : RotationDirection.COUNTERCLOCKWISE;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.view.handleFreeRotationProgress(this.getRelativeRotationSinceLastUpdate(mouseEvent));
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.view.handleFreeRotationEnd(this.getRelativeRotationSinceLastUpdate(mouseEvent));
    }

    private FreeRotationAngle getRelativeRotationSinceLastUpdate(MouseEvent mouseEvent) {
        FreeRotationAngle freeRotationAngle = FreeRotationAngle.relative((double)(this.direction.signum * (this.latestY - mouseEvent.getY())) * PIXEL_TO_RADIANS_FACTOR);
        this.setLatestMousePosition(mouseEvent);
        return freeRotationAngle;
    }

    private void setLatestMousePosition(MouseEvent mouseEvent) {
        this.latestY = mouseEvent.getY();
    }

    private static enum RotationDirection {
        CLOCKWISE(1),
        COUNTERCLOCKWISE(-1);

        final int signum;

        private RotationDirection(int n2) {
            this.signum = n2;
        }
    }
}

