/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.rotation;

import com.agfa.pacs.impaxee.presentationstate.PresentationStateImageBounds;
import com.agfa.pacs.impaxee.presentationstate.RDCPresentationState;
import com.agfa.pacs.impaxee.rotation.FreeRotationImageState;
import com.agfa.pacs.impaxee.rotation.FreeRotationRenderer;
import com.agfa.pacs.listtext.dicomobject.module.ps.DisplayedArea;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationSizeMode;
import com.agfa.pacs.listtext.dicomobject.module.ps.SpatialTransformationModule;
import com.agfa.pacs.math.Matrix2d;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.fithandler.FullVisualFitHandler;
import com.tiani.jvision.image.fithandler.ImageDef;
import com.tiani.jvision.info.IMutableImageState;
import java.util.Set;

class FreeRotationPresentationState
extends RDCPresentationState {
    private static final double DEGREES_45_IN_RAD = 0.7853981633974483;
    private static final double DEGREES_90_IN_RAD = 1.5707963267948966;
    private final ImageDef psImageDef;
    private final double theta;

    FreeRotationPresentationState(FreeRotationRenderer freeRotationRenderer, Set<View.CAPTURE_STATES> set) {
        super(freeRotationRenderer, set);
        this.psImageDef = new ImageDef(freeRotationRenderer.getActiveImageDef());
        this.theta = FreeRotationPresentationState.initRotationAngle(this.psImageDef, ((FreeRotationImageState)freeRotationRenderer.getImageState()).getRotationAngle());
    }

    private static double initRotationAngle(ImageDef imageDef, double d) {
        double d2 = d;
        while (d2 > 0.7853981633974483) {
            d2 -= 1.5707963267948966;
            imageDef.applyTransform(Matrix2d.trafoRotR);
        }
        while (d2 < -0.7853981633974483) {
            d2 += 1.5707963267948966;
            imageDef.applyTransform(Matrix2d.trafoRotL);
        }
        return d2;
    }

    @Override
    protected ImageDef getActiveImageDef() {
        return this.psImageDef;
    }

    @Override
    public DisplayedArea createDisplayedArea() {
        DisplayedArea displayedArea = super.createDisplayedArea();
        if (displayedArea != null && displayedArea.getPresentationSizeMode() == PresentationSizeMode.ScaleToFit && !this.isDefaultDisplayedArea()) {
            PresentationStateImageBounds presentationStateImageBounds = ((FullVisualFitHandler)this.renderer.getAreaFitHandler()).getDisplayedAreaForPS(this.psImageDef);
            displayedArea.setFreeRotationDisplayedArea(presentationStateImageBounds.left, presentationStateImageBounds.top, presentationStateImageBounds.right, presentationStateImageBounds.bottom);
        }
        return displayedArea;
    }

    @Override
    protected PresentationStateImageBounds getTopLeftBottomRightCorners() {
        double[] dArray = new double[]{0.0, 0.0};
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        double[] dArray5 = new double[2];
        IMutableImageState iMutableImageState = this.renderer.getImageState();
        iMutableImageState.screenToImage(dArray, dArray2, null);
        dArray[0] = iMutableImageState.getViewWidth();
        iMutableImageState.screenToImage(dArray, dArray3, null);
        dArray[1] = iMutableImageState.getViewHeight();
        iMutableImageState.screenToImage(dArray, dArray4, null);
        dArray[0] = 0.0;
        iMutableImageState.screenToImage(dArray, dArray5, null);
        return new PresentationStateImageBounds((int)Math.round(Math.min(Math.min(dArray2[1], dArray3[1]), Math.min(dArray4[1], dArray5[1]))) + 1, (int)Math.round(Math.min(Math.min(dArray2[0], dArray3[0]), Math.min(dArray4[0], dArray5[0]))) + 1, (int)Math.round(Math.max(Math.max(dArray2[1], dArray3[1]), Math.max(dArray4[1], dArray5[1]))), (int)Math.round(Math.max(Math.max(dArray2[0], dArray3[0]), Math.max(dArray4[0], dArray5[0])))).transform(this.getActiveImageDef());
    }

    @Override
    public SpatialTransformationModule createSpatialTransformationModule() {
        SpatialTransformationModule spatialTransformationModule = super.createSpatialTransformationModule();
        if (spatialTransformationModule != null) {
            spatialTransformationModule.setFreeRotationAngle(Double.valueOf(this.theta));
        }
        return spatialTransformationModule;
    }
}

