/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.rotation;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.impaxee.presentationstate.IPresentationState;
import com.agfa.pacs.impaxee.rotation.FreeRotationAngle;
import com.agfa.pacs.impaxee.rotation.FreeRotationFitHandler;
import com.agfa.pacs.impaxee.rotation.FreeRotationFramePresentationState;
import com.agfa.pacs.impaxee.rotation.FreeRotationImageState;
import com.agfa.pacs.impaxee.rotation.FreeRotationPresentationState;
import com.agfa.pacs.impaxee.rotation.FreeRotationSnapOutputGeometry;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.SpatialTransformationModule;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformationProvider;
import com.tiani.base.data.IRegionInfoSource;
import com.tiani.base.data.RawDataContainer;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.image.DoubleDimension;
import com.tiani.jvision.image.IPickingHandler;
import com.tiani.jvision.image.MousePositionDestination;
import com.tiani.jvision.image.SnapOutputGeometry;
import com.tiani.jvision.image.TransferFunction;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewSnapshot;
import com.tiani.jvision.image.WindowHandlerBase;
import com.tiani.jvision.image.fithandler.AreaFitHandler;
import com.tiani.jvision.image.fithandler.ImageDef;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.image.fithandler.ViewportDefinition;
import com.tiani.jvision.image.fithandler.ViewportDefinitionType;
import com.tiani.jvision.image.fithandler.ZoomRestorePayload;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlayBitmap;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.renderer.AbstractLeafRenderer;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.RDCRenderer;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisHRSet;
import com.tiani.util.message.Message;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point2i;
import javax.vecmath.Tuple2i;
import org.dcm4che3.data.Attributes;

public final class FreeRotationRenderer
extends AbstractLeafRenderer<FreeRotationImageState>
implements IRDCRenderer,
RDCRenderer.IClearPresentationStateListener {
    private static final ALogger LOGGER = ALogger.getLogger(FreeRotationRenderer.class);
    private RDCRenderer renderer;

    public FreeRotationRenderer(RDCRenderer rDCRenderer, int n, int n2) {
        super(new FreeRotationImageState((ImageState)rDCRenderer.getImageState(), n, n2), rDCRenderer.getImageInformation());
        this.renderer = rDCRenderer;
        this.disableBorderLockMode();
        this.moveSupportedOverlays(rDCRenderer.getOverlays(), n, n2);
        this.updateAreaFitHandler();
    }

    @Override
    public FreeRotationRenderer clone() {
        FreeRotationRenderer freeRotationRenderer = (FreeRotationRenderer)super.clone();
        freeRotationRenderer.renderer = this.renderer.clone();
        int n = ((FreeRotationImageState)this.imageState).getViewWidth();
        int n2 = ((FreeRotationImageState)this.imageState).getViewHeight();
        freeRotationRenderer.imageState = new FreeRotationImageState((ImageState)freeRotationRenderer.renderer.getImageState(), n, n2);
        ((FreeRotationImageState)freeRotationRenderer.imageState).setRotationAngle(((FreeRotationImageState)this.imageState).getRotationAngle());
        freeRotationRenderer.updateAreaFitHandler();
        return freeRotationRenderer;
    }

    @Override
    public RDCRenderer disableFreeRotation() {
        IImageInformationProvider iImageInformationProvider2;
        for (IImageInformationProvider iImageInformationProvider2 : this.getOverlays()) {
            this.moveOverlayTo((Overlay)iImageInformationProvider2, this.renderer);
        }
        this.renderer.setAreaFitHandler(FreeRotationFitHandler.unwrap(this.getAreaFitHandler()));
        iImageInformationProvider2 = this.renderer;
        this.renderer = null;
        this.cleanUp();
        return iImageInformationProvider2;
    }

    public void applyRotation(FreeRotationAngle freeRotationAngle) {
        ((FreeRotationImageState)this.imageState).setRotationAngle(freeRotationAngle);
    }

    @Override
    public MousePositionDestination getMouseFollower() {
        return this;
    }

    @Override
    public IRegionInfoSource getRegionSource() {
        return this.getRegionInfoSourceOverlay(this.renderer.getRegionSource());
    }

    @Override
    public String getInfoAt(int n, int n2, int n3, int n4) {
        if (this.isInvalid() || this.renderer.isInvalid()) {
            ((FreeRotationImageState)this.getImageState()).setViewSize(n3, n4);
        }
        int n5 = FreeRotationRenderer.getUnrotatedViewSize(n3, n4);
        Point2i point2i = ((FreeRotationImageState)this.getImageState()).rotatedToUnrotated(n, n2);
        return this.renderer.getInfoAt(point2i.x, point2i.y, n5, n5);
    }

    static int getUnrotatedViewSize(int n, int n2) {
        return (int)Math.ceil(Math.sqrt((long)n * (long)n + (long)(n2 * n2)));
    }

    @Override
    public IPickingHandler getPickingHandler() {
        return this.renderer.getPickingHandler();
    }

    @Override
    public AreaFitHandler getAreaFitHandler() {
        return this.renderer.getAreaFitHandler();
    }

    @Override
    public final void setAreaFitHandler(AreaFitHandler areaFitHandler) {
        this.renderer.setAreaFitHandler(this.encapsulateAreaFitHandler(areaFitHandler));
    }

    private void updateAreaFitHandler() {
        this.setAreaFitHandler(this.renderer.getAreaFitHandler());
    }

    private AreaFitHandler encapsulateAreaFitHandler(AreaFitHandler areaFitHandler) {
        return FreeRotationFitHandler.encapsulate(areaFitHandler, this.getImageState());
    }

    @Override
    public DoubleDimension getDefaultDisplayedAreaSize() {
        return this.renderer.getDefaultDisplayedAreaSize();
    }

    @Override
    public WindowHandlerBase getWindowHandler() {
        return this.renderer.getWindowHandler();
    }

    @Override
    public IFrameObjectData getFrameObjectData() {
        return this.renderer.getFrameObjectData();
    }

    @Override
    public RawDataContainer getRawDataContainer() {
        return this.renderer.getRawDataContainer();
    }

    @Override
    public IPresentationState getPresentationState() {
        return this.getPresentationState(this.renderer.captureStates());
    }

    @Override
    public IPresentationState getPresentationState(Set<View.CAPTURE_STATES> set) {
        return this.getPresentationState(0, 0, set);
    }

    @Override
    public IPresentationState getPresentationState(int n, int n2) {
        return this.getPresentationState(n, n2, this.renderer.captureStates());
    }

    private IPresentationState getPresentationState(int n, int n2, Set<View.CAPTURE_STATES> set) {
        if (n > 0 && n2 > 0) {
            this.updateGeometry(n, n2);
        }
        return new FreeRotationPresentationState(this, set);
    }

    @Override
    public void clearPresentationState(IFramePresentationState iFramePresentationState) {
        this.onClearPresentationState(iFramePresentationState);
        this.renderer.clearPresentationState(iFramePresentationState);
    }

    @Override
    public void onClearPresentationState(IFramePresentationState iFramePresentationState) {
        ((FreeRotationImageState)this.imageState).setRotationAngle(0.0);
        this.clearOverlaysForPresentationState(iFramePresentationState);
    }

    @Override
    public List<PresentationObject> applyPresentationState(IFramePresentationState iFramePresentationState) {
        double d;
        SpatialTransformationModule spatialTransformationModule = iFramePresentationState.getSpatialTransformation();
        if (spatialTransformationModule != null && spatialTransformationModule.hasFreeRotation()) {
            d = Math.toRadians(spatialTransformationModule.getImageRotation().intValue()) + spatialTransformationModule.getFreeRotationAngle();
            Attributes attributes = new Attributes();
            spatialTransformationModule.writeTo(attributes);
            spatialTransformationModule = new SpatialTransformationModule();
            spatialTransformationModule.readFrom(attributes);
            spatialTransformationModule.setImageRotation(Integer.valueOf(0));
        } else {
            d = Double.NaN;
        }
        int n = ((FreeRotationImageState)this.imageState).getViewWidth();
        int n2 = ((FreeRotationImageState)this.imageState).getViewHeight();
        this.renderer.setGeometry(n, n2, 0, n);
        List<PresentationObject> list = this.renderer.applyPresentationState((IFramePresentationState)new FreeRotationFramePresentationState(iFramePresentationState, spatialTransformationModule), this);
        this.moveSupportedOverlays(list, n, n2);
        if (!Double.isNaN(d)) {
            ((FreeRotationImageState)this.imageState).setRotationAngle(d);
        }
        this.updateAreaFitHandler();
        return list;
    }

    @Override
    public IFramePresentationState getCurrentFramePresentationState() {
        return this.renderer.getCurrentFramePresentationState();
    }

    @Override
    public PresentationLUT getPresentationLUT() {
        return this.renderer.getPresentationLUT();
    }

    @Override
    public void setBorderLockMode(boolean bl) {
        if (bl) {
            LOGGER.info("Border lock mode not supported for free rotation");
        } else {
            this.renderer.setBorderLockMode(false);
        }
    }

    @Override
    public boolean isBorderLockMode() {
        return this.renderer.isBorderLockMode();
    }

    private void disableBorderLockMode() {
        if (this.renderer.isBorderLockMode()) {
            LOGGER.info("Border lock mode not supported for free rotation");
            this.renderer.setBorderLockMode(false);
        }
    }

    @Override
    public double getScreenPixelSizeX() {
        return this.renderer.getScreenPixelSizeX();
    }

    @Override
    public SpacingDef getCurrentSpacingDef() {
        return ((FreeRotationImageState)this.getImageState()).getCurrentSpacingDef();
    }

    @Override
    public ImageDef getActiveImageDef() {
        return this.renderer.getActiveImageDef();
    }

    @Override
    public double[] getInterchangeableViewportCenter() {
        return this.renderer.getInterchangeableViewportCenter();
    }

    @Override
    public void clearWindowingCache() {
        this.renderer.clearWindowingCache();
    }

    @Override
    public boolean isImageLoaded() {
        return this.renderer.isImageLoaded();
    }

    @Override
    public void checkImageLoaded() {
        this.renderer.checkImageLoaded();
    }

    private void updateGeometry(int n, int n2) {
        ((FreeRotationImageState)this.getImageState()).setViewSize(n, n2);
        this.updateOverlays(n, n2);
    }

    @Override
    public void paint(RGBBufferedImageHolder rGBBufferedImageHolder, int n, int n2, int n3, int n4, boolean bl) {
        this.updateGeometry(n, n2);
        int n5 = FreeRotationRenderer.getUnrotatedViewSize(n, n2);
        RGBBufferedImageHolder rGBBufferedImageHolder2 = new RGBBufferedImageHolder(n5, n5);
        this.renderer.paint(rGBBufferedImageHolder2, rGBBufferedImageHolder2.width, rGBBufferedImageHolder2.height, rGBBufferedImageHolder2.iofs, rGBBufferedImageHolder2.iline, bl);
        this.renderer.paintOverlays(rGBBufferedImageHolder2, null, false);
        this.paintTo(rGBBufferedImageHolder, n, n2, n3, n4, rGBBufferedImageHolder2);
        rGBBufferedImageHolder2.release();
        this.setValid();
    }

    private void paintTo(RGBBufferedImageHolder rGBBufferedImageHolder, int n, int n2, int n3, int n4, RGBBufferedImageHolder rGBBufferedImageHolder2) {
        if (rGBBufferedImageHolder.width == n && rGBBufferedImageHolder.height == n2 && n3 == 0 && n4 == n) {
            this.paintTo(rGBBufferedImageHolder, rGBBufferedImageHolder2);
        } else {
            RGBBufferedImageHolder rGBBufferedImageHolder3 = new RGBBufferedImageHolder(n, n2);
            this.paintTo(rGBBufferedImageHolder3, rGBBufferedImageHolder2);
            int n5 = n3 / n4;
            int n6 = n3 - n5 * n4;
            Graphics2D graphics2D = rGBBufferedImageHolder.image.createGraphics();
            graphics2D.drawImage(rGBBufferedImageHolder3.image, null, n6, n5);
            rGBBufferedImageHolder3.release();
            graphics2D.dispose();
        }
    }

    private void paintTo(RGBBufferedImageHolder rGBBufferedImageHolder, RGBBufferedImageHolder rGBBufferedImageHolder2) {
        Graphics2D graphics2D = rGBBufferedImageHolder.image.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        double d = (double)rGBBufferedImageHolder.width / 2.0;
        double d2 = (double)rGBBufferedImageHolder.height / 2.0;
        graphics2D.translate(d, d2);
        graphics2D.rotate(((FreeRotationImageState)this.imageState).getRotationAngle());
        graphics2D.translate(-d, -d2);
        graphics2D.drawImage(rGBBufferedImageHolder2.image, null, (rGBBufferedImageHolder.width - rGBBufferedImageHolder2.width) / 2, (rGBBufferedImageHolder.height - rGBBufferedImageHolder2.height) / 2);
        graphics2D.dispose();
    }

    @Override
    public Object getRaw(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        throw new UnsupportedOperationException("Retrieving raw data not supported in case of free rotation");
    }

    @Override
    public int getMaxRawValue() {
        return this.renderer.getMaxRawValue();
    }

    @Override
    public int getRawValueOffset() {
        return this.renderer.getRawValueOffset();
    }

    @Override
    public int[] getLUTForRaw() {
        return this.renderer.getLUTForRaw();
    }

    @Override
    public VisHRSet getHRSet(VisHRSet visHRSet, Vis2 vis2, View view) {
        return this.renderer.getHRSet(visHRSet, vis2, view);
    }

    @Override
    public boolean handleHotRegionPressed(String string, Rectangle rectangle, MouseEvent mouseEvent, View view) {
        return this.renderer.handleHotRegionPressed(string, rectangle, mouseEvent, view);
    }

    @Override
    public boolean handleHotRegionDragged(String string, MouseEvent mouseEvent, int n, int n2, int n3, int n4, View view) {
        if ("PAN".equals(string)) {
            Point2i point2i = ((FreeRotationImageState)this.getImageState()).rotatedToUnrotated(0, 0);
            Point2i point2i2 = ((FreeRotationImageState)this.getImageState()).rotatedToUnrotated(n, n2);
            Point2i point2i3 = ((FreeRotationImageState)this.getImageState()).rotatedToUnrotated(n3, n4);
            point2i2.sub((Tuple2i)point2i);
            point2i3.sub((Tuple2i)point2i);
            return this.renderer.handleHotRegionDragged(string, mouseEvent, point2i2.x, point2i2.y, point2i3.x, point2i3.y, view);
        }
        return this.renderer.handleHotRegionDragged(string, mouseEvent, n, n2, n3, n4, view);
    }

    @Override
    public boolean handleHotRegionReleased(String string, MouseEvent mouseEvent, int n, int n2, View view) {
        if ("PAN".equals(string)) {
            Point2i point2i = ((FreeRotationImageState)this.getImageState()).rotatedToUnrotated(0, 0);
            Point2i point2i2 = ((FreeRotationImageState)this.getImageState()).rotatedToUnrotated(n, n2);
            point2i2.sub((Tuple2i)point2i);
            return this.renderer.handleHotRegionReleased(string, mouseEvent, point2i2.x, point2i2.y, view);
        }
        return this.renderer.handleHotRegionReleased(string, mouseEvent, n, n2, view);
    }

    @Override
    public boolean wantsMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        return this.renderer.wantsMouseWheelEvent(mouseWheelEvent);
    }

    @Override
    public boolean handleMouseWheel(MouseWheelEvent mouseWheelEvent, View view) {
        return this.renderer.handleMouseWheel(this.convertMouseWheelEvent(mouseWheelEvent), view);
    }

    private MouseWheelEvent convertMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        Point2i point2i = ((FreeRotationImageState)this.getImageState()).rotatedToUnrotated(mouseWheelEvent.getX(), mouseWheelEvent.getY());
        return new MouseWheelEvent(mouseWheelEvent.getComponent(), mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers() | mouseWheelEvent.getModifiersEx(), point2i.x, point2i.y, mouseWheelEvent.getXOnScreen(), mouseWheelEvent.getYOnScreen(), mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation(), mouseWheelEvent.getPreciseWheelRotation());
    }

    @Override
    public boolean handleTEvent(TEvent tEvent, Object object, int n, View view) {
        if (tEvent.id == 7 || tEvent.id == 8) {
            ((FreeRotationImageState)this.getImageState()).setRotationAngle(-((FreeRotationImageState)this.getImageState()).getRotationAngle());
        } else if (tEvent.id == 79) {
            ZoomRestorePayload zoomRestorePayload = (ZoomRestorePayload)object;
            object = new ZoomRestorePayload(this.encapsulateAreaFitHandler(zoomRestorePayload.getOriginalFitHandler()), zoomRestorePayload.getRelativeZoomFactorChange());
        } else if (tEvent.id == 80) {
            object = this.encapsulateAreaFitHandler((AreaFitHandler)object);
        } else if (tEvent.id == 17 && object instanceof ViewportDefinition && ((ViewportDefinition)object).getType() == ViewportDefinitionType.RELATIVE) {
            LOGGER.warn("Discarding unsupported relative viewport definition");
            return false;
        }
        return this.renderer.handleTEvent(tEvent, object, n, view);
    }

    @Override
    public void broadcastViewportChange(ViewportDefinition viewportDefinition) {
        this.renderer.broadcastViewportChange(viewportDefinition);
    }

    @Override
    public boolean startRectangleZoom() {
        EventQueue.invokeLater(() -> Message.info(Messages.getString("FreeRotationRenderer.RectangleZoomNotSupported.Title"), Messages.getString("FreeRotationRenderer.RectangleZoomNotSupported.Message")));
        return false;
    }

    @Override
    public void setGeometry(int n, int n2, int n3, int n4) {
        this.updateGeometry(n, n2);
        int n5 = FreeRotationRenderer.getUnrotatedViewSize(n, n2);
        this.renderer.setGeometry(n5, n5, 0, n5);
    }

    @Override
    public Color getBackgroundColor() {
        return this.renderer.getBackgroundColor();
    }

    @Override
    public void updateImageState() {
        this.renderer.updateImageState();
    }

    @Override
    public void getOptimumOutputSize(SnapOutputGeometry snapOutputGeometry) {
        throw new UnsupportedOperationException("Determining optimum output size not supported in case of free rotation");
    }

    @Override
    public void storeToSnapshot(ViewSnapshot viewSnapshot, SnapOutputGeometry snapOutputGeometry) {
        View.OverlayMode overlayMode;
        View.OverlayMode overlayMode2 = viewSnapshot.getOverlayMode();
        switch (overlayMode2) {
            case PRINT_OVERLAY_ROI: {
                overlayMode = View.OverlayMode.PRINT_BURN_ROI;
                break;
            }
            case PRINT_OVERLAY_ALL_AND_ROI: {
                overlayMode = View.OverlayMode.PRINT_BURN_MAPPINGS;
                break;
            }
            case PRINT_BURN_MAPPINGS: 
            case PRINT_OVERLAY_ALL: 
            case PRINT_OVERLAY_NONE: 
            case PRINT_BURN_ROI: {
                overlayMode = overlayMode2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported overlay mode: " + (Object)((Object)overlayMode2));
            }
        }
        int n = FreeRotationRenderer.getUnrotatedViewSize(viewSnapshot.getWidth(), viewSnapshot.getHeight());
        ViewSnapshot viewSnapshot2 = new ViewSnapshot(overlayMode, n, n, true);
        SnapOutputGeometry snapOutputGeometry2 = FreeRotationSnapOutputGeometry.create(viewSnapshot, snapOutputGeometry);
        this.renderer.storeToSnapshot(viewSnapshot2, snapOutputGeometry2);
        this.renderer.storeOverlaysToSnapshot(viewSnapshot2, snapOutputGeometry2);
        RGBBufferedImageHolder rGBBufferedImageHolder = new RGBBufferedImageHolder(viewSnapshot.getWidth(), viewSnapshot.getHeight());
        this.paintTo(rGBBufferedImageHolder, rGBBufferedImageHolder.width, rGBBufferedImageHolder.height, rGBBufferedImageHolder.iofs, rGBBufferedImageHolder.iline, viewSnapshot2.getDataBufferAsImage());
        viewSnapshot.setDataBuffer(rGBBufferedImageHolder.data, viewSnapshot.getWidth() * viewSnapshot.getHeight());
    }

    @Override
    public void storeOverlaysToSnapshot(ViewSnapshot viewSnapshot, SnapOutputGeometry snapOutputGeometry) {
        viewSnapshot.applyOverlays(super.getOverlays());
    }

    @Override
    public List<Overlay> getOverlays() {
        ArrayList<Overlay> arrayList = new ArrayList<Overlay>(super.getOverlays());
        arrayList.addAll(this.renderer.getOverlays());
        return arrayList;
    }

    private void moveSupportedOverlays(Iterable<? extends Overlay> iterable, int n, int n2) {
        FreeRotationImageState freeRotationImageState = (FreeRotationImageState)this.getImageState();
        for (Overlay overlay : iterable) {
            if (!this.isOverlaySupported(overlay)) continue;
            this.renderer.moveOverlayTo(overlay, this);
            overlay.setSize(n, n2, freeRotationImageState);
        }
    }

    private boolean isOverlaySupported(Overlay overlay) {
        return !(overlay instanceof OverlayBitmap);
    }

    @Override
    public void addOverlay(Overlay overlay) {
        if (this.isOverlaySupported(overlay)) {
            super.addOverlay(overlay);
        } else {
            this.renderer.addOverlay(overlay);
        }
    }

    @Override
    public void removeOverlay(Overlay overlay) {
        super.removeOverlay(overlay);
        this.renderer.removeOverlay(overlay);
    }

    @Override
    public void removeAllROIs() {
        super.removeAllROIs();
        this.renderer.removeAllROIs();
    }

    @Override
    public void removeAllNonImageOverlayBitmaps() {
        super.removeAllNonImageOverlayBitmaps();
        this.renderer.removeAllNonImageOverlayBitmaps();
    }

    @Override
    public void removeAll(Class<? extends Overlay> clazz) {
        super.removeAll(clazz);
        this.renderer.removeAll(clazz);
    }

    @Override
    public TransferFunction getTransferFunction() {
        return this.renderer.getTransferFunction();
    }

    @Override
    public void synchronizeWith(Renderer renderer) {
        throw new UnsupportedOperationException("Synchronizing a free rotation renderer with another one is not supported");
    }

    @Override
    public void initValueMappings(VisDisplay2 visDisplay2) {
        this.renderer.initValueMappings(visDisplay2);
    }

    @Override
    public void centerZoomStart() {
        this.renderer.centerZoomStart();
    }

    @Override
    public void centerZoomProgress(double d, View view) {
        this.renderer.centerZoomProgress(d, view);
    }

    @Override
    public void centerZoomEnd(double d, View view) {
        this.renderer.centerZoomEnd(d, view);
    }

    @Override
    public boolean restoreViewportCenterAfterZoom(double[] dArray) {
        return this.renderer.restoreViewportCenterAfterZoom(dArray);
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.renderer != null) {
            this.renderer.cleanUp();
        }
    }
}

