/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.rotation;

import com.agfa.pacs.impaxee.rotation.FreeRotationFitHandler;
import com.agfa.pacs.impaxee.rotation.FreeRotationRenderer;
import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.jvision.image.SnapOutputGeometry;
import com.tiani.jvision.image.ViewSnapshot;
import com.tiani.jvision.info.IViewSizeProvider;

class FreeRotationSnapOutputGeometry
extends SnapOutputGeometry
implements IViewSizeProvider {
    private final int viewWidth;
    private final int viewHeight;

    private FreeRotationSnapOutputGeometry(ViewSnapshot viewSnapshot, int n, int n2) {
        super(n, n, n2, n2);
        this.viewWidth = viewSnapshot.getWidth();
        this.viewHeight = viewSnapshot.getHeight();
        this.vpHandler = FreeRotationFitHandler.encapsulate(this.vpHandler, this);
    }

    static SnapOutputGeometry create(ViewSnapshot viewSnapshot, SnapOutputGeometry snapOutputGeometry) {
        if (!DoubleEquals.equals((double)snapOutputGeometry.widthMM, (double)0.0) && !DoubleEquals.equals((double)snapOutputGeometry.heightMM, (double)0.0)) {
            throw new UnsupportedOperationException("A snap output geometry with non-default pixel size is not supported  in case of free rotation");
        }
        int n = FreeRotationRenderer.getUnrotatedViewSize(snapOutputGeometry.minWidth, snapOutputGeometry.minHeight);
        int n2 = FreeRotationRenderer.getUnrotatedViewSize(snapOutputGeometry.maxWidth, snapOutputGeometry.maxHeight);
        return new FreeRotationSnapOutputGeometry(viewSnapshot, n, n2);
    }

    @Override
    public int getViewWidth() {
        return this.viewWidth;
    }

    @Override
    public int getViewHeight() {
        return this.viewHeight;
    }
}

