/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.save;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.config.KeyDescriptions;
import com.agfa.pacs.impaxee.save.UnsavedDataAction;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.main.ISecondaryCapture;
import java.util.EnumMap;
import java.util.Map;

public enum UnsavedDataTypes {
    KeyImages,
    Markups,
    Registrations,
    Reformations(ISecondaryCapture.SecondaryCaptureType.Reformation),
    MRIMaps(ISecondaryCapture.SecondaryCaptureType.MRIMap),
    HecTecSecondaryCaptures(ISecondaryCapture.SecondaryCaptureType.HecTec),
    OtherSecondaryCaptures(ISecondaryCapture.SecondaryCaptureType.Other),
    Segmentations,
    Sessions;

    private static final ALogger LOGGER;
    private static final String CONFIG_KEY_PREFIX = "impaxee.jvision.UnsavedData";
    private static final IConfigurationProvider CONFIG_NODE;
    private static Map<ISecondaryCapture.SecondaryCaptureType, UnsavedDataTypes> seconaryCaptureTypes;
    private final ISecondaryCapture.SecondaryCaptureType secondaryCaptureType;

    static {
        LOGGER = ALogger.getLogger(UnsavedDataTypes.class);
        CONFIG_NODE = ConfigurationProviderFactory.getConfig().getNode(CONFIG_KEY_PREFIX);
    }

    private UnsavedDataTypes() {
        this(null);
    }

    private UnsavedDataTypes(ISecondaryCapture.SecondaryCaptureType secondaryCaptureType) {
        this.secondaryCaptureType = secondaryCaptureType;
    }

    private static void initSecondaryCaptureTypeMapIfNecessary() {
        if (seconaryCaptureTypes == null) {
            EnumMap<ISecondaryCapture.SecondaryCaptureType, UnsavedDataTypes> enumMap = new EnumMap<ISecondaryCapture.SecondaryCaptureType, UnsavedDataTypes>(ISecondaryCapture.SecondaryCaptureType.class);
            UnsavedDataTypes[] unsavedDataTypesArray = UnsavedDataTypes.values();
            int n = unsavedDataTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                UnsavedDataTypes unsavedDataTypes = unsavedDataTypesArray[n2];
                if (unsavedDataTypes.secondaryCaptureType != null) {
                    enumMap.put(unsavedDataTypes.secondaryCaptureType, unsavedDataTypes);
                }
                ++n2;
            }
            seconaryCaptureTypes = enumMap;
        }
    }

    public static UnsavedDataTypes[] getSecondaryCaptureTypes() {
        UnsavedDataTypes.initSecondaryCaptureTypeMapIfNecessary();
        return seconaryCaptureTypes.values().toArray(new UnsavedDataTypes[seconaryCaptureTypes.size()]);
    }

    public UnsavedDataAction getAction() {
        String string = null;
        try {
            string = CONFIG_NODE.getString(this.name());
            return UnsavedDataAction.valueOf(string);
        }
        catch (Exception exception) {
            LOGGER.warn("Unsupported action for unsaved " + (Object)((Object)this) + ": " + string, (Throwable)exception);
            return UnsavedDataAction.DISCARD;
        }
    }

    public boolean isUnsavedDataDiscarded() {
        return this.getAction() == UnsavedDataAction.DISCARD;
    }

    public String getDescription() {
        return "<html>" + KeyDescriptions.getDescription(this.getConfigKey()) + "</html>";
    }

    public String getConfigKey() {
        return "impaxee.jvision.UnsavedData." + this.name();
    }

    public static UnsavedDataTypes valueOf(String string) {
        return Enum.valueOf(UnsavedDataTypes.class, string);
    }
}

