/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.save.gui;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.User;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.gui.LimitedPlainDocument;
import com.agfa.pacs.impaxee.save.ISaveItem;
import com.agfa.pacs.impaxee.save.ISaveManager;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSaveWithDescriptionPanel
extends JPanel
implements ISaveItem {
    private static final int MAXIMUM_DESCRIPTION_LENGTH = 64;
    private static final boolean IS_AUTOMATED_TESTING = Product.isRunningAutoTests();
    private JTextField tfDescription;

    protected AbstractSaveWithDescriptionPanel() {
        this((Integer)null);
    }

    protected AbstractSaveWithDescriptionPanel(Integer n) {
        super(new BorderLayout());
        this.createComponents(n);
    }

    void setAction(Action action) {
        this.tfDescription.setAction(action);
    }

    public final void setDescription(String string) {
        this.tfDescription.setText(string);
    }

    protected String getDescription() {
        return this.tfDescription.getText();
    }

    private void createComponents(Integer n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        Border border = SwingUtilities2.createEmptyBorder((int)10);
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 0));
        jPanel2.setBorder(border);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout(10, 0));
        jPanel3.setBorder(border);
        jPanel.add(jPanel3);
        this.tfDescription = ComponentFactory.instance.createTextField(n);
        this.tfDescription.setDocument(new LimitedPlainDocument(64));
        this.tfDescription.setText(AbstractSaveWithDescriptionPanel.createDefaultDescription(new String[0]));
        jPanel3.add((Component)ComponentFactory.instance.createLabel(String.valueOf(Messages.getString("AbstractSavePanel.Description")) + ':'), "West");
        jPanel3.add((Component)this.tfDescription, "Center");
        this.add((Component)jPanel, "North");
    }

    public static String createDefaultDescription(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder(User.getUserName());
        if (!IS_AUTOMATED_TESTING) {
            stringBuilder.append(' ').append(DateTimeUtils.dateTime2String((Date)new Date()));
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            stringBuilder.append(' ').append(string);
            ++n2;
        }
        return StringUtils.abbreviate((String)stringBuilder.toString(), (int)64);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public boolean isSaveable() {
        return true;
    }

    @Override
    public void setSaveManager(ISaveManager iSaveManager) {
    }
}

