/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.save.gui;

import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.save.IPatientStudyFilter;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.IStudyData;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PatientStudyFilter
implements IPatientStudyFilter {
    private final Set<IPatientRepresentation> patients;
    private final Set<IStudyData> studies;
    private final boolean isStudyFilterActive;

    PatientStudyFilter(Set<IPatientRepresentation> set, IStudyData iStudyData) {
        this.patients = set == null ? Collections.unmodifiableSet(new HashSet<IPatientRepresentation>(DataManager.getInstance().getPatientRepresentations())) : Collections.unmodifiableSet(set);
        this.studies = this.getLoadedStudies(set, iStudyData);
        this.isStudyFilterActive = iStudyData != null;
    }

    private Set<IStudyData> getLoadedStudies(Set<IPatientRepresentation> set, IStudyData iStudyData) {
        Set<IStudyData> set2;
        if (set == null) {
            set2 = new HashSet<IStudyData>(DataManager.getInstance().getAllStudies());
        } else if (iStudyData != null) {
            set2 = Collections.singleton(DataManager.getInstance().getStudy(iStudyData.getKey()));
        } else {
            set2 = new HashSet();
            for (IPatientRepresentation iPatientRepresentation : set) {
                IPatientData iPatientData = DataManager.getInstance().getPatient(iPatientRepresentation.getPatientKey());
                if (iPatientData == null) continue;
                set2.addAll(iPatientData.getStudies());
            }
        }
        return Collections.unmodifiableSet(set2);
    }

    @Override
    public boolean isEmpty() {
        return this.studies.isEmpty();
    }

    @Override
    public Iterable<IPatientRepresentation> getPatients() {
        return this.patients;
    }

    @Override
    public Iterable<IStudyData> getStudies() {
        return this.studies;
    }

    @Override
    public boolean isMatchingPatient(IPatientRepresentation iPatientRepresentation) {
        return this.patients.contains(iPatientRepresentation);
    }

    @Override
    public boolean isMatchingStudy(IStudyData iStudyData) {
        return !this.isStudyFilterActive || this.studies.contains(iStudyData);
    }
}

