/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.save.gui;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.data.shared.store.IStoreHandler;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.data.fetcher.IPerform;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IHangingSession;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.keyimages.KeyImageManager;
import com.agfa.pacs.impaxee.keyimages.KeyImageType;
import com.agfa.pacs.impaxee.keyimages.SaveKeyImagesItemFactory;
import com.agfa.pacs.impaxee.plugin.IPlugin;
import com.agfa.pacs.impaxee.presentationstate.PresentationStateUnsavedItem;
import com.agfa.pacs.impaxee.presentationstate.TemporaryPresentationStateUnsavedItemFactory;
import com.agfa.pacs.impaxee.save.IPatientStudyFilter;
import com.agfa.pacs.impaxee.save.ISaveItem;
import com.agfa.pacs.impaxee.save.IUnsavedDataMap;
import com.agfa.pacs.impaxee.save.IUnsavedDataMapContainer;
import com.agfa.pacs.impaxee.save.UnsavedDataAction;
import com.agfa.pacs.impaxee.save.UnsavedDataTypes;
import com.agfa.pacs.impaxee.save.collector.IUnsavedDataCollector;
import com.agfa.pacs.impaxee.save.collector.UnsavedDataCollectorFactory;
import com.agfa.pacs.impaxee.save.gui.PatientStudyFilter;
import com.agfa.pacs.impaxee.save.gui.UnsavedDataDialog;
import com.agfa.pacs.impaxee.save.gui.UnsavedDataElement;
import com.agfa.pacs.impaxee.save.gui.UnsavedDataMapContainer;
import com.agfa.pacs.impaxee.save.gui.UnsavedSelectableDataElement;
import com.agfa.pacs.listtext.dicomobject.presentationstate.ExternalPresentationStateInfo;
import com.agfa.pacs.listtext.dicomobject.presentationstate.IPresentationStateInfo;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.security.permission.Permissions;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.SecondaryCaptureUnsavedItem;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.util.StorageLicense;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.jvision.vis.menu.KeyImageModificationAction;
import com.tiani.util.message.Message;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class UnsavedDataManager {
    private static final ALogger LOGGER = ALogger.getLogger(UnsavedDataManager.class);
    private static final EnumSet<PluginName> PLUGINS_SUPPORTED_MARKUPS_STORAGE = EnumSet.of(PluginName.DEFAULT, PluginName.MAMMO2);
    private static final PAction STORE_PS_ACTION = PActionRegistry.getAction("STORE_PRESENTATION_STATE");
    private static final Set<UnsavedDataTypes> REPLACEMENT_DATA_TYPES = EnumSet.of(UnsavedDataTypes.KeyImages, UnsavedDataTypes.Registrations);
    private final List<IStoreHandler> storeHandlers = new ArrayList<IStoreHandler>();

    public boolean manageSave(JFrame jFrame, Set<IPatientRepresentation> set, IStudyData iStudyData) {
        return this.manageSave(jFrame, set, iStudyData, false);
    }

    public boolean manageSave(JFrame jFrame, Set<IPatientRepresentation> set, IStudyData iStudyData, boolean bl) {
        if (this.isAllUnsavedDataDiscarded()) {
            return true;
        }
        PatientStudyFilter patientStudyFilter = new PatientStudyFilter(set, iStudyData);
        ResultHolder resultHolder = new ResultHolder();
        EventUtil.invokeSynchronous(() -> resultHolder.setSuccessful(this.manageSave(jFrame, patientStudyFilter, bl)));
        return resultHolder.isSuccessful();
    }

    private boolean manageSave(JFrame jFrame, IPatientStudyFilter iPatientStudyFilter, boolean bl) {
        boolean bl2;
        boolean bl3;
        boolean bl4;
        IUnsavedDataMapContainer iUnsavedDataMapContainer = this.collectUnsavedData(iPatientStudyFilter);
        if (iUnsavedDataMapContainer.isEmpty()) {
            return true;
        }
        List<IFrameObjectData> list = this.collectUnsavedKeyImages(iPatientStudyFilter, KeyImageType.ForConference);
        IUnsavedDataMap iUnsavedDataMap = iUnsavedDataMapContainer.getUnsavedData(UnsavedDataAction.AUTO_SAVE);
        IUnsavedDataMap iUnsavedDataMap2 = iUnsavedDataMapContainer.getUnsavedData(UnsavedDataAction.ASK_USER);
        if (UnsavedDataTypes.Sessions.getAction() == UnsavedDataAction.AUTO_SAVE) {
            bl4 = this.saveWithUserConfirmation(jFrame, iUnsavedDataMap2, bl);
            bl3 = this.saveAutomatically(jFrame, iUnsavedDataMap, bl);
        } else {
            bl3 = this.saveAutomatically(jFrame, iUnsavedDataMap, bl);
            bl4 = this.saveWithUserConfirmation(jFrame, iUnsavedDataMap2, bl);
        }
        boolean bl5 = bl2 = bl3 && bl4;
        if (bl2 && !list.isEmpty() && this.unsavedKeyImagesSaved(list, KeyImageType.ForConference)) {
            KeyImageModificationAction.addToWorklists(list);
        }
        return bl2;
    }

    private boolean saveAutomatically(JFrame jFrame, IUnsavedDataMap iUnsavedDataMap, boolean bl) {
        boolean bl2;
        if (iUnsavedDataMap != null && !iUnsavedDataMap.isEmpty()) {
            if (!bl && !this.checkAllDataSaveable(iUnsavedDataMap)) {
                Message.warning(Messages.getString("UnsavedHangingsManager.SaveUnsavedItems"), Messages.getString("UnsavedHangingsManager.AutoSaveNotPossible"));
                bl2 = this.displaySaveDialog(jFrame, iUnsavedDataMap);
            } else {
                bl2 = this.saveUnsavedData(iUnsavedDataMap);
            }
        } else {
            bl2 = true;
        }
        return bl2;
    }

    private boolean saveWithUserConfirmation(JFrame jFrame, IUnsavedDataMap iUnsavedDataMap, boolean bl) {
        return bl || iUnsavedDataMap.isEmpty() || this.displaySaveDialog(jFrame, iUnsavedDataMap);
    }

    private boolean isAllUnsavedDataDiscarded() {
        return this.isAllUnsavedDataDiscarded(UnsavedDataTypes.values());
    }

    private boolean isAllUnsavedDataDiscarded(UnsavedDataTypes ... unsavedDataTypesArray) {
        UnsavedDataTypes[] unsavedDataTypesArray2 = unsavedDataTypesArray;
        int n = unsavedDataTypesArray.length;
        int n2 = 0;
        while (n2 < n) {
            UnsavedDataTypes unsavedDataTypes = unsavedDataTypesArray2[n2];
            if (!unsavedDataTypes.isUnsavedDataDiscarded()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isUnsavedSecondaryCapturesDiscarded() {
        return this.isAllUnsavedDataDiscarded(UnsavedDataTypes.getSecondaryCaptureTypes());
    }

    private boolean displaySaveDialog(JFrame jFrame, IUnsavedDataMap iUnsavedDataMap) {
        UnsavedDataDialog unsavedDataDialog = new UnsavedDataDialog((Frame)jFrame, iUnsavedDataMap);
        unsavedDataDialog.setVisible(true);
        for (ISaveItem iSaveItem : unsavedDataDialog.getSaveItems()) {
            List<IStoreHandler> list = iSaveItem.getStoreHandlers();
            if (list == null) continue;
            this.storeHandlers.addAll(list);
        }
        return unsavedDataDialog.getDialogResult() != 2;
    }

    private boolean checkAllDataSaveable(IUnsavedDataMap iUnsavedDataMap) {
        List<UnsavedDataElement> list = iUnsavedDataMap.getAllUnsavedData();
        for (UnsavedDataElement unsavedDataElement : list) {
            ISaveItem iSaveItem = unsavedDataElement.getSaveItem();
            if (iSaveItem.isSaveable()) continue;
            return false;
        }
        return true;
    }

    private IUnsavedDataMapContainer collectUnsavedData(IPatientStudyFilter iPatientStudyFilter) {
        UnsavedDataMapContainer unsavedDataMapContainer = new UnsavedDataMapContainer();
        if (!this.isUnsavedSecondaryCapturesDiscarded()) {
            this.collectUnsavedSC(iPatientStudyFilter, unsavedDataMapContainer);
        }
        if (!UnsavedDataTypes.Markups.isUnsavedDataDiscarded()) {
            this.collectUnsavedPresentationStates(iPatientStudyFilter, unsavedDataMapContainer);
        }
        if (!UnsavedDataTypes.KeyImages.isUnsavedDataDiscarded()) {
            this.collectUnsavedKeyImages(iPatientStudyFilter, unsavedDataMapContainer);
        }
        for (IUnsavedDataCollector iUnsavedDataCollector : UnsavedDataCollectorFactory.getInstance().getUnsavedDataCollectors()) {
            iUnsavedDataCollector.collectUnsavedData(iPatientStudyFilter, unsavedDataMapContainer);
        }
        if (!UnsavedDataTypes.Sessions.isUnsavedDataDiscarded()) {
            this.collectUnsavedSessions(iPatientStudyFilter, unsavedDataMapContainer);
        }
        return unsavedDataMapContainer;
    }

    private void collectUnsavedSessions(IPatientStudyFilter iPatientStudyFilter, IUnsavedDataMapContainer iUnsavedDataMapContainer) {
        if (!Permissions.getInstance().isAllowed("ImageArea/AllowedToCreateAndSaveSessions")) {
            return;
        }
        if (iPatientStudyFilter.isEmpty()) {
            return;
        }
        for (IPatientRepresentation iPatientRepresentation : iPatientStudyFilter.getPatients()) {
            int n = iPatientRepresentation.countHangings();
            int n2 = 0;
            while (n2 < n) {
                IHangingSession iHangingSession;
                IHanging iHanging = iPatientRepresentation.getHanging(n2);
                if (iHanging instanceof IHangingSession && !(iHangingSession = (IHangingSession)iHanging).isSaved() && iPatientStudyFilter.isMatchingStudy(iHanging.getStudyContainer().getBaseStudy())) {
                    iUnsavedDataMapContainer.put(iPatientRepresentation, new UnsavedSelectableDataElement(iHangingSession, iPatientRepresentation));
                }
                ++n2;
            }
        }
    }

    private void collectUnsavedSC(IPatientStudyFilter iPatientStudyFilter, IUnsavedDataMapContainer iUnsavedDataMapContainer) {
        if (StorageLicense.canStoreSC()) {
            for (IStudyData iStudyData : iPatientStudyFilter.getStudies()) {
                try {
                    IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(iStudyData.getParent().getKey());
                    List<ISeriesData> list = iStudyData.getSeries();
                    for (ISeriesData iSeriesData : list) {
                        UnsavedDataTypes unsavedDataTypes;
                        if (iSeriesData.isSecondaryCaptureSaved() || (unsavedDataTypes = UnsavedDataTypes.valueOf(iSeriesData.getSecondaryCaptureType())) == null || unsavedDataTypes.isUnsavedDataDiscarded()) continue;
                        iUnsavedDataMapContainer.put(iPatientRepresentation, this.createSecondaryCaptureUnsavedItem(iSeriesData, iPatientRepresentation));
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Could not gather unsaved SC", (Throwable)exception);
                }
            }
        }
    }

    public boolean saveUnsavedReplacementDataAutomaticallyIfNotDiscarded(JFrame jFrame, Set<IPatientRepresentation> set, IStudyData iStudyData) {
        if (REPLACEMENT_DATA_TYPES.stream().allMatch(UnsavedDataTypes::isUnsavedDataDiscarded)) {
            return true;
        }
        UnsavedDataMapContainer unsavedDataMapContainer = new UnsavedDataMapContainer();
        PatientStudyFilter patientStudyFilter = new PatientStudyFilter(set, iStudyData);
        if (!UnsavedDataTypes.KeyImages.isUnsavedDataDiscarded()) {
            this.collectUnsavedKeyImages((IPatientStudyFilter)patientStudyFilter, unsavedDataMapContainer);
        }
        for (IUnsavedDataCollector iUnsavedDataCollector : UnsavedDataCollectorFactory.getInstance().getUnsavedDataCollectors()) {
            if (!REPLACEMENT_DATA_TYPES.contains((Object)iUnsavedDataCollector.getType())) continue;
            iUnsavedDataCollector.collectUnsavedData(patientStudyFilter, unsavedDataMapContainer);
        }
        return this.saveAutomatically(jFrame, unsavedDataMapContainer.getUnsavedData(UnsavedDataAction.AUTO_SAVE), false) && this.saveAutomatically(jFrame, unsavedDataMapContainer.getUnsavedData(UnsavedDataAction.ASK_USER), false);
    }

    private void collectUnsavedKeyImages(IPatientStudyFilter iPatientStudyFilter, IUnsavedDataMapContainer iUnsavedDataMapContainer) {
        if (!iPatientStudyFilter.isEmpty()) {
            for (IStudyData iStudyData : iPatientStudyFilter.getStudies()) {
                KeyImageType[] keyImageTypeArray = iStudyData.getKeyImageManager().getModifiedTypes();
                if (keyImageTypeArray == null || keyImageTypeArray.length <= 0) continue;
                IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(iStudyData.getParent().getKey());
                iUnsavedDataMapContainer.put(iPatientRepresentation, new UnsavedSelectableDataElement(new SaveKeyImagesItemFactory(iStudyData), iPatientRepresentation));
            }
        }
    }

    private List<IFrameObjectData> collectUnsavedKeyImages(IPatientStudyFilter iPatientStudyFilter, KeyImageType keyImageType) {
        if (!UnsavedDataTypes.KeyImages.isUnsavedDataDiscarded() && !iPatientStudyFilter.isEmpty()) {
            ArrayList<IFrameObjectData> arrayList = new ArrayList<IFrameObjectData>();
            for (IStudyData iStudyData : iPatientStudyFilter.getStudies()) {
                List<IFrameObjectData> list;
                KeyImageManager keyImageManager = iStudyData.getKeyImageManager();
                KeyImageType[] keyImageTypeArray = keyImageManager.getModifiedTypes();
                if (keyImageTypeArray == null || !Arrays.asList(keyImageTypeArray).contains((Object)keyImageType) || (list = keyImageManager.getKeyImages(keyImageType)) == null) continue;
                for (IFrameObjectData iFrameObjectData : list) {
                    if (!iFrameObjectData.getKeyImageInfo().isModified()) continue;
                    arrayList.add(iFrameObjectData);
                }
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private boolean unsavedKeyImagesSaved(Collection<IFrameObjectData> collection, KeyImageType keyImageType) {
        if (collection != null) {
            for (IFrameObjectData iFrameObjectData : collection) {
                if (!(keyImageType != null ? iFrameObjectData.getKeyImageInfo().isModifiable(keyImageType) : iFrameObjectData.getKeyImageInfo().isModified())) continue;
                return false;
            }
        }
        return true;
    }

    private UnsavedDataElement createSecondaryCaptureUnsavedItem(ISeriesData iSeriesData, IPatientRepresentation iPatientRepresentation) {
        IPerform iPerform = DataManager.getInstance().getDataPerform("EXPORT_SC_DIRECT");
        boolean bl = iPerform.canInferStoreTargetNode(iSeriesData.getParent());
        UnsavedDataElement unsavedDataElement = null;
        unsavedDataElement = bl ? new UnsavedSelectableDataElement(new SecondaryCaptureUnsavedItem(iSeriesData, false), iPatientRepresentation) : new UnsavedDataElement(new SecondaryCaptureUnsavedItem(iSeriesData, true), iPatientRepresentation);
        return unsavedDataElement;
    }

    private void collectUnsavedPresentationStates(IPatientStudyFilter iPatientStudyFilter, IUnsavedDataMapContainer iUnsavedDataMapContainer) {
        IPlugin iPlugin;
        Object object;
        VisDisplay2 visDisplay2;
        if (!STORE_PS_ACTION.isAvailable()) {
            return;
        }
        if (iPatientStudyFilter.isEmpty()) {
            return;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        List<VisScreen2> list = JVision2.getMainFrame().getScreens();
        int n = 0;
        while (n < list.size()) {
            VisScreen2 visScreen2 = list.get(n);
            List<VisDisplay2> list2 = visScreen2.getDisplays();
            int n2 = 0;
            while (n2 < list2.size()) {
                visDisplay2 = list2.get(n2);
                object = visDisplay2.getData().getPatientRepresentation();
                if (iPatientStudyFilter.isMatchingPatient((IPatientRepresentation)object) && ((iPlugin = visDisplay2.getData().getPlugin()) == null || PLUGINS_SUPPORTED_MARKUPS_STORAGE.contains((Object)iPlugin.getPluginName())) && this.existUnsavedMarkups(visDisplay2, iPatientStudyFilter)) {
                    iUnsavedDataMapContainer.put((IPatientRepresentation)object, new UnsavedSelectableDataElement(new PresentationStateUnsavedItem(visDisplay2, n, n2), (IPatientRepresentation)object));
                    hashSet.add(visDisplay2.getData().getDisplaySetID());
                }
                ++n2;
            }
            ++n;
        }
        for (IStudyData iStudyData : iPatientStudyFilter.getStudies()) {
            int n3 = this.getMaxSeriesNumber(iStudyData);
            IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(iStudyData.getParent().getKey());
            visDisplay2 = iStudyData.getFramePresentationStateProviderContainer();
            object = visDisplay2.getAllPresentationStateInfos();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                iPlugin = (IPresentationStateInfo)iterator.next();
                if (!iPlugin.isTemporary() || !iPlugin.containsUnsavedGraphicAnnotations() || hashSet.contains(((ExternalPresentationStateInfo)iPlugin).getDisplaySetID())) continue;
                Attributes attributes = iPlugin.getDataset();
                attributes.setInt(0x200011, VR.IS, new int[]{++n3});
                iUnsavedDataMapContainer.put(iPatientRepresentation, new UnsavedSelectableDataElement(new TemporaryPresentationStateUnsavedItemFactory(iStudyData, attributes), iPatientRepresentation));
            }
        }
    }

    private int getMaxSeriesNumber(IStudyData iStudyData) {
        int n = 0;
        for (ISeriesData iSeriesData : iStudyData.getSeries()) {
            int n2 = iSeriesData.getDicomObject().getInt(0x200011, 0);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private boolean existUnsavedMarkups(VisDisplay2 visDisplay2, IPatientStudyFilter iPatientStudyFilter) {
        for (VisData visData : visDisplay2.getVis()) {
            if (visData == null || visData.getView() == null || !iPatientStudyFilter.isMatchingStudy(visData.getStudyData())) continue;
            View view = visData.getView();
            if (view.hasRemovedPO()) {
                return true;
            }
            for (Overlay overlay : view.getOverlays()) {
                if (!overlay.isUnsavedROI()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean saveUnsavedData(IUnsavedDataMap iUnsavedDataMap) {
        if (iUnsavedDataMap == null || iUnsavedDataMap.isEmpty()) {
            return true;
        }
        boolean bl = true;
        for (UnsavedDataElement unsavedDataElement : iUnsavedDataMap.getAllSortedUnsavedData()) {
            ISaveItem iSaveItem = unsavedDataElement.getSaveItem();
            if (iSaveItem == null || !(unsavedDataElement instanceof UnsavedSelectableDataElement)) continue;
            LOGGER.debug("Auto-saving {}", (Object)unsavedDataElement);
            bl = iSaveItem.isSaveable() && iSaveItem.save(true) && bl;
            List<IStoreHandler> list = iSaveItem.getStoreHandlers();
            if (list == null) continue;
            this.storeHandlers.addAll(list);
        }
        return bl;
    }

    public List<IStoreHandler> getStoreHandlers() {
        return this.storeHandlers;
    }

    private static class ResultHolder {
        private boolean isSuccessful;

        private ResultHolder() {
        }

        void setSuccessful(boolean bl) {
            this.isSuccessful = bl;
        }

        boolean isSuccessful() {
            return this.isSuccessful;
        }
    }
}

