/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions;

import com.agfa.integration.IntegrationFrameworkFactory;
import com.agfa.integration.ObjectID;
import com.agfa.integration.ext.INotificationMessage;
import com.agfa.pacs.base.swing.layout.RowLayout;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.store.IStoreHandler;
import com.agfa.pacs.data.shared.worklist.IWorklistContext;
import com.agfa.pacs.impaxee.ImpaxEEUtils;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.frameofreference.FrameOfReferenceManager;
import com.agfa.pacs.impaxee.frameofreference.IFrameOfReference;
import com.agfa.pacs.impaxee.frameofreference.IWorldToWorldTransform;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.AbstractStudyContainer;
import com.agfa.pacs.impaxee.hanging.HangingType;
import com.agfa.pacs.impaxee.hanging.HangingUtil;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IHangingSession;
import com.agfa.pacs.impaxee.hanging.IHangingSessionExtension;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.StudyType;
import com.agfa.pacs.impaxee.hanging.impl.AbstractHangingSnapshotModel;
import com.agfa.pacs.impaxee.hanging.runtime.AbstractHangingRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.DisplayLayoutRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.ScreenLayoutRuntime;
import com.agfa.pacs.impaxee.hanging.snapshot.AbstractSnapshotRuntime;
import com.agfa.pacs.impaxee.hanging.snapshot.SnapshotUtil;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.impaxee.keyimages.KeyImageManager;
import com.agfa.pacs.impaxee.keyimages.KeyImageType;
import com.agfa.pacs.impaxee.save.ISaveItem;
import com.agfa.pacs.impaxee.save.ISaveManager;
import com.agfa.pacs.impaxee.save.UnsavedDataTypes;
import com.agfa.pacs.impaxee.save.gui.UnsavedDataManager;
import com.agfa.pacs.impaxee.sessions.IHangingSessionExtensionProvider;
import com.agfa.pacs.impaxee.sessions.ISessionDisplaySet;
import com.agfa.pacs.impaxee.sessions.Session4DInfo;
import com.agfa.pacs.impaxee.sessions.SessionDisplay;
import com.agfa.pacs.impaxee.sessions.SessionDisplaySetFactory;
import com.agfa.pacs.impaxee.sessions.SessionKeyObject;
import com.agfa.pacs.impaxee.sessions.SessionObject;
import com.agfa.pacs.impaxee.sessions.SessionSnapshotInformation;
import com.agfa.pacs.impaxee.sessions.SessionSnapshotRuntime;
import com.agfa.pacs.impaxee.sessions.SessionSplitAndSortRuntime;
import com.agfa.pacs.impaxee.sessions.SessionStorage;
import com.agfa.pacs.impaxee.sessions.SessionStorageData;
import com.agfa.pacs.impaxee.sessions.gui.ImageAreaWorklistChooserPanel;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeType;
import com.agfa.pacs.listtext.integration.notifications.SessionStored2;
import com.agfa.pacs.listtext.lta.util.referencedobject.KeyObjectAttributes;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObject;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IKeyObjectData;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.hanging.HangingController;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.util.SaveData;
import com.tiani.jvision.vis.NavigationLocation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.util.UIDUtils;

public class Session
extends AbstractHangingRuntime
implements IHangingSession,
IHanging.SnapshotModel.Listener {
    private static final DataManager DATA_MANAGER = DataManager.getInstance();
    private static final ALogger log = ALogger.getLogger(Session.class);
    private static final Icon ICON_SAVED = IAIconFactory.DEFAULT_FACTORY.loadIcon("session.svg");
    private static final Icon ICON_UNSAVED = IAIconFactory.DEFAULT_FACTORY.loadIcon("session_unsaved.svg");
    private static final String SERIALIZATION_TAG = "TIANISESSION";
    private static final boolean INCLUDE_ALL_STUDIES_ON_SAVE = !Config.impaxee.jvision.HANGMAN.filterSavedStudiesInSession.get();
    private static final Set<String> NON_AGGREGATING_PLUGIN_NAMES = new HashSet<String>(Arrays.asList(PluginName.DEFAULT.getPluginName(), PluginName.MAMMO2.getPluginName(), PluginName.NUK.getPluginName(), PluginName.SPINELABELING.getPluginName()));
    private static final int MARGIN = GUI.getScaledDiagnosticInt((int)10);
    private String sessionUID = null;
    private IPatientRepresentation patientRepresentation;
    private List<SessionSnapshotRuntime> snaps;
    private boolean isSaved = false;
    private IHanging.SnapshotModel snapshotModel;
    private List<IStoreHandler> storeHandlers;
    private SessionStudyContainer myStudyContainer;
    private String[] studyOrdering;
    private String[] sessionKeyObjectSOPInstanceUIDs;
    private final Map<String, IHangingSessionExtension> extensions = new HashMap<String, IHangingSessionExtension>();
    private SessionKeyObject sessionKeyObject;
    private IKeyObjectData keyObjectData;
    private Date dateTime;
    private SessionSplitAndSortRuntime splitAndSortRuntime;
    private final boolean isSetLiveEnabled;

    private Session(IPatientRepresentation iPatientRepresentation, Date date, boolean bl) {
        super(null);
        if (iPatientRepresentation == null) {
            throw new IllegalArgumentException("creation of session object failed");
        }
        this.patientRepresentation = iPatientRepresentation;
        this.isSetLiveEnabled = bl;
        this.snaps = new ArrayList<SessionSnapshotRuntime>();
        this.sessionUID = UIDUtils.createUID();
        this.splitAndSortRuntime = new SessionSplitAndSortRuntime(iPatientRepresentation);
        this.setDateTime(date);
    }

    public Session(DataInputStream dataInputStream, IPatientRepresentation iPatientRepresentation, Date date, SessionKeyObject sessionKeyObject, IKeyObjectData iKeyObjectData, Sequence sequence, String string) throws IOException {
        this(iPatientRepresentation, date, true);
        this.sessionKeyObject = sessionKeyObject;
        this.keyObjectData = iKeyObjectData;
        this.studyOrdering = sessionKeyObject.getStudyOrdering();
        this.sessionKeyObjectSOPInstanceUIDs = sessionKeyObject.getSessionKeyImageSOPInstanceUIDs();
        sessionKeyObject.getExtensions().forEach(this::addExtension);
        Map<String, Session4DInfo> map = sequence == null ? Collections.emptyMap() : sequence.stream().map(Session4DInfo::new).collect(Collectors.toMap(Session4DInfo::getKey, Function.identity()));
        this.read(dataInputStream, map);
        if (iPatientRepresentation.getDecompositionRuntime() != null) {
            this.splitAndSortRuntime.addDisplaySetsOfNewStudies(iPatientRepresentation.getDecompositionRuntime().getDisplaySets());
        }
        if (this.sessionKeyObject.shouldLoadCompleteBaseStudy()) {
            this.splitAndSortRuntime.addDisplaySetsOfBaseStudy(this.getSessionBaseStudy().getStudyInstanceUID(), iPatientRepresentation.getDecompositionRuntime().getDisplaySets());
        }
        this.myStudyContainer = new SessionStudyContainer(string);
        this.isSaved = true;
    }

    public Session(String string, IPatientRepresentation iPatientRepresentation, Date date) {
        this(string, iPatientRepresentation, date, true);
        this.myStudyContainer = new SessionStudyContainer(null);
    }

    public Session(String string, IPatientRepresentation iPatientRepresentation, Date date, boolean bl) {
        this(iPatientRepresentation, date, bl);
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("creation of session object requires a name, got: >" + string + "<");
        }
        this.setVisibleName(string);
        this.initFromActiveHanging();
        this.myStudyContainer = new SessionStudyContainer(null);
        this.createExtensions();
    }

    @Override
    public String getVisibleHint() {
        return this.isSaved ? null : Messages.getString("SessionSaveItem.UnsavedSession.ToolTip");
    }

    @Override
    public Icon getIcon() {
        return this.isSaved ? ICON_SAVED : ICON_UNSAVED;
    }

    @Override
    public HangingType getHangingType() {
        return HangingType.SESSION;
    }

    public List<SessionSnapshotRuntime> getSnapshots() {
        return this.snaps;
    }

    public String getSessionUID() {
        return this.sessionUID;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getVisibleName());
        if (this.patientRepresentation != null) {
            stringBuilder.append(" (");
            stringBuilder.append(this.patientRepresentation.getPatientData().getDicomObject().getString(0x100010));
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    private Set<String> getUsedStudyInstanceUIDs() {
        if (INCLUDE_ALL_STUDIES_ON_SAVE) {
            return new HashSet<String>(this.splitAndSortRuntime.getStudyOrdering());
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.getSessionBaseStudy().getStudyInstanceUID());
        for (SessionSnapshotRuntime sessionSnapshotRuntime : this.getSnapshots()) {
            for (SessionDisplay sessionDisplay : sessionSnapshotRuntime.displays()) {
                ISessionDisplaySet iSessionDisplaySet = sessionDisplay.getSessionDisplaySet();
                if (iSessionDisplaySet == null) continue;
                hashSet.add(iSessionDisplaySet.getStudyUID());
            }
        }
        return hashSet;
    }

    String[] getSessionKeyObjectSOPInstanceUIDs() {
        return this.sessionKeyObjectSOPInstanceUIDs;
    }

    private List<ISessionDisplaySet> getFilteredSessionDisplaySets(Set<String> set) {
        if (INCLUDE_ALL_STUDIES_ON_SAVE) {
            return Arrays.asList(this.splitAndSortRuntime.getDisplaySets());
        }
        ArrayList<ISessionDisplaySet> arrayList = new ArrayList<ISessionDisplaySet>();
        ISessionDisplaySet[] iSessionDisplaySetArray = this.splitAndSortRuntime.getDisplaySets();
        int n = iSessionDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISessionDisplaySet iSessionDisplaySet = iSessionDisplaySetArray[n2];
            if (set.contains(iSessionDisplaySet.getStudyUID())) {
                arrayList.add(iSessionDisplaySet);
            }
            ++n2;
        }
        return arrayList;
    }

    private String[] getFilteredStudyOrdering(Set<String> set) {
        Object object;
        if (this.studyOrdering == null) {
            return null;
        }
        set = new HashSet<String>(set);
        ArrayList<String> arrayList = new ArrayList<String>(set.size());
        Object[] objectArray = this.studyOrdering;
        int n = this.studyOrdering.length;
        int n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            if (set.remove(object)) {
                arrayList.add((String)object);
            }
            ++n2;
        }
        if (!set.isEmpty()) {
            objectArray = this.splitAndSortRuntime.getDisplaySets();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                object = objectArray[n2];
                String string = object.getStudyUID();
                if (set.remove(string)) {
                    arrayList.add(string);
                }
                if (set.isEmpty()) break;
                ++n2;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private List<SessionObject> getFilterAdditionalObjects(Set<String> set) {
        ArrayList<SessionObject> arrayList = new ArrayList<SessionObject>();
        for (IObjectInfo object : this.collectWorldToWorldTransforms(set)) {
            arrayList.add(new SessionObject((ILoadableInfo)object));
        }
        for (IStudyData iStudyData : this.splitAndSortRuntime.getStudies()) {
            if (!set.contains(iStudyData.getStudyInstanceUID())) continue;
            for (ReferringObject referringObject : iStudyData.getKeyImageManager().getAllReferringObjects()) {
                arrayList.add(new SessionObject((ILoadableInfo)referringObject.getObject()));
            }
        }
        for (IObjectInfo iObjectInfo : this.patientRepresentation.getPatientData().getAdditionalObjects()) {
            if (!set.contains(iObjectInfo.getStudyUID())) continue;
            arrayList.add(new SessionObject((ILoadableInfo)iObjectInfo));
        }
        return arrayList;
    }

    private Iterable<IObjectInfo> collectWorldToWorldTransforms(Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, IObjectInfo> hashMap = new HashMap<String, IObjectInfo>(3);
        for (IStudyData iStudyData : this.splitAndSortRuntime.getStudies()) {
            IPatientData iPatientData = iStudyData.getParent();
            if (!set.contains(iStudyData.getStudyInstanceUID()) || hashSet.contains(iPatientData.getKey()) || !iPatientData.existsWorldToWorldTransforms()) continue;
            for (IFrameOfReference iFrameOfReference : FrameOfReferenceManager.getFramesOfPatient(iPatientData.getKey())) {
                for (String string : iFrameOfReference.getFrameOfReferenceUIDsWithWorldToWorldTransform()) {
                    IObjectInfo iObjectInfo;
                    String string2;
                    IWorldToWorldTransform iWorldToWorldTransform = iFrameOfReference.getWorldToWorldTransform(string);
                    if (iWorldToWorldTransform == null || iWorldToWorldTransform.getObjectInfo() == null || hashMap.containsKey(string2 = (iObjectInfo = iWorldToWorldTransform.getObjectInfo()).getKey())) continue;
                    hashMap.put(string2, iObjectInfo);
                }
            }
            hashSet.add(iPatientData.getKey());
        }
        return hashMap.values();
    }

    SessionStorageData write(DataOutput dataOutput) throws IOException {
        Object object;
        Object object2;
        Object object3;
        dataOutput.writeUTF(SERIALIZATION_TAG);
        dataOutput.writeUTF(this.getSessionUID());
        dataOutput.writeUTF(this.getVisibleName());
        Set<String> set = this.getUsedStudyInstanceUIDs();
        HashMap<String, Session4DInfo> hashMap = new HashMap<String, Session4DInfo>();
        List<ISessionDisplaySet> list = this.getFilteredSessionDisplaySets(set);
        dataOutput.writeInt(list.size());
        for (ISessionDisplaySet object4 : list) {
            SessionDisplaySetFactory.write(dataOutput, object4);
            if (!object4.is4D()) continue;
            object3 = object4.getFrames();
            object2 = new int[((IFrameObjectData[][])object3).length];
            int n = 0;
            while (n < ((int[])object2).length) {
                object2[n] = object3[n].length;
                ++n;
            }
            object = Session.get4DInfoKey(object4);
            hashMap.put((String)object, new Session4DInfo((String)object, (int[])object2));
        }
        dataOutput.writeInt(this.getSnapshots().size());
        for (SessionSnapshotRuntime sessionSnapshotRuntime : this.getSnapshots()) {
            sessionSnapshotRuntime.write(dataOutput);
            object2 = sessionSnapshotRuntime.displays().iterator();
            while (object2.hasNext()) {
                object3 = (SessionDisplay)object2.next();
                if (!((SessionDisplay)object3).isFourDReverted() || (object = (Session4DInfo)hashMap.get(Session.get4DInfoKey(((SessionDisplay)object3).getSessionDisplaySet()))) == null) continue;
                ((Session4DInfo)object).setTransposed(true);
            }
        }
        return new SessionStorageData(this, this.getFilteredStudyOrdering(set), list, this.getFilterAdditionalObjects(set), hashMap.values());
    }

    private void read(DataInputStream dataInputStream, Map<String, Session4DInfo> map) throws IOException {
        if (!SERIALIZATION_TAG.equals(dataInputStream.readUTF())) {
            throw new IllegalArgumentException("invalid session format");
        }
        this.sessionUID = dataInputStream.readUTF();
        this.setVisibleName(dataInputStream.readUTF());
        int n = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            this.splitAndSortRuntime.readDisplaySet(dataInputStream, map);
            ++n2;
        }
        n2 = dataInputStream.readInt();
        int n3 = 0;
        while (n3 < n2) {
            SessionSnapshotRuntime sessionSnapshotRuntime = new SessionSnapshotRuntime(Integer.toString(n3), this);
            sessionSnapshotRuntime.read(dataInputStream, this.sessionKeyObject.getAdditionalSnapshotInformation(n3), this.splitAndSortRuntime.getDisplaySets(), n3);
            this.snaps.add(sessionSnapshotRuntime);
            ++n3;
        }
    }

    private SessionSnapshotRuntime captureSnapshot() {
        SessionSnapshotRuntime sessionSnapshotRuntime = new SessionSnapshotRuntime(SnapshotUtil.findNextSnapshotName(this), this);
        sessionSnapshotRuntime.capture();
        for (SessionDisplay sessionDisplay : sessionSnapshotRuntime.displays()) {
            ISessionDisplaySet iSessionDisplaySet = sessionDisplay.getSessionDisplaySet();
            if (iSessionDisplaySet == null) continue;
            iSessionDisplaySet.setIn4DPrimaryDimensionSpace(!sessionDisplay.isFourDReverted());
        }
        return sessionSnapshotRuntime;
    }

    public final void setDateTime(Date date) {
        this.dateTime = date;
    }

    @Override
    public IHanging.SnapshotModel getSnapshotModel() {
        if (this.snapshotModel == null) {
            this.snapshotModel = new SessionSnapshotModel();
            this.snapshotModel.addListener(this);
        }
        return this.snapshotModel;
    }

    private int getSnapshotCount() {
        return this.snaps.size();
    }

    public SessionSnapshotRuntime getSnapshot(int n) {
        return n >= this.getSnapshotCount() || n < 0 ? null : this.snaps.get(n);
    }

    public SessionSnapshotRuntime getSnapshot(String string) {
        for (SessionSnapshotRuntime sessionSnapshotRuntime : this.snaps) {
            if (!sessionSnapshotRuntime.getName().equals(string)) continue;
            return sessionSnapshotRuntime;
        }
        return null;
    }

    int indexOfSnap(AbstractSnapshotRuntime abstractSnapshotRuntime) {
        return this.snaps.indexOf(abstractSnapshotRuntime);
    }

    ISessionDisplaySet findDisplaySet(IDisplaySet iDisplaySet) {
        return this.splitAndSortRuntime.getDisplaySetByID(iDisplaySet.getID());
    }

    @Override
    public boolean saveReplacementDataAndSession(Collection<IWorklistContext> collection) {
        this.updateSelectedSnapshot();
        UnsavedDataManager unsavedDataManager = new UnsavedDataManager();
        boolean bl = unsavedDataManager.saveUnsavedReplacementDataAutomaticallyIfNotDiscarded(JVision2.getMainFrame(), Collections.singleton(this.getPatient()), null);
        this.createKeyImagesAutomaticallyIfEnabled();
        for (IStoreHandler iStoreHandler : unsavedDataManager.getStoreHandlers()) {
            this.addStoreHandler(iStoreHandler);
        }
        boolean bl2 = this.saveSession(collection);
        return bl2 && bl;
    }

    private void removeAutoGeneratedKeyImages() {
        if (this.sessionKeyObjectSOPInstanceUIDs != null) {
            for (IStudyData iStudyData : this.splitAndSortRuntime.getStudies()) {
                String[] stringArray = this.sessionKeyObjectSOPInstanceUIDs;
                int n = this.sessionKeyObjectSOPInstanceUIDs.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    iStudyData.getKeyImageManager().removeAutoGeneratedKeyImages(string);
                    ++n2;
                }
            }
        }
    }

    private void createKeyImagesAutomaticallyIfEnabled() {
        if (Config.impaxee.jvision.MAIN.CreateKeyImagesAutomatically.get()) {
            try {
                this.createKeyImagesAutomatically();
            }
            catch (Exception exception) {
                log.error("Auto-generation of key images for session failed", (Throwable)exception);
            }
        }
    }

    private void createKeyImagesAutomatically() {
        this.removeAutoGeneratedKeyImages();
        Collection<IStudyData> collection = this.markAutoGeneratedKeyImages();
        List<String> list = Session.saveKeyImagesAutomatically(collection);
        this.sessionKeyObjectSOPInstanceUIDs = list.toArray(new String[list.size()]);
    }

    private Collection<IStudyData> markAutoGeneratedKeyImages() {
        HashMap<String, IStudyData> hashMap = new HashMap<String, IStudyData>();
        for (SessionSnapshotRuntime sessionSnapshotRuntime : this.getSnapshots()) {
            ScreenLayoutRuntime[] screenLayoutRuntimeArray;
            List<SessionDisplay> list = sessionSnapshotRuntime.displays();
            int n = 0;
            ScreenLayoutRuntime[] screenLayoutRuntimeArray2 = screenLayoutRuntimeArray = sessionSnapshotRuntime.getLayout().screenLayouts();
            int n2 = screenLayoutRuntimeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                DisplayLayoutRuntime[] displayLayoutRuntimeArray;
                ScreenLayoutRuntime screenLayoutRuntime = screenLayoutRuntimeArray2[n3];
                DisplayLayoutRuntime[] displayLayoutRuntimeArray2 = displayLayoutRuntimeArray = screenLayoutRuntime.displayLayouts();
                int n4 = displayLayoutRuntimeArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    DisplayLayoutRuntime displayLayoutRuntime = displayLayoutRuntimeArray2[n5];
                    if (n < list.size()) {
                        SessionDisplay sessionDisplay = list.get(n);
                        ++n;
                        int n6 = sessionDisplay.getNavigPos();
                        ISessionDisplaySet iSessionDisplaySet = sessionDisplay.getSessionDisplaySet();
                        if (iSessionDisplaySet != null && !iSessionDisplaySet.isSetLiveSecondaryCapture() && NON_AGGREGATING_PLUGIN_NAMES.contains(sessionDisplay.getPluginName())) {
                            Object[][] objectArray = iSessionDisplaySet.getFrames();
                            NavigationLocation navigationLocation = new NavigationLocation(n6, objectArray);
                            Dimension dimension = ImpaxEEUtils.horizontalXVertical2Dimension(displayLayoutRuntime.getHorizontalXVertical());
                            Object[] objectArray2 = objectArray[navigationLocation.getSecondaryIndex()];
                            int n7 = navigationLocation.getPosition();
                            int n8 = Math.min(n7 + dimension.width * dimension.height, objectArray2.length);
                            Session.markAutoGeneratedKeyImages((IFrameObjectData[])objectArray2, n7, n8, hashMap);
                        }
                    }
                    ++n5;
                }
                ++n3;
            }
        }
        return hashMap.values();
    }

    private static void markAutoGeneratedKeyImages(IFrameObjectData[] iFrameObjectDataArray, int n, int n2, Map<String, IStudyData> map) {
        int n3 = n;
        while (n3 < n2) {
            IFrameObjectData iFrameObjectData = iFrameObjectDataArray[n3];
            IStudyData iStudyData = iFrameObjectData.getParent().getParent();
            if (!map.containsKey(iStudyData.getStudyInstanceUID())) {
                iStudyData.getKeyImageManager().startEditMode();
                map.put(iStudyData.getStudyInstanceUID(), iStudyData);
            }
            KeyImageManager.ofFrame(iFrameObjectData).mark(iFrameObjectData, KeyImageType.AutoGeneratedBySession);
            ++n3;
        }
    }

    private static List<String> saveKeyImagesAutomatically(Collection<IStudyData> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (IStudyData iStudyData : collection) {
            for (KeyObjectAttributes keyObjectAttributes : iStudyData.getKeyImageManager().saveKeyImagesAutomatically()) {
                arrayList.add(keyObjectAttributes.toDataset().getString(524312));
            }
        }
        return arrayList;
    }

    private boolean updateSelectedSnapshot() {
        if (this.getSnapshotCount() > 0 && DataSelectionManager.getInstance().getActiveHanging() == this) {
            int n;
            IHanging.SnapshotModel snapshotModel = this.getSnapshotModel();
            int n2 = n = snapshotModel.size() == 1 ? 0 : snapshotModel.getSelectedIndex();
            if (n >= 0) {
                snapshotModel.update(n);
                return true;
            }
        }
        return false;
    }

    private boolean updateSnapshot(int n) {
        if (this.getSnapshotCount() > 0 && DataSelectionManager.getInstance().getActiveHanging() == this) {
            IHanging.SnapshotModel snapshotModel = this.getSnapshotModel();
            if (n >= 0) {
                snapshotModel.update(n);
                return true;
            }
        }
        return false;
    }

    private boolean saveSession(Collection<IWorklistContext> collection) {
        try {
            SessionStorage sessionStorage = new SessionStorage();
            SaveData saveData = sessionStorage.writeSession(this);
            this.storeHandlers = new ArrayList<IStoreHandler>(2);
            this.addStoreHandler(DataManager.getInstance().getDataStore().store(saveData.getKeyObject(), saveData.getStudy(), collection));
            ArrayList<IObjectData> arrayList = new ArrayList<IObjectData>();
            for (SessionSnapshotRuntime object2 : this.snaps) {
                object2.collectUnsavedSetLiveData(arrayList);
            }
            this.addStoreHandler(DataManager.getInstance().getDataStore().store(arrayList, saveData.getStudy(), null));
            IKeyObjectData iKeyObjectData = saveData.getKeyObject();
            IPatientData iPatientData = iKeyObjectData.getParent() == null ? DataSelectionManager.getInstance().getCurrentPatient().getPatientData() : iKeyObjectData.getParent().getParent().getParent();
            IStudyData iStudyData = this.getSessionBaseStudy();
            ObjectID objectID = ObjectID.forSingleInstance((String)iPatientData.getDicomObject().getString(0x100020), (String)iKeyObjectData.getSOPInstanceUID());
            objectID.setStudyUID(iKeyObjectData.getDicomObject().getString(0x20000D));
            ObjectID objectID2 = ObjectID.forStudyUIDPatient((String)iStudyData.getParent().getDicomObject().getString(0x100020), (String)iStudyData.getParent().getDicomObject().getString(0x100021), (String)iStudyData.getStudyInstanceUID());
            IntegrationFrameworkFactory.getInstance().queueNotification((INotificationMessage)new SessionStored2(objectID, objectID2, this.getVisibleName()));
            this.setSavedAndRepaint(true);
            return true;
        }
        catch (Throwable throwable) {
            log.error("Could not store session", throwable);
            return false;
        }
    }

    @Override
    public boolean saveSessionOnly(Collection<IWorklistContext> collection) {
        if (this.getSnapshotCount() == 0) {
            return false;
        }
        this.updateSelectedSnapshot();
        this.createKeyImagesAutomaticallyIfEnabled();
        return this.saveSession(collection);
    }

    private void addStoreHandler(IStoreHandler iStoreHandler) {
        if (iStoreHandler != null) {
            this.storeHandlers.add(iStoreHandler);
        }
    }

    @Override
    public List<IStoreHandler> getStoreHandlers() {
        return this.storeHandlers;
    }

    @Override
    public boolean isSaved() {
        return this.isSaved;
    }

    @Override
    public boolean isSetLiveEnabled() {
        return this.isSetLiveEnabled;
    }

    public SessionSnapshotRuntime addSnapshot(Integer n) {
        SessionSnapshotRuntime sessionSnapshotRuntime = this.captureSnapshot();
        this.addSnap(n, sessionSnapshotRuntime);
        return sessionSnapshotRuntime;
    }

    private int addSnap(Integer n, SessionSnapshotRuntime sessionSnapshotRuntime) {
        this.setSavedAndRepaint(false);
        if (n == null || n < 0 || n >= this.getSnapshotCount()) {
            this.snaps.add(sessionSnapshotRuntime);
            return this.snaps.size() - 1;
        }
        this.snaps.add(n, sessionSnapshotRuntime);
        return n;
    }

    public void removeSnapshot(int n) {
        if (n < 0 || n >= this.getSnapshotCount()) {
            return;
        }
        this.setSavedAndRepaint(false);
        this.snaps.remove(n);
        this.removeUnusedSetLiveSCs();
    }

    private void initFromActiveHanging() {
        String[] stringArray;
        IDisplaySet[] iDisplaySetArray;
        if (this.patientRepresentation == null || this.patientRepresentation.getActiveHanging() == null) {
            return;
        }
        IHanging iHanging = this.patientRepresentation.getActiveHanging();
        IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray = iHanging.getSplitAndSortRuntime().getDisplaySets();
        int n = iDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            stringArray = iDisplaySetArray2[n2];
            this.splitAndSortRuntime.addDisplaySet((IDisplaySet)stringArray, SplitAndSortChangeType.DATA_LOAD);
            ++n2;
        }
        if (iHanging instanceof Session) {
            stringArray = ((Session)iHanging).studyOrdering;
            this.studyOrdering = Arrays.copyOf(stringArray, stringArray.length);
        } else {
            stringArray = iHanging.getStudyContainer();
            this.studyOrdering = new String[stringArray.getRelevantPriorCount() + 1];
            this.studyOrdering[0] = stringArray.getBaseStudy().getStudyInstanceUID();
            n2 = 0;
            while (n2 < stringArray.getRelevantPriorCount()) {
                this.studyOrdering[n2 + 1] = stringArray.getPriorInfo(n2).getStudyUID();
                ++n2;
            }
        }
    }

    public Date getDateTime() {
        return this.dateTime;
    }

    @Override
    public List<IDisplaySet> getDisplaySets() {
        ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>();
        ISessionDisplaySet[] iSessionDisplaySetArray = this.getSplitAndSortRuntime().getDisplaySets();
        int n = iSessionDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISessionDisplaySet iSessionDisplaySet = iSessionDisplaySetArray[n2];
            arrayList.add(iSessionDisplaySet);
            ++n2;
        }
        return arrayList;
    }

    @Override
    public IStudyContainer getStudyContainer() {
        return this.myStudyContainer;
    }

    int getStudyOrdering(String string) {
        return ArrayUtils.indexOf((Object[])this.studyOrdering, (Object)string);
    }

    IStudyData getSessionBaseStudy() {
        IStudyData iStudyData;
        Iterator<IStudyData> iterator;
        if (this.studyOrdering != null) {
            iterator = this.splitAndSortRuntime.getStudies().iterator();
            while (iterator.hasNext()) {
                iStudyData = iterator.next();
                if (this.getStudyOrdering(iStudyData.getKey()) != 0) continue;
                return iStudyData;
            }
        }
        if ((iterator = this.splitAndSortRuntime.getStudies().iterator()).hasNext()) {
            iStudyData = iterator.next();
            return iStudyData;
        }
        return null;
    }

    protected void removeUnusedSetLiveSCs() {
        Collection<ISessionDisplaySet> collection = this.collectAllSetLiveSCs();
        this.removeUsedSessionDisplaySets(collection);
        ArrayList<ISessionDisplaySet> arrayList = new ArrayList<ISessionDisplaySet>(collection.size());
        for (ISessionDisplaySet iSessionDisplaySet : collection) {
            arrayList.add(iSessionDisplaySet);
            this.splitAndSortRuntime.removeDisplaySet(iSessionDisplaySet, SplitAndSortChangeType.INVALIDATION);
        }
        DataManager.getInstance().removeDisplaySet(arrayList.toArray(new IDisplaySet[arrayList.size()]), SplitAndSortChangeType.INVALIDATION, true, false);
    }

    private Collection<ISessionDisplaySet> collectAllSetLiveSCs() {
        HashSet<ISessionDisplaySet> hashSet = new HashSet<ISessionDisplaySet>();
        ISessionDisplaySet[] iSessionDisplaySetArray = this.splitAndSortRuntime.getDisplaySets();
        int n = iSessionDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISessionDisplaySet iSessionDisplaySet = iSessionDisplaySetArray[n2];
            if (iSessionDisplaySet.isSetLiveSecondaryCapture()) {
                hashSet.add(iSessionDisplaySet);
            }
            ++n2;
        }
        return hashSet;
    }

    private void removeUsedSessionDisplaySets(Collection<ISessionDisplaySet> collection) {
        for (SessionSnapshotRuntime sessionSnapshotRuntime : this.snaps) {
            for (SessionDisplay sessionDisplay : sessionSnapshotRuntime.displays()) {
                collection.remove(sessionDisplay.getSessionDisplaySet());
            }
        }
    }

    @Override
    public List<IWorklistContext> getUserAndScheduledWorklistContexts() {
        Collection<IWorklistContext> collection = DataManager.getInstance().getDataStore().getAvailableWorklistContexts();
        ArrayList<IWorklistContext> arrayList = new ArrayList<IWorklistContext>();
        boolean bl = Config.impaxee.jvision.DIALOGS.ShowOnlySelectedWorklists.get();
        for (IWorklistContext iWorklistContext : collection) {
            if (!"USER".equals(iWorklistContext.getType()) && !iWorklistContext.isScheduled() || bl && !iWorklistContext.isSelected()) continue;
            arrayList.add(iWorklistContext);
        }
        return arrayList;
    }

    @Override
    public UnsavedDataTypes getType() {
        return UnsavedDataTypes.Sessions;
    }

    @Override
    public ISaveItem newSaveItem(IPatientRepresentation iPatientRepresentation) {
        ImageAreaWorklistChooserPanel imageAreaWorklistChooserPanel;
        List<IWorklistContext> list = this.getUserAndScheduledWorklistContexts();
        if (list.isEmpty()) {
            imageAreaWorklistChooserPanel = null;
        } else {
            imageAreaWorklistChooserPanel = new ImageAreaWorklistChooserPanel(list, this, Config.impaxee.jvision.DIALOGS.RememberLastUsedWorklist.get());
            Collection<IWorklistContext> collection = ImageAreaWorklistChooserPanel.getUnsavedHangings().get(this);
            if (collection != null && !collection.isEmpty()) {
                imageAreaWorklistChooserPanel.setSelectedWorklistContexts(collection);
            }
        }
        return new SessionSaveItem(imageAreaWorklistChooserPanel);
    }

    @Override
    public SessionSplitAndSortRuntime getSplitAndSortRuntime() {
        return this.splitAndSortRuntime;
    }

    @Override
    public void studyRemoved(IStudyData iStudyData, boolean bl) {
        if (this.getStudyContainer().getBaseStudy().equals(iStudyData)) {
            HangingUtil.dismissHanging(this);
        } else {
            ISessionDisplaySet[] iSessionDisplaySetArray = this.splitAndSortRuntime.getDisplaySets();
            int n = iSessionDisplaySetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStudyData iStudyData2;
                ISessionDisplaySet iSessionDisplaySet = iSessionDisplaySetArray[n2];
                IFrameObjectData iFrameObjectData = iSessionDisplaySet.getOneObject();
                if (iFrameObjectData != null && (iStudyData2 = iFrameObjectData.getParent().getParent()).equals(iStudyData)) {
                    if (DataSelectionManager.getInstance().getActiveHanging() != this) {
                        HangingUtil.dismissHanging(this);
                        break;
                    }
                    this.splitAndSortRuntime.removeStudy(iStudyData);
                    this.setSavedAndRepaint(false);
                    break;
                }
                ++n2;
            }
        }
    }

    @Override
    public void displaySetAdded(IPatientRepresentation iPatientRepresentation, List<IDisplaySet> list, SplitAndSortChangeType splitAndSortChangeType) {
        if (splitAndSortChangeType == SplitAndSortChangeType.DATA_LOAD && this.splitAndSortRuntime.addDisplaySets(list)) {
            this.setSavedAndRepaint(false);
        }
    }

    @Override
    public void displaySetsRemoved(IDisplaySet[] iDisplaySetArray, SplitAndSortChangeType splitAndSortChangeType) {
        if (splitAndSortChangeType == SplitAndSortChangeType.INVALIDATION && this.splitAndSortRuntime.removeDisplaySets(iDisplaySetArray)) {
            this.setSavedAndRepaint(false);
        }
    }

    @Override
    public IPatientRepresentation getPatient() {
        return this.patientRepresentation;
    }

    @Override
    public String getIdentifier() {
        return this.getSessionUID();
    }

    public void setSessionKeyObject(SessionKeyObject sessionKeyObject, IKeyObjectData iKeyObjectData) {
        this.sessionKeyObject = sessionKeyObject;
        this.keyObjectData = iKeyObjectData;
    }

    public SessionKeyObject getSessionKeyObject() {
        return this.sessionKeyObject;
    }

    public IKeyObjectData getKeyObjectData() {
        return this.keyObjectData;
    }

    @Override
    public void setSaved(boolean bl) {
        this.isSaved = bl;
    }

    private void setSavedAndRepaint(boolean bl) {
        if (this.isSaved != bl) {
            this.isSaved = bl;
            EventUtil.invoke(HangingController.getInstance()::repaintViews);
        }
    }

    @Override
    public IStudyInfo getStudyInstance() {
        if (this.keyObjectData == null) {
            return null;
        }
        return (IStudyInfo)this.keyObjectData.getQueryObject().getTreeParent().getTreeParent();
    }

    List<SessionSnapshotInformation> getAdditionalSnapshotInformation() {
        ArrayList<SessionSnapshotInformation> arrayList = new ArrayList<SessionSnapshotInformation>(this.getSnapshotCount());
        for (SessionSnapshotRuntime sessionSnapshotRuntime : this.getSnapshots()) {
            arrayList.add(sessionSnapshotRuntime.getAdditionalInformation());
        }
        return arrayList;
    }

    List<IHangingSessionExtension> getExtensions() {
        return new ArrayList<IHangingSessionExtension>(this.extensions.values());
    }

    @Override
    public IHangingSessionExtension getExtension(String string) {
        return this.extensions.get(string);
    }

    @Override
    public final void addExtension(IHangingSessionExtension iHangingSessionExtension) {
        this.extensions.put(iHangingSessionExtension.getID(), iHangingSessionExtension);
    }

    @Override
    public IHangingSessionExtension removeExtension(String string) {
        return this.extensions.remove(string);
    }

    private void createExtensions() {
        for (IHangingSessionExtensionProvider iHangingSessionExtensionProvider : IHangingSessionExtensionProvider.FACTORY.getExtensions()) {
            IHangingSessionExtension iHangingSessionExtension = iHangingSessionExtensionProvider.createExtension(this);
            if (iHangingSessionExtension == null) continue;
            this.addExtension(iHangingSessionExtension);
        }
    }

    private static String get4DInfoKey(IDisplaySet iDisplaySet) {
        return iDisplaySet.getFrames()[0][0].getSOPInstanceUID();
    }

    @Override
    public void snapshotAdded(int n, AbstractSnapshotRuntime abstractSnapshotRuntime) {
    }

    @Override
    public void snapshotRemoved(int n) {
    }

    @Override
    public void snapshotUpdated(int n) {
    }

    @Override
    public void snapshotSelected(int n, int n2) {
        if (!this.isSaved) {
            SessionSnapshotModel sessionSnapshotModel = (SessionSnapshotModel)this.snapshotModel;
            if (sessionSnapshotModel.isSnapshotCaptureDisabled()) {
                sessionSnapshotModel.resetSnaphotCapturing();
            } else {
                this.updateSnapshot(n2);
            }
        }
    }

    private class SessionSaveItem
    implements ISaveItem {
        private final ImageAreaWorklistChooserPanel worklistChooserPanel;

        SessionSaveItem(ImageAreaWorklistChooserPanel imageAreaWorklistChooserPanel) {
            this.worklistChooserPanel = imageAreaWorklistChooserPanel;
        }

        @Override
        public boolean save(boolean bl) {
            if (this.worklistChooserPanel == null) {
                return Session.this.saveSessionOnly(null);
            }
            return this.worklistChooserPanel.saveSessionOnly(true);
        }

        @Override
        public List<IStoreHandler> getStoreHandlers() {
            return Session.this.getStoreHandlers();
        }

        @Override
        public Component getComponent() {
            if (this.worklistChooserPanel != null) {
                return this.worklistChooserPanel;
            }
            JPanel jPanel = new JPanel((LayoutManager)new RowLayout(MARGIN));
            jPanel.setBorder(SwingUtilities2.createEmptyBorder((int)MARGIN));
            jPanel.add(ComponentFactory.instance.createLabel(Messages.getString("SessionSaveItem.NoWorklistAvailable.Label")));
            return jPanel;
        }

        @Override
        public boolean isSaveable() {
            return true;
        }

        @Override
        public void setSaveManager(ISaveManager iSaveManager) {
            if (this.worklistChooserPanel != null) {
                this.worklistChooserPanel.setSaveManager(iSaveManager);
            }
        }
    }

    private class SessionSnapshotModel
    extends AbstractHangingSnapshotModel {
        private boolean isSnapshotCaptureDisabled = false;

        private SessionSnapshotModel() {
        }

        @Override
        public int size() {
            return Session.this.getSnapshotCount();
        }

        @Override
        public AbstractSnapshotRuntime get(int n) {
            return Session.this.getSnapshot(n);
        }

        @Override
        public AbstractSnapshotRuntime get(String string) {
            return Session.this.getSnapshot(string);
        }

        @Override
        public AbstractSnapshotRuntime remove(int n) {
            AbstractSnapshotRuntime abstractSnapshotRuntime = this.get(n);
            this.delete(n);
            return abstractSnapshotRuntime;
        }

        @Override
        public void update(int n) {
            SessionSnapshotRuntime sessionSnapshotRuntime = Session.this.getSnapshot(n);
            sessionSnapshotRuntime.capture();
            Session.this.removeUnusedSetLiveSCs();
            Session.this.setSavedAndRepaint(false);
            this.fireUpdateEvent(n);
        }

        @Override
        public void delete(int n) {
            this.isSnapshotCaptureDisabled = true;
            Session.this.removeSnapshot(n);
            this.fireRemoveEvent(n);
        }

        @Override
        public void insertAt(int n, AbstractSnapshotRuntime abstractSnapshotRuntime) {
            if (abstractSnapshotRuntime instanceof SessionSnapshotRuntime) {
                this.isSnapshotCaptureDisabled = true;
                n = Session.this.addSnap(n, (SessionSnapshotRuntime)abstractSnapshotRuntime);
                this.fireAddEvent(n, abstractSnapshotRuntime);
            }
        }

        @Override
        public void add(AbstractSnapshotRuntime abstractSnapshotRuntime) {
            this.insertAt(-1, abstractSnapshotRuntime);
        }

        @Override
        public SessionSnapshotRuntime newInstance() {
            return Session.this.captureSnapshot();
        }

        @Override
        public int indexOf(AbstractSnapshotRuntime abstractSnapshotRuntime) {
            return Session.this.indexOfSnap(abstractSnapshotRuntime);
        }

        void resetSnaphotCapturing() {
            this.isSnapshotCaptureDisabled = false;
        }

        boolean isSnapshotCaptureDisabled() {
            return this.isSnapshotCaptureDisabled;
        }
    }

    private class SessionStudyContainer
    extends AbstractStudyContainer {
        public SessionStudyContainer(String string) {
            super(string);
            this.baseStudy = Session.this.getSessionBaseStudy();
        }

        @Override
        public IPatientRepresentation getPatientRepresentation() {
            return Session.this.patientRepresentation;
        }

        @Override
        public int getRelevantPriorCount() {
            return 0;
        }

        @Override
        public int getLoadedPriorCount() {
            return 0;
        }

        @Override
        public boolean hasStudy(String string) {
            return Session.this.splitAndSortRuntime.hasStudies(string);
        }

        @Override
        public boolean isPriorLoaded(int n) {
            return true;
        }

        @Override
        public IStudyData loadRelevantPrior(int n) {
            return null;
        }

        @Override
        public void setPatientRepresentation(IPatientRepresentation iPatientRepresentation) {
        }

        @Override
        public IStudyInfo getPriorInfo(int n) {
            return null;
        }

        @Override
        public void updateLoadedPriors(Set<String> set) {
        }

        @Override
        public int getIndexOfStudy(String string) {
            if (DATA_MANAGER.isStudyMerged(DATA_MANAGER.getStudy(string))) {
                return -1;
            }
            return Session.this.getStudyOrdering(string);
        }

        @Override
        public StudyType getStudyType(String string) {
            if (DATA_MANAGER.isStudyMerged(DATA_MANAGER.getStudy(string))) {
                return StudyType.MERGED;
            }
            return StudyType.getStudyType(this.getIndexOfStudy(string));
        }

        @Override
        public boolean isStudyAgeCheckEnabled() {
            return false;
        }

        @Override
        public void disableStudyAgeCheck() {
        }
    }
}

