/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.data.shared.util.PatientKeyUtils;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.fetcher.DataHandlerProviderFactory;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.sessions.IHangingSessionExtensionProvider;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.impaxee.sessions.SessionKeyObject;
import com.agfa.pacs.impaxee.sessions.SessionSnapshotInformation;
import com.agfa.pacs.listtext.dicomobject.iod.sr.KeyObjectSelectionDocumentInformationObject;
import com.agfa.pacs.listtext.dicomobject.sr.content.SRReferencedImage;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObject;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IKeyObjectData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.patinfo.DataSelectionManager;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class SessionBuilder
implements Runnable {
    private static ALogger log = ALogger.getLogger(SessionBuilder.class);
    private static DataManager dm = DataManager.getInstance();
    private static DataSelectionManager dsm = DataSelectionManager.getInstance();
    private Attributes dataset = null;
    private IKeyObjectData keyObjectData;
    private String datasetSourceName = null;
    private Session session = null;
    private CountDownLatch sessionLoaded = new CountDownLatch(1);
    private boolean isLoadedSuccessfully;
    private boolean fromMPI = false;
    private String contextID;

    public SessionBuilder(String string, Attributes attributes, IKeyObjectData iKeyObjectData, boolean bl, String string2) {
        if (attributes == null) {
            throw new IllegalArgumentException("constructing SessionBuilder failed");
        }
        this.dataset = attributes;
        this.contextID = string2;
        this.datasetSourceName = string;
        this.keyObjectData = iKeyObjectData;
        this.fromMPI = bl;
    }

    public Attributes getDataset() {
        return this.dataset;
    }

    @Override
    public void run() {
        try {
            this.buildSession();
        }
        finally {
            this.sessionLoaded.countDown();
        }
    }

    private void buildSession() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        List list = null;
        KeyObjectSelectionDocumentInformationObject keyObjectSelectionDocumentInformationObject = KeyObjectSelectionDocumentInformationObject.createInstance((Attributes)this.dataset);
        SessionKeyObject sessionKeyObject = new SessionKeyObject(keyObjectSelectionDocumentInformationObject, null, this.dataset);
        if (this.dataset.contains("TIANI", 2687060)) {
            sessionKeyObject.setStudyOrdering(this.dataset.getStrings("TIANI", 2687060));
        }
        if (this.dataset.contains("TIANI", 2687074)) {
            sessionKeyObject.setSessionKeyObjectSOPInstanceUIDs(this.dataset.getStrings("TIANI", 2687074));
        }
        if (this.dataset.contains("TIANI", 2687061)) {
            object5 = this.dataset.getSequence("TIANI", 2687061);
            object4 = new ArrayList(object5.size());
            object3 = object5.iterator();
            while (object3.hasNext()) {
                object2 = (Attributes)object3.next();
                object4.add((SessionSnapshotInformation)new SessionSnapshotInformation((Attributes)object2));
            }
            sessionKeyObject.setAdditionalSnapshotInformation((List<SessionSnapshotInformation>)object4);
        }
        sessionKeyObject.setExtensions(IHangingSessionExtensionProvider.FACTORY.getExtensions().stream().map(iHangingSessionExtensionProvider -> iHangingSessionExtensionProvider.readExtension(this.dataset)).filter(Objects::nonNull).collect(Collectors.toList()));
        sessionKeyObject.setSessionData(this.dataset);
        list = sessionKeyObject.referencedImages();
        if (list == null) {
            return;
        }
        object5 = new ArrayList(list.size());
        object2 = list.iterator();
        while (object2.hasNext()) {
            object4 = (SRReferencedImage)object2.next();
            object5.add(object4.getSOPInstanceUID());
        }
        object4 = DataManager.getInstance().getPatientRepresentation(this.dataset);
        if (object4 == null && log.isDebugEnabled()) {
            log.debug("Patient {} not found among currently loaded ones: {})", (Object)PatientKeyUtils.generatePatientKey((Attributes)this.dataset), DataManager.getInstance().getPatientRepresentations());
        }
        if ((object2 = dm.getNotLoadedSOPInstanceUIDs((List<String>)object5, (IPatientRepresentation)object4)) != null && !object2.isEmpty()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Attempting to load/open " + object2.size() + " objects");
                }
                object3 = null;
                if (!ReferringObject.isTemporaryMergedPatientSession((Attributes)this.dataset)) {
                    object = this.dataset.getString(0x100020);
                    if (object == null) {
                        log.warn("Disabling support for MPI sessions due to missing patient ID");
                    } else {
                        object3 = PatientKeyUtils.generatePatientKey((String)object, null, (String)this.dataset.getString(0x100021));
                    }
                }
                object = DataHandlerProviderFactory.getInstance().getDataHandlerProvider().getRetriever();
                object.retrieveObjects(this.datasetSourceName, (Collection<String>)object2, (String)object3);
                log.debug("Loading/Opening missing objects succeeded");
            }
            catch (Exception exception) {
                log.error("Loading/Opening missing objects failed!");
                return;
            }
        }
        try {
            Object object6;
            object3 = new ByteArrayInputStream(sessionKeyObject.getSessionData());
            object = new DataInputStream((InputStream)object3);
            IPatientRepresentation iPatientRepresentation = dm.getPatientRepresentation(this.dataset);
            if (iPatientRepresentation == null) {
                iPatientRepresentation = dm.getPatientRepresentationWeakMatch(this.dataset);
            }
            if (iPatientRepresentation == null) {
                object6 = null;
                if (this.fromMPI) {
                    object6 = dm.getSimilarPatient(this.dataset, null);
                }
                if (object6 == null) {
                    object6 = dm.getMergedPatient(PatientKeyUtils.generatePatientKey((Attributes)this.dataset));
                }
                if (object6 != null) {
                    iPatientRepresentation = dm.getPatientRepresentation(object6.getKey());
                }
            }
            if (iPatientRepresentation == null) {
                log.error("Patient not recognized");
                return;
            }
            object6 = DateTimeUtils.getStudyDateTime((Attributes)this.dataset);
            Sequence sequence = this.dataset.getSequence("TIANI", 2687063);
            this.session = new Session((DataInputStream)object, iPatientRepresentation, (Date)object6, sessionKeyObject, this.keyObjectData, sequence, this.contextID);
            sessionKeyObject.setStudyContainer(this.session.getStudyContainer());
            ((FilterInputStream)object).close();
            iPatientRepresentation.addHanging(this.session);
            dm.notifyPatientRepresentationModified(iPatientRepresentation);
            this.isLoadedSuccessfully = true;
        }
        catch (Exception exception) {
            log.error("Could not read session content", (Throwable)exception);
        }
    }

    public void display() {
        try {
            this.sessionLoaded.await();
        }
        catch (InterruptedException interruptedException) {}
        if (this.isLoadedSuccessfully) {
            boolean bl = false;
            if (this.session.getKeyObjectData() != null) {
                bl = (Boolean)this.session.getKeyObjectData().getQueryObject().getTreeParent().getTreeParent().getAttributes().getProperty("SET_ASIDE_STATUS", (Object)Boolean.FALSE);
            }
            if (bl || Config.impaxee.jvision.HANGMAN.preferSessionsOverHangingProtocols.get()) {
                dsm.setActiveHanging(this.session.getPatient(), this.session, true, true, false);
            }
        }
        IPatientRepresentation iPatientRepresentation = null;
        if (this.session != null) {
            iPatientRepresentation = this.session.getPatient();
        }
        if (iPatientRepresentation == null) {
            try {
                iPatientRepresentation = dm.getPatientRepresentation(PatientKeyUtils.generatePatientKey((Attributes)this.dataset));
            }
            catch (Exception exception) {
                log.error("Could not find patient", (Throwable)exception);
            }
        }
        if (iPatientRepresentation != null) {
            dsm.setCurrentPatient(iPatientRepresentation);
            dm.refreshHangings(iPatientRepresentation, true, false);
        }
    }

    public Collection<IStudyData> getContainedStudies() {
        if (this.session == null) {
            return Collections.emptyList();
        }
        LinkedHashMap<String, IStudyData> linkedHashMap = new LinkedHashMap<String, IStudyData>();
        for (IDisplaySet iDisplaySet : this.session.getDisplaySets()) {
            IStudyData iStudyData = iDisplaySet.getOneObject().getParent().getParent();
            if (linkedHashMap.containsKey(iStudyData.getKey())) continue;
            linkedHashMap.put(iStudyData.getKey(), iStudyData);
        }
        return linkedHashMap.values();
    }

    public Date getCreationDateTime() {
        return DateTimeUtils.getStudyDateTime((Attributes)this.dataset);
    }
}

