/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions;

import com.agfa.pacs.impaxee.User;
import com.agfa.pacs.impaxee.presentationstate.PresentationStatePoolCollector;
import com.agfa.pacs.impaxee.presentationstate.PresentationStateType;
import com.agfa.pacs.impaxee.presentationstate.RDCPresentationState;
import com.agfa.pacs.impaxee.sessions.ISessionDisplaySet;
import com.agfa.pacs.impaxee.sessions.SessionSnapshotRuntime;
import com.agfa.pacs.impaxee.splitsort.I4DProperties;
import com.agfa.pacs.tools.StreamUtil;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.vis.VisDisplay2;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;

public class SessionDisplay {
    protected String pluginName = "Default";
    protected int navigPos = 0;
    protected boolean isSynced = false;
    protected List<Attributes> psts = new Vector<Attributes>();
    protected boolean[] visSelectStates = new boolean[0];
    protected boolean[] objMarkedStates = new boolean[0];
    private boolean hasMarked = false;
    protected int navigPosMarked = 0;
    protected List<Attributes> pstsMarked = new Vector<Attributes>();
    protected boolean[] visSelectStatesMarked = new boolean[0];
    private ISessionDisplaySet sessionDisplaySet = null;
    private final SessionSnapshotRuntime parent;
    private int secondaryIndex;
    private boolean fourDReverted;
    int[] seqObjIndexesMarked = new int[0];
    transient VisDisplay2 disp;
    private boolean isMissingPresentationStates;

    public SessionDisplay(SessionSnapshotRuntime sessionSnapshotRuntime) {
        this.parent = sessionSnapshotRuntime;
    }

    public SessionDisplay(DataInputStream dataInputStream, ISessionDisplaySet[] iSessionDisplaySetArray, SessionSnapshotRuntime sessionSnapshotRuntime, Integer n) throws IOException {
        this(sessionSnapshotRuntime);
        this.read(dataInputStream, iSessionDisplaySetArray);
        if (n != null) {
            this.secondaryIndex = n;
        }
    }

    public SessionDisplay(VisDisplay2 visDisplay2, ISessionDisplaySet iSessionDisplaySet, SessionSnapshotRuntime sessionSnapshotRuntime) {
        this(sessionSnapshotRuntime);
        this.capture(visDisplay2, iSessionDisplaySet);
    }

    public SessionSnapshotRuntime getParent() {
        return this.parent;
    }

    public boolean isFourDReverted() {
        return this.fourDReverted;
    }

    private void capture(VisDisplay2 visDisplay2, ISessionDisplaySet iSessionDisplaySet) {
        block6: {
            block5: {
                this.disp = visDisplay2;
                this.pluginName = iSessionDisplaySet.isSetLiveSecondaryCapture() ? PluginName.DEFAULT.getPluginName() : this.disp.getData().getPlugin().getName();
                this.navigPos = visDisplay2.getNavigationHandler().getCurrentSessionPosition();
                I4DProperties i4DProperties = visDisplay2.getData().get4DProperties();
                this.secondaryIndex = i4DProperties.getSecondaryIndex();
                this.fourDReverted = !i4DProperties.isPrimaryNavigationInSpace();
                this.isSynced = this.disp.isSynchronized();
                this.sessionDisplaySet = iSessionDisplaySet;
                PresentationStatePoolCollector presentationStatePoolCollector = new PresentationStatePoolCollector(User.getUserNameAsPN(), "SESSION", this.getParent().getParent().getVisibleName(), PresentationStateType.SESSION);
                this.disp.createPresentationStates(presentationStatePoolCollector);
                this.psts.clear();
                this.psts.addAll(presentationStatePoolCollector.getPresentationStateDicomObjects());
                boolean bl = this.disp.getData().isDefaultPluginActive();
                boolean bl2 = this.isMissingPresentationStates = presentationStatePoolCollector.isMissingData() && bl && RDCPresentationState.isSupported(this.disp.getData().getDisplaySet().getOneObject());
                if (bl) break block5;
                int n = this.disp.getVis().size();
                this.visSelectStates = new boolean[n];
                this.objMarkedStates = new boolean[n];
                int n2 = 0;
                while (n2 < n) {
                    this.visSelectStates[n2] = this.disp.getVis().get(n2).isSelected();
                    this.objMarkedStates[n2] = false;
                    ++n2;
                }
                break block6;
            }
            int n = this.disp.getVis().size();
            this.visSelectStates = new boolean[n];
            this.objMarkedStates = new boolean[n];
            int n3 = 0;
            while (n3 < n) {
                this.visSelectStates[n3] = this.disp.getVis().get(n3).isSelected();
                this.objMarkedStates[n3] = false;
                ++n3;
            }
            n3 = 0;
            int n4 = 0;
            while (n4 < this.objMarkedStates.length) {
                this.objMarkedStates[n4] = false;
                if (this.objMarkedStates[n4]) {
                    n3 = 1;
                }
                ++n4;
            }
            if (n3 != 0) break block6;
            n4 = 0;
            while (n4 < this.objMarkedStates.length) {
                this.objMarkedStates[n4] = true;
                ++n4;
            }
        }
    }

    public VisDisplay2 getVisDisplay() {
        return this.disp;
    }

    public void setVisDisplay(VisDisplay2 visDisplay2) {
        this.disp = visDisplay2;
    }

    public ISessionDisplaySet getSessionDisplaySet() {
        return this.sessionDisplaySet;
    }

    public void setSessionDisplaySet(ISessionDisplaySet iSessionDisplaySet) {
        this.sessionDisplaySet = iSessionDisplaySet;
    }

    public String getSeqUID() {
        if (this.sessionDisplaySet != null) {
            return this.sessionDisplaySet.getSessionSeqUID();
        }
        return "";
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public boolean[] getVisSelectStates() {
        return this.visSelectStates;
    }

    public int getNavigPos() {
        return this.navigPos;
    }

    int getSecondaryIndex() {
        return this.secondaryIndex;
    }

    public List<Attributes> getPresentationStates() {
        return this.psts;
    }

    public boolean isMissingPresentationStates() {
        return this.isMissingPresentationStates;
    }

    void write(DataOutput dataOutput) throws IOException {
        Object[] objectArray;
        dataOutput.writeUTF(this.getSeqUID());
        dataOutput.writeUTF(this.pluginName);
        dataOutput.writeInt(this.navigPos);
        dataOutput.writeBoolean(this.isSynced);
        dataOutput.writeInt(this.psts.size());
        for (Attributes attributes : this.psts) {
            this.writeDicomObject(dataOutput, attributes);
        }
        dataOutput.writeInt(this.visSelectStates.length);
        boolean[] blArray = this.visSelectStates;
        int n = this.visSelectStates.length;
        int n2 = 0;
        while (n2 < n) {
            boolean bl = blArray[n2];
            dataOutput.writeBoolean(bl);
            ++n2;
        }
        int n3 = 0;
        n2 = 0;
        while (n2 < this.objMarkedStates.length) {
            if (this.objMarkedStates[n2]) {
                ++n3;
            }
            ++n2;
        }
        if (n3 == 0 || n3 == this.objMarkedStates.length) {
            dataOutput.writeInt(0);
        } else {
            dataOutput.writeInt(this.objMarkedStates.length);
            objectArray = this.objMarkedStates;
            int n4 = this.objMarkedStates.length;
            n = 0;
            while (n < n4) {
                n2 = objectArray[n];
                dataOutput.writeBoolean(n2 != 0);
                ++n;
            }
        }
        dataOutput.writeInt(this.seqObjIndexesMarked.length);
        objectArray = this.seqObjIndexesMarked;
        int n5 = this.seqObjIndexesMarked.length;
        n = 0;
        while (n < n5) {
            n2 = objectArray[n];
            dataOutput.writeInt(n2);
            ++n;
        }
    }

    private void read(DataInputStream dataInputStream, ISessionDisplaySet[] iSessionDisplaySetArray) throws IOException {
        int n;
        String string = dataInputStream.readUTF();
        this.pluginName = dataInputStream.readUTF();
        this.navigPos = dataInputStream.readInt();
        this.isSynced = dataInputStream.readBoolean();
        int n2 = dataInputStream.readInt();
        this.psts.clear();
        int n3 = 0;
        while (n3 < n2) {
            Attributes attributes = this.readDicomObject(dataInputStream);
            this.psts.add(attributes);
            ++n3;
        }
        n3 = dataInputStream.readInt();
        this.visSelectStates = new boolean[n3];
        int n4 = 0;
        while (n4 < this.visSelectStates.length) {
            this.visSelectStates[n4] = dataInputStream.readBoolean();
            ++n4;
        }
        n4 = dataInputStream.readInt();
        this.objMarkedStates = new boolean[n3];
        if (n4 == 0) {
            n = 0;
            while (n < this.objMarkedStates.length) {
                this.objMarkedStates[n] = true;
                ++n;
            }
        } else {
            n = 0;
            while (n < this.objMarkedStates.length) {
                this.objMarkedStates[n] = dataInputStream.readBoolean();
                ++n;
            }
        }
        this.restoreMarkedSettings();
        n = dataInputStream.readInt();
        this.seqObjIndexesMarked = new int[n];
        int n5 = 0;
        while (n5 < n) {
            this.seqObjIndexesMarked[n5] = dataInputStream.readInt();
            ++n5;
        }
        ISessionDisplaySet[] iSessionDisplaySetArray2 = iSessionDisplaySetArray;
        int n6 = iSessionDisplaySetArray.length;
        int n7 = 0;
        while (n7 < n6) {
            ISessionDisplaySet iSessionDisplaySet = iSessionDisplaySetArray2[n7];
            if (iSessionDisplaySet.getSessionSeqUID().equals(string)) {
                this.sessionDisplaySet = iSessionDisplaySet;
                break;
            }
            ++n7;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeDicomObject(DataOutput dataOutput, Attributes attributes) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                try (DicomOutputStream dicomOutputStream = new DicomOutputStream((OutputStream)byteArrayOutputStream, "1.2.840.10008.1.2.1");){
                    dicomOutputStream.writeDataset(attributes.createFileMetaInformation("1.2.840.10008.1.2.1"), attributes);
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    dataOutput.writeInt(byArray.length);
                    dataOutput.write(byArray);
                }
                if (byteArrayOutputStream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (byteArrayOutputStream == null) throw throwable;
                byteArrayOutputStream.close();
                throw throwable;
            }
            byteArrayOutputStream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private Attributes readDicomObject(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        StreamUtil.readStream((InputStream)dataInputStream, (byte[])byArray);
        Throwable throwable = null;
        Object var5_6 = null;
        try (DicomInputStream dicomInputStream = new DicomInputStream((InputStream)new ByteArrayInputStream(byArray));){
            return dicomInputStream.readDataset(-1, -1);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void restoreMarkedSettings() {
        this.hasMarked = false;
        int n = 0;
        int n2 = 0;
        while (n2 < this.objMarkedStates.length) {
            if (this.objMarkedStates[n2]) {
                ++n;
            }
            ++n2;
        }
        if (n != this.objMarkedStates.length && n != 0) {
            this.hasMarked = true;
        }
        this.navigPosMarked = this.navigPos;
        this.pstsMarked.clear();
        this.visSelectStatesMarked = new boolean[n];
        if (this.hasMarked) {
            n2 = 0;
            while (n2 < this.navigPos) {
                if (!this.objMarkedStates[n2]) {
                    --this.navigPosMarked;
                }
                ++n2;
            }
            n2 = 0;
            int n3 = 0;
            while (n3 < this.objMarkedStates.length) {
                if (this.objMarkedStates[n3]) {
                    this.pstsMarked.add(this.psts.get(n3));
                    this.visSelectStatesMarked[n2] = this.visSelectStates[n3];
                    ++n2;
                }
                ++n3;
            }
        }
    }

    public boolean isSynced() {
        return this.isSynced;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SessionDisplay)) {
            return false;
        }
        SessionDisplay sessionDisplay = (SessionDisplay)object;
        if (!this.getSeqUID().equals(sessionDisplay.getSeqUID())) {
            return false;
        }
        if (!this.pluginName.equals(sessionDisplay.pluginName)) {
            return false;
        }
        if (this.navigPos != sessionDisplay.navigPos) {
            return false;
        }
        if (this.isSynced != sessionDisplay.isSynced) {
            return false;
        }
        if (this.psts.size() != sessionDisplay.psts.size()) {
            return false;
        }
        if (this.visSelectStates.length != sessionDisplay.visSelectStates.length) {
            return false;
        }
        if (this.objMarkedStates.length != sessionDisplay.objMarkedStates.length) {
            return false;
        }
        int n = 0;
        while (n < this.visSelectStates.length) {
            if (this.visSelectStates[n] != sessionDisplay.visSelectStates[n]) {
                return false;
            }
            ++n;
        }
        n = 0;
        while (n < this.objMarkedStates.length) {
            if (this.objMarkedStates[n] != sessionDisplay.objMarkedStates[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[]{"psts", "pstsMarked"});
    }

    public SessionDisplay cloneForSave() {
        SessionDisplay sessionDisplay = new SessionDisplay(this.getParent());
        sessionDisplay.sessionDisplaySet = this.sessionDisplaySet.cloneForSave();
        sessionDisplay.pluginName = this.pluginName;
        sessionDisplay.navigPos = this.navigPos;
        sessionDisplay.isSynced = this.isSynced;
        sessionDisplay.hasMarked = this.hasMarked;
        sessionDisplay.navigPosMarked = this.navigPosMarked;
        sessionDisplay.disp = this.disp;
        int n = 0;
        while (n < this.psts.size()) {
            sessionDisplay.psts.add(this.psts.get(n));
            ++n;
        }
        n = 0;
        while (n < this.pstsMarked.size()) {
            sessionDisplay.pstsMarked.add(this.pstsMarked.get(n));
            ++n;
        }
        sessionDisplay.objMarkedStates = new boolean[this.objMarkedStates.length];
        System.arraycopy(this.objMarkedStates, 0, sessionDisplay.objMarkedStates, 0, this.objMarkedStates.length);
        sessionDisplay.visSelectStates = new boolean[this.visSelectStates.length];
        System.arraycopy(this.visSelectStates, 0, sessionDisplay.visSelectStates, 0, this.visSelectStates.length);
        sessionDisplay.visSelectStatesMarked = new boolean[this.visSelectStatesMarked.length];
        System.arraycopy(this.visSelectStatesMarked, 0, sessionDisplay.visSelectStatesMarked, 0, this.visSelectStatesMarked.length);
        sessionDisplay.secondaryIndex = this.secondaryIndex;
        sessionDisplay.fourDReverted = this.fourDReverted;
        return sessionDisplay;
    }
}

