/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions;

import com.agfa.pacs.data.shared.code.CodeDictionary;
import com.agfa.pacs.impaxee.hanging.IHangingSessionExtension;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.keyimages.KeyImageObject;
import com.agfa.pacs.impaxee.sessions.Session4DInfo;
import com.agfa.pacs.impaxee.sessions.SessionSnapshotInformation;
import com.agfa.pacs.listtext.dicomobject.iod.sr.KeyObjectSelectionDocumentInformationObject;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IKeyObjectData;
import com.tiani.base.data.IStudyData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;

public class SessionKeyObject
extends KeyImageObject {
    private byte[] sessionData;
    private String patientKeyIftemporaryMerged;
    private String[] studyOrdering;
    private String[] sessionKeyImageSOPInstanceUIDs;
    private Collection<Session4DInfo> fourDInfos = Collections.emptyList();
    private IStudyContainer studyContainer;
    private boolean baseStudyComplete;
    private List<SessionSnapshotInformation> sessionSnapshotInformation;
    private List<IHangingSessionExtension> extensions;

    public SessionKeyObject(KeyObjectSelectionDocumentInformationObject keyObjectSelectionDocumentInformationObject, byte[] byArray, String string, IStudyContainer iStudyContainer) {
        super(keyObjectSelectionDocumentInformationObject, CodeDictionary.KeyObjectSelectionDocumentTitle.JVisionSession);
        this.setContentDateTime(new Date());
        this.sessionData = byArray;
        this.patientKeyIftemporaryMerged = string;
        this.studyContainer = iStudyContainer;
    }

    public SessionKeyObject(KeyObjectSelectionDocumentInformationObject keyObjectSelectionDocumentInformationObject, byte[] byArray, Attributes attributes) {
        this(keyObjectSelectionDocumentInformationObject, byArray, attributes.getString("TIANI", 2687059), null);
        this.baseStudyComplete = Boolean.parseBoolean(attributes.getNestedDataset(4236149).getString("TIANI", 2687065, VR.SH, "false"));
    }

    @Override
    public Attributes toDataset(IKeyObjectData iKeyObjectData) {
        SessionSnapshotInformation sessionSnapshotInformation2;
        Attributes attributes = super.toDataset(iKeyObjectData);
        attributes.setBytes("TIANI", 2687058, VR.OB, this.sessionData);
        if (this.patientKeyIftemporaryMerged != null) {
            attributes.setString("TIANI", 2687059, VR.LO, this.patientKeyIftemporaryMerged);
        }
        attributes.setString("TIANI", 2687060, VR.UI, this.studyOrdering);
        attributes.setString("TIANI", 2687074, VR.UI, this.sessionKeyImageSOPInstanceUIDs);
        Sequence sequence = attributes.ensureSequence("TIANI", 2687061, this.sessionSnapshotInformation.size());
        for (SessionSnapshotInformation sessionSnapshotInformation2 : this.sessionSnapshotInformation) {
            sequence.add(sessionSnapshotInformation2.toDataset());
        }
        if (!this.fourDInfos.isEmpty()) {
            sessionSnapshotInformation2 = attributes.ensureSequence("TIANI", 2687063, this.fourDInfos.size());
            for (Session4DInfo session4DInfo : this.fourDInfos) {
                sessionSnapshotInformation2.add(session4DInfo.toDataset());
            }
        }
        if ((sessionSnapshotInformation2 = attributes.getSequence(4236149)) != null) {
            Iterator<Object> iterator = sessionSnapshotInformation2.iterator();
            while (iterator.hasNext()) {
                Attributes attributes2 = (Attributes)iterator.next();
                String string = attributes2.getString(0x20000D);
                IStudyData iStudyData = this.studyContainer.getPatientRepresentation().getPatientData().getStudy(string);
                attributes2.setString("TIANI", 2687065, VR.SH, Boolean.toString(iStudyData.isStudyComplete()));
            }
        }
        if (this.extensions != null) {
            for (IHangingSessionExtension iHangingSessionExtension : this.extensions) {
                iHangingSessionExtension.writeTo(attributes);
            }
        }
        return attributes;
    }

    public byte[] getSessionData() {
        return this.sessionData;
    }

    public void setSessionData(byte[] byArray) {
        this.sessionData = byArray;
    }

    public void setSessionData(Attributes attributes) {
        try {
            this.sessionData = attributes.getBytes("TIANI", 2687058);
        }
        catch (IOException iOException) {
            ALogger.getLogger(SessionKeyObject.class).error("Bulk error data", (Throwable)iOException);
        }
    }

    void set4DInformation(Collection<Session4DInfo> collection) {
        this.fourDInfos = collection;
    }

    void setPatientKeyIfTemporaryMerged(String string) {
        if (string != null) {
            this.patientKeyIftemporaryMerged = string;
        }
    }

    boolean shouldLoadCompleteBaseStudy() {
        if (this.studyContainer != null) {
            return this.studyContainer.getBaseStudy().isStudyComplete();
        }
        return this.baseStudyComplete;
    }

    public void clearReferences() {
        this.referencedComposites = new ArrayList();
        this.referencedImages = new ArrayList();
        this.referencedWaveforms = new ArrayList();
        this.references = new ArrayList();
        this.kosdio.getKeyObjectDocument().currentRequestedProcedureEvidences().clear();
    }

    String[] getStudyOrdering() {
        if (this.studyOrdering == null) {
            return null;
        }
        return Arrays.copyOf(this.studyOrdering, this.studyOrdering.length);
    }

    public void setStudyContainer(IStudyContainer iStudyContainer) {
        this.studyContainer = iStudyContainer;
    }

    public void setStudyOrdering(String[] stringArray) {
        this.studyOrdering = stringArray;
    }

    String[] getSessionKeyImageSOPInstanceUIDs() {
        if (this.sessionKeyImageSOPInstanceUIDs == null) {
            return null;
        }
        return Arrays.copyOf(this.sessionKeyImageSOPInstanceUIDs, this.sessionKeyImageSOPInstanceUIDs.length);
    }

    void setSessionKeyObjectSOPInstanceUIDs(String[] stringArray) {
        this.sessionKeyImageSOPInstanceUIDs = stringArray;
    }

    public SessionSnapshotInformation getAdditionalSnapshotInformation(int n) {
        if (this.sessionSnapshotInformation == null) {
            return null;
        }
        return this.sessionSnapshotInformation.get(n);
    }

    public void setAdditionalSnapshotInformation(List<SessionSnapshotInformation> list) {
        this.sessionSnapshotInformation = list;
    }

    List<IHangingSessionExtension> getExtensions() {
        if (this.extensions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.extensions);
    }

    void setExtensions(List<IHangingSessionExtension> list) {
        this.extensions = list;
    }
}

