/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions;

import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.runtime.DisplayLayoutRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.LayoutRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.ScreenLayoutRuntime;
import com.agfa.pacs.impaxee.sessions.SessionDisplay;
import com.agfa.pacs.impaxee.sessions.SessionSnapshotInformation;
import com.tiani.jvision.main.MainFrame2;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.jvision.vis.layout.IStateLytScreen;
import com.tiani.jvision.vis.layout.StateLytScreen;
import java.awt.Dimension;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class SessionLyt {
    private MainLayoutType lyt;
    private int lytCols;
    private int lytRows;
    private int nVisScreens;
    private int nVisDisplays;
    private List<IStateLytScreen> screenLayouts = new Vector<IStateLytScreen>();
    private List<Dimension> displayDim = new Vector<Dimension>();

    public SessionLyt() {
    }

    public SessionLyt(DataInputStream dataInputStream, SessionSnapshotInformation sessionSnapshotInformation) throws IOException {
        this();
        this.read(dataInputStream, sessionSnapshotInformation);
    }

    public SessionLyt(MainFrame2 mainFrame2) {
        this();
        this.capture(mainFrame2);
    }

    public LayoutRuntime convert(List<SessionDisplay> list) {
        LayoutRuntime layoutRuntime = new LayoutRuntime(null);
        int n = 0;
        layoutRuntime.setType(this.lyt);
        for (IStateLytScreen iStateLytScreen : this.screenLayouts) {
            ScreenLayoutRuntime screenLayoutRuntime = new ScreenLayoutRuntime(null);
            screenLayoutRuntime.setHorizontalXVertical(StateLytScreen.getType(iStateLytScreen));
            int n2 = StateLytScreen.getRequiredDisplayCount(iStateLytScreen);
            int n3 = 0;
            while (n3 < n2) {
                DisplayLayoutRuntime displayLayoutRuntime = new DisplayLayoutRuntime(null);
                int n4 = n + n3;
                Dimension dimension = this.displayDim.get(n4);
                displayLayoutRuntime.setHorizontalXVertical(String.valueOf(dimension.width) + "x" + dimension.height);
                SessionDisplay sessionDisplay = list.get(n4);
                String string = sessionDisplay.getPluginName();
                displayLayoutRuntime.setPluginName(string);
                displayLayoutRuntime.getDisplayState().setNavigationPosition4D(sessionDisplay.getSecondaryIndex() + 1);
                screenLayoutRuntime.addDisplayLayout(displayLayoutRuntime);
                ++n3;
            }
            n += n2;
            layoutRuntime.addScreenLayoutRuntime(screenLayoutRuntime);
        }
        return layoutRuntime;
    }

    private void capture(MainFrame2 mainFrame2) {
        this.lyt = mainFrame2.getLytMode();
        this.lytCols = mainFrame2.getLyt().getCols();
        this.lytRows = mainFrame2.getLyt().getRows();
        List<VisScreen2> list = mainFrame2.getScreens();
        this.nVisScreens = list.size();
        this.screenLayouts.clear();
        for (VisScreen2 object2 : list) {
            this.screenLayouts.add(new StateLytScreen(object2.getLyt()));
        }
        List<VisDisplay2> list2 = mainFrame2.getDisplays();
        this.nVisDisplays = list2.size();
        this.displayDim.clear();
        for (Object visDisplay2 : list2) {
            this.displayDim.add(((VisDisplay2)visDisplay2).getLyt().getDim());
        }
    }

    String[] getSpecialScreenLayouts() {
        String[] stringArray = new String[this.nVisScreens];
        int n = 0;
        while (n < this.nVisScreens) {
            IStateLytScreen iStateLytScreen = this.screenLayouts.get(n);
            stringArray[n] = iStateLytScreen.getMergedCells() != null ? StateLytScreen.getType(iStateLytScreen) : "";
            ++n;
        }
        return stringArray;
    }

    void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.lyt.getIntID());
        dataOutput.writeInt(this.lytCols);
        dataOutput.writeInt(this.lytRows);
        dataOutput.writeInt(this.nVisScreens);
        dataOutput.writeInt(this.nVisDisplays);
        int n = 0;
        while (n < this.nVisScreens) {
            int n2;
            int n3;
            IStateLytScreen iStateLytScreen = this.screenLayouts.get(n);
            if (iStateLytScreen.getMergedCells() == null) {
                n3 = iStateLytScreen.getCols();
                n2 = iStateLytScreen.getRows();
            } else {
                n3 = StateLytScreen.getRequiredDisplayCount(iStateLytScreen);
                n2 = 1;
                while (n3 % 2 == 0 && n2 < n3) {
                    n3 /= 2;
                    n2 *= 2;
                }
            }
            dataOutput.writeInt(n3);
            dataOutput.writeInt(n2);
            ++n;
        }
        n = 0;
        while (n < this.nVisDisplays) {
            dataOutput.writeInt(this.displayDim.get((int)n).width);
            dataOutput.writeInt(this.displayDim.get((int)n).height);
            ++n;
        }
    }

    private void read(DataInputStream dataInputStream, SessionSnapshotInformation sessionSnapshotInformation) throws IOException {
        int n;
        int n2;
        this.lyt = MainLayoutType.getMainLayoutTypeForMode(dataInputStream.readInt());
        this.lytCols = dataInputStream.readInt();
        this.lytRows = dataInputStream.readInt();
        this.nVisScreens = dataInputStream.readInt();
        this.nVisDisplays = dataInputStream.readInt();
        this.screenLayouts.clear();
        this.displayDim.clear();
        int n3 = 0;
        while (n3 < this.nVisScreens) {
            String string;
            n2 = dataInputStream.readInt();
            n = dataInputStream.readInt();
            IStateLytScreen iStateLytScreen = null;
            if (sessionSnapshotInformation != null && (string = sessionSnapshotInformation.getSpecialScreenLayout(n3)) != null) {
                iStateLytScreen = StateLytScreen.parse(this.lyt, string, null);
            }
            if (iStateLytScreen == null) {
                iStateLytScreen = new StateLytScreen(n2, n);
            }
            this.screenLayouts.add(iStateLytScreen);
            ++n3;
        }
        n3 = 0;
        while (n3 < this.nVisDisplays) {
            n2 = dataInputStream.readInt();
            n = dataInputStream.readInt();
            this.displayDim.add(new Dimension(n2, n));
            ++n3;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof SessionLyt)) {
            return false;
        }
        SessionLyt sessionLyt = (SessionLyt)object;
        if (this.lyt != sessionLyt.lyt) {
            return false;
        }
        if (this.lytCols != sessionLyt.lytCols) {
            return false;
        }
        if (this.lytRows != sessionLyt.lytRows) {
            return false;
        }
        if (this.nVisScreens != sessionLyt.nVisScreens) {
            return false;
        }
        if (this.nVisDisplays != sessionLyt.nVisDisplays) {
            return false;
        }
        if (!this.screenLayouts.equals(sessionLyt.screenLayouts)) {
            return false;
        }
        return this.displayDim.equals(sessionLyt.displayDim);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }
}

