/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions;

import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.tiani.base.data.IObjectData;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.dcm4che3.util.UIDUtils;

public class SessionObject {
    private String sessionObjUID;
    private String seriesUID;
    private String instanceUID;
    private String studyUID;
    private String classUID;

    private SessionObject() {
    }

    public SessionObject(IObjectData iObjectData) {
        this();
        this.initFrom(iObjectData);
    }

    public SessionObject(DataInputStream dataInputStream) throws IOException {
        this();
        this.read(dataInputStream);
    }

    SessionObject(ILoadableInfo iLoadableInfo) {
        this();
        this.sessionObjUID = UIDUtils.createUID();
        this.seriesUID = iLoadableInfo.getSeriesUID();
        this.instanceUID = iLoadableInfo.getSOPInstanceUID();
        this.studyUID = iLoadableInfo.getStudyUID();
        this.classUID = iLoadableInfo.getSOPClassUID();
    }

    public void initFrom(IObjectData iObjectData) {
        this.sessionObjUID = UIDUtils.createUID();
        this.seriesUID = iObjectData.getParent().getSeriesInstanceUID();
        this.instanceUID = iObjectData.getSOPInstanceUID();
        this.studyUID = iObjectData.getParent().getParent().getStudyInstanceUID();
        this.classUID = iObjectData.getSOPClassUID();
    }

    void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.getSessionObjUID());
        dataOutput.writeUTF(this.getSeriesUID());
        dataOutput.writeUTF(this.getInstanceUID());
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.sessionObjUID = dataInputStream.readUTF();
        this.seriesUID = dataInputStream.readUTF();
        this.instanceUID = dataInputStream.readUTF();
        this.studyUID = null;
    }

    public String getStudyUID() {
        return this.studyUID;
    }

    public String getClassUID() {
        return this.classUID;
    }

    public String getInstanceUID() {
        return this.instanceUID;
    }

    public String getSessionObjUID() {
        return this.sessionObjUID;
    }

    public String getSeriesUID() {
        return this.seriesUID;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SessionObject)) {
            return false;
        }
        SessionObject sessionObject = (SessionObject)object;
        if (!this.seriesUID.equals(sessionObject.seriesUID)) {
            return false;
        }
        return this.instanceUID.equals(sessionObject.instanceUID);
    }

    public int hashCode() {
        return this.seriesUID.hashCode() ^ this.instanceUID.hashCode();
    }

    public SessionObject cloneForSave() {
        SessionObject sessionObject = new SessionObject();
        sessionObject.sessionObjUID = this.sessionObjUID;
        sessionObject.seriesUID = this.seriesUID;
        sessionObject.instanceUID = this.instanceUID;
        sessionObject.classUID = this.classUID;
        sessionObject.studyUID = this.studyUID;
        return sessionObject;
    }
}

