/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHangingSession;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.runtime.LayoutRuntime;
import com.agfa.pacs.impaxee.hanging.snapshot.AbstractSnapshotRuntime;
import com.agfa.pacs.impaxee.sessions.ISessionDisplaySet;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.impaxee.sessions.SessionDisplay;
import com.agfa.pacs.impaxee.sessions.SessionDisplaySetFactory;
import com.agfa.pacs.impaxee.sessions.SessionLyt;
import com.agfa.pacs.impaxee.sessions.SessionSnapshotInformation;
import com.agfa.pacs.impaxee.setlive.ISetLivePlugin;
import com.agfa.pacs.impaxee.setlive.SetLiveSecondaryCaptures;
import com.agfa.pacs.impaxee.setlive.SetLiveUtil;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeType;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IPatientData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.MainFrame2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.util.message.Message;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dcm4che3.util.UIDUtils;

public class SessionSnapshotRuntime
extends AbstractSnapshotRuntime {
    private String snapshotUID = UIDUtils.createUID();
    private List<String> patNames = new ArrayList<String>();
    private String selectedPatName = "";
    private String selectedPatID = "";
    private SessionLyt layout;
    private List<SessionDisplay> disps = new ArrayList<SessionDisplay>();
    private final IHangingSession parent;
    private final SetLiveSecondaryCaptures setLiveData;

    public SessionSnapshotRuntime(String string, IHangingSession iHangingSession) {
        super(string);
        this.parent = iHangingSession;
        this.setLiveData = new SetLiveSecondaryCaptures();
    }

    public IHangingSession getParent() {
        return this.parent;
    }

    void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.snapshotUID);
        dataOutput.writeUTF(this.getName());
        dataOutput.writeInt(this.patNames.size());
        for (String string : this.patNames) {
            dataOutput.writeUTF(string);
        }
        dataOutput.writeUTF(String.valueOf(this.selectedPatName) + "|" + this.selectedPatID);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SessionDisplay sessionDisplay : this.disps) {
            ISessionDisplaySet iSessionDisplaySet = sessionDisplay.getSessionDisplaySet();
            if (iSessionDisplaySet == null) continue;
            arrayList.add(iSessionDisplaySet.getSessionSeqUID());
        }
        dataOutput.writeInt(arrayList.size());
        for (String string : arrayList) {
            dataOutput.writeUTF(string);
        }
        dataOutput.writeInt(this.disps.size());
        for (SessionDisplay sessionDisplay : this.disps) {
            sessionDisplay.write(dataOutput);
        }
        this.layout.write(dataOutput);
    }

    void read(DataInputStream dataInputStream, SessionSnapshotInformation sessionSnapshotInformation, ISessionDisplaySet[] iSessionDisplaySetArray, int n) throws IOException {
        this.snapshotUID = dataInputStream.readUTF();
        String string = dataInputStream.readUTF();
        if (StringUtils.isBlank((CharSequence)string)) {
            string = Integer.toString(n + 1);
        }
        this.setName(string);
        int n2 = dataInputStream.readInt();
        int n3 = 0;
        while (n3 < n2) {
            this.patNames.add(dataInputStream.readUTF());
            ++n3;
        }
        this.selectedPatName = dataInputStream.readUTF();
        n3 = dataInputStream.readInt();
        int n4 = 0;
        while (n4 < n3) {
            dataInputStream.readUTF();
            ++n4;
        }
        n4 = dataInputStream.readInt();
        this.disps.clear();
        int n5 = 0;
        while (n5 < n4) {
            this.disps.add(new SessionDisplay(dataInputStream, iSessionDisplaySetArray, this, SessionSnapshotRuntime.getSecondaryIndex(sessionSnapshotInformation, n5)));
            ++n5;
        }
        this.layout = new SessionLyt(dataInputStream, sessionSnapshotInformation);
    }

    private static Integer getSecondaryIndex(SessionSnapshotInformation sessionSnapshotInformation, int n) {
        if (sessionSnapshotInformation == null) {
            return null;
        }
        return sessionSnapshotInformation.getSecondaryIndex(n);
    }

    public List<SessionDisplay> displays() {
        return this.disps;
    }

    @Override
    public LayoutRuntime getLayout() {
        return this.layout.convert(this.disps);
    }

    void capture() {
        DataSelectionManager dataSelectionManager = DataSelectionManager.getInstance();
        IPatientRepresentation iPatientRepresentation = dataSelectionManager.getCurrentPatient();
        this.selectedPatName = iPatientRepresentation.getPatientData().getDicomObject().getString(0x100010);
        this.selectedPatID = iPatientRepresentation.getPatientData().getDicomObject().getString(0x100020);
        List<IPatientData> list = this.captureDisplays();
        this.layout = new SessionLyt(JVision2.getMainFrame());
        this.patNames.clear();
        for (IPatientData iPatientData : list) {
            String string = String.valueOf(iPatientData.getDicomObject().getString(0x100010)) + "|" + iPatientData.getDicomObject().getString(0x100020);
            if (this.patNames.contains(string)) continue;
            this.patNames.add(string);
        }
    }

    private List<IPatientData> captureDisplays() {
        MainFrame2 mainFrame2 = JVision2.getMainFrame();
        Session session = (Session)this.parent;
        ArrayList<IPatientData> arrayList = new ArrayList<IPatientData>();
        this.disps.clear();
        for (VisDisplay2 object : mainFrame2.getDisplays()) {
            if (object.hasData()) {
                IDisplaySet iDisplaySet = null;
                if (this.parent.isSetLiveEnabled() && object.getData().getDisplayPlugin() instanceof ISetLivePlugin) {
                    iDisplaySet = SetLiveUtil.createSecondaryCapture(object.getData(), (ISetLivePlugin)((Object)object.getData().getDisplayPlugin()));
                }
                if (iDisplaySet == null) {
                    iDisplaySet = object.getData().getDisplaySet();
                } else {
                    this.setLiveData.addDisplaySet(iDisplaySet);
                    if (session.findDisplaySet(iDisplaySet) == null) {
                        this.parent.getSplitAndSortRuntime().addDisplaySet(iDisplaySet, SplitAndSortChangeType.DATA_LOAD);
                    }
                }
                IPatientData iPatientData = object.getData().getPatientRepresentation().getPatientData();
                arrayList.add(iPatientData);
                ISessionDisplaySet iSessionDisplaySet = session.findDisplaySet(iDisplaySet);
                if (iSessionDisplaySet == null) {
                    iSessionDisplaySet = SessionDisplaySetFactory.capture(iDisplaySet, this.parent.getSplitAndSortRuntime());
                    session.getSplitAndSortRuntime().addDisplaySet(iSessionDisplaySet, SplitAndSortChangeType.DATA_LOAD);
                }
                this.disps.add(new SessionDisplay(object, iSessionDisplaySet, this));
                continue;
            }
            this.disps.add(new SessionDisplay(this));
        }
        if (this.isMissingPresentationStates()) {
            String string = Messages.getString("SessionSnapshotRuntime.PresentationStateFailure.Title");
            String string2 = Messages.getString("SessionSnapshotRuntime.PresentationStateFailure.Message");
            Message.warning(string, string2);
        }
        return arrayList;
    }

    private boolean isMissingPresentationStates() {
        for (SessionDisplay sessionDisplay : this.disps) {
            if (!sessionDisplay.isMissingPresentationStates()) continue;
            return true;
        }
        return false;
    }

    void collectUnsavedSetLiveData(Collection<IObjectData> collection) {
        this.setLiveData.collectUnsavedData(collection);
    }

    SessionSnapshotInformation getAdditionalInformation() {
        return new SessionSnapshotInformation(this.layout.getSpecialScreenLayouts(), this.disps.stream().mapToInt(SessionDisplay::getSecondaryIndex).toArray());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SessionSnapshotRuntime)) {
            return false;
        }
        SessionSnapshotRuntime sessionSnapshotRuntime = (SessionSnapshotRuntime)object;
        if (!this.selectedPatName.equals(sessionSnapshotRuntime.selectedPatName)) {
            return false;
        }
        if (this.patNames.size() != sessionSnapshotRuntime.patNames.size()) {
            return false;
        }
        if (this.disps.size() != sessionSnapshotRuntime.disps.size()) {
            return false;
        }
        int n = 0;
        while (n < this.patNames.size()) {
            if (!this.patNames.get(n).equals(sessionSnapshotRuntime.patNames.get(n))) {
                return false;
            }
            ++n;
        }
        if (!this.layout.equals(sessionSnapshotRuntime.layout)) {
            return false;
        }
        n = 0;
        while (n < this.disps.size()) {
            if (!this.disps.get(n).equals(sessionSnapshotRuntime.disps.get(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public SessionSnapshotRuntime cloneForSave() {
        SessionSnapshotRuntime sessionSnapshotRuntime = new SessionSnapshotRuntime(this.getName(), this.getParent());
        sessionSnapshotRuntime.snapshotUID = this.snapshotUID;
        sessionSnapshotRuntime.layout = this.layout;
        sessionSnapshotRuntime.selectedPatName = this.selectedPatName;
        sessionSnapshotRuntime.patNames.addAll(this.patNames);
        sessionSnapshotRuntime.setActionID(this.getActionID());
        sessionSnapshotRuntime.disps.clear();
        for (SessionDisplay sessionDisplay : this.disps) {
            sessionSnapshotRuntime.disps.add(sessionDisplay.cloneForSave());
        }
        return sessionSnapshotRuntime;
    }

    public SessionSnapshotRuntime clone() {
        return this.cloneForSave();
    }
}

