/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions;

import com.agfa.pacs.data.shared.primitives.IntHashMap;
import com.agfa.pacs.data.shared.primitives.IntHashSet;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.sessions.ISessionDisplaySet;
import com.agfa.pacs.impaxee.sessions.Session4DInfo;
import com.agfa.pacs.impaxee.sessions.SessionDisplaySetFactory;
import com.agfa.pacs.impaxee.splitsort.CrossStudyDisplaySetComparator;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeSet;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeType;
import com.agfa.pacs.impaxee.splitsort.model.xml.SplitAndSort;
import com.agfa.pacs.impaxee.splitsort.runtime.AbstractSplitAndSortRuntime;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class SessionSplitAndSortRuntime
extends AbstractSplitAndSortRuntime {
    private final List<ISessionDisplaySet> displaySets;
    private final Set<IStudyData> usedStudies = new LinkedHashSet<IStudyData>();

    SessionSplitAndSortRuntime(IPatientRepresentation iPatientRepresentation) {
        super(iPatientRepresentation);
        this.displaySets = new ArrayList<ISessionDisplaySet>();
    }

    @Override
    public void addDisplaySet(IDisplaySet iDisplaySet, SplitAndSortChangeType splitAndSortChangeType) {
        if (splitAndSortChangeType == SplitAndSortChangeType.DATA_LOAD) {
            this.addDisplaySetImpl(this.convertToSessionDisplaySet(iDisplaySet));
        }
    }

    Iterable<IStudyData> getStudies() {
        return this.usedStudies;
    }

    boolean hasStudies(String string) {
        for (IStudyData iStudyData : this.usedStudies) {
            if (!iStudyData.getKey().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void addDisplaySetImpl(ISessionDisplaySet iSessionDisplaySet) {
        if (iSessionDisplaySet.getOneObject() != null) {
            this.usedStudies.add(iSessionDisplaySet.getOneObject().getParent().getParent());
        }
        this.displaySets.add(iSessionDisplaySet);
    }

    @Override
    public ISessionDisplaySet getDisplaySetAt(int n) {
        if (n >= 0 && n < this.displaySets.size()) {
            return this.displaySets.get(n);
        }
        return null;
    }

    @Override
    public ISessionDisplaySet getDisplaySetByID(int n) {
        for (ISessionDisplaySet iSessionDisplaySet : this.displaySets) {
            if (n != iSessionDisplaySet.getID()) continue;
            return iSessionDisplaySet;
        }
        return null;
    }

    @Override
    public IDisplaySet getKeyImageDisplaySet(IStudyData iStudyData) {
        return null;
    }

    @Override
    public int getDisplaySetPosition(IDisplaySet iDisplaySet) {
        return this.displaySets.indexOf(iDisplaySet);
    }

    @Override
    public int getDisplaySetCount() {
        return this.displaySets.size();
    }

    public ISessionDisplaySet[] getDisplaySets() {
        return this.displaySets.toArray(new ISessionDisplaySet[this.displaySets.size()]);
    }

    @Override
    public void splitAndSortSingleStudy(IStudyData iStudyData, SplitAndSort splitAndSort) {
    }

    @Override
    public SplitAndSortChangeSet addSeries(Collection<ISeriesData> collection) {
        return null;
    }

    boolean addDisplaySetsOfNewStudies(IDisplaySet[] iDisplaySetArray) {
        ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>();
        IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray;
        int n = iDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDisplaySet iDisplaySet = iDisplaySetArray2[n2];
            if (iDisplaySet.getOneObject() != null && !this.usedStudies.contains(iDisplaySet.getOneObject().getParent().getParent())) {
                arrayList.add(iDisplaySet);
            }
            ++n2;
        }
        return this.addDisplaySets(arrayList);
    }

    final boolean addDisplaySetsOfBaseStudy(String string, IDisplaySet[] iDisplaySetArray) {
        ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>();
        IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray;
        int n = iDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDisplaySet iDisplaySet = iDisplaySetArray2[n2];
            if (iDisplaySet.getOneObject() != null && string.equals(iDisplaySet.getStudyUID())) {
                arrayList.add(iDisplaySet);
            }
            ++n2;
        }
        return this.addDisplaySets(arrayList);
    }

    boolean addDisplaySets(List<IDisplaySet> list) {
        IntHashSet intHashSet = new IntHashSet(32);
        for (IDisplaySet object2 : this.displaySets) {
            intHashSet.add(object2.getID());
        }
        ArrayList arrayList = new ArrayList(list.size());
        boolean bl = false;
        for (IDisplaySet iDisplaySet : list) {
            List list2;
            int n;
            if (iDisplaySet.isEmpty() || intHashSet.contains(iDisplaySet.getID()) || (n = (list2 = this.streamRelatedDisplaySets(iDisplaySet).collect(Collectors.toList())).stream().mapToInt(IDisplaySet::getTotalFrameCount).sum()) >= iDisplaySet.getTotalFrameCount()) continue;
            arrayList.addAll(list2);
            this.addDisplaySetImpl(this.convertToSessionDisplaySet(iDisplaySet));
            bl = true;
        }
        if (!arrayList.isEmpty()) {
            this.displaySets.removeAll(arrayList);
        }
        if (bl) {
            Collections.sort(this.displaySets, new CrossStudyDisplaySetComparator());
        }
        return bl;
    }

    boolean removeDisplaySets(IDisplaySet ... iDisplaySetArray) {
        IntHashMap intHashMap = new IntHashMap(this.displaySets.size());
        for (ISessionDisplaySet iSessionDisplaySet : this.displaySets) {
            intHashMap.put(iSessionDisplaySet.getID(), (Object)iSessionDisplaySet);
        }
        boolean bl = false;
        IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray;
        int n = iDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDisplaySet iDisplaySet = iDisplaySetArray2[n2];
            ISessionDisplaySet iSessionDisplaySet = (ISessionDisplaySet)intHashMap.get(iDisplaySet.getID());
            if (iSessionDisplaySet != null) {
                bl |= this.displaySets.remove(iSessionDisplaySet);
            }
            ++n2;
        }
        return bl;
    }

    @Override
    public void removeDisplaySet(IDisplaySet iDisplaySet, SplitAndSortChangeType splitAndSortChangeType) {
        if (splitAndSortChangeType == SplitAndSortChangeType.INVALIDATION) {
            this.displaySets.remove(iDisplaySet);
        }
    }

    void readDisplaySet(DataInputStream dataInputStream, Map<String, Session4DInfo> map) throws IOException {
        ISessionDisplaySet iSessionDisplaySet = SessionDisplaySetFactory.read(dataInputStream, this, map);
        if (iSessionDisplaySet.isNotEmpty()) {
            this.addDisplaySetImpl(iSessionDisplaySet);
        }
    }

    void removeStudy(IStudyData iStudyData) {
        if (this.usedStudies.remove(iStudyData)) {
            ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>();
            Iterator<ISessionDisplaySet> iterator = this.displaySets.iterator();
            while (iterator.hasNext()) {
                IDisplaySet iDisplaySet = iterator.next();
                if (!iStudyData.equals(iDisplaySet.getStudy())) continue;
                arrayList.add(iDisplaySet);
                iterator.remove();
            }
            DataManager.getInstance().removeDisplaySet(arrayList.toArray(new IDisplaySet[arrayList.size()]), SplitAndSortChangeType.MANUAL_REMOVAL, true, false);
        }
    }

    @Override
    public List<String> getStudyOrdering() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        for (IDisplaySet iDisplaySet : this.displaySets) {
            if (string.equals(iDisplaySet.getStudyUID())) continue;
            string = iDisplaySet.getStudyUID();
            arrayList.add(string);
        }
        return arrayList;
    }

    private ISessionDisplaySet convertToSessionDisplaySet(IDisplaySet iDisplaySet) {
        ISessionDisplaySet iSessionDisplaySet = iDisplaySet instanceof ISessionDisplaySet ? (ISessionDisplaySet)iDisplaySet : SessionDisplaySetFactory.capture(iDisplaySet, this);
        return iSessionDisplaySet;
    }
}

