/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions;

import com.agfa.pacs.base.util.DicomUtils;
import com.agfa.pacs.data.shared.data.cache.DicomCacheFactory;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.impaxee.sessions.ISessionDisplaySet;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.impaxee.sessions.SessionKeyObject;
import com.agfa.pacs.impaxee.sessions.SessionObject;
import com.agfa.pacs.impaxee.sessions.SessionStorageData;
import com.agfa.pacs.listtext.dicomobject.iod.sr.KeyObjectSelectionDocumentInformationObject;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IKeyObjectData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.util.SaveData;
import java.io.DataOutputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.PersonName;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;

public class SessionStorage {
    private static final ALogger log = ALogger.getLogger(SessionStorage.class);

    public SaveData writeSession(Session session) throws Throwable {
        String string;
        String string2;
        String string3;
        if (session.getSessionKeyObject() != null) {
            return this.updateSession(session);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        SessionStorageData sessionStorageData = session.write(dataOutputStream);
        IStudyData iStudyData = sessionStorageData.createStudyData();
        ISeriesData iSeriesData = iStudyData.createSeriesData("KO");
        iSeriesData.getDicomObject().setInt(2101769, VR.IS, new int[]{1});
        Attributes attributes = iStudyData.getDicomObject();
        attributes.setString(528432, VR.LO, sessionStorageData.getVisibleName());
        attributes.setInt(2101766, VR.IS, new int[]{1});
        attributes.setInt(2101768, VR.IS, new int[]{1});
        IKeyObjectData iKeyObjectData = iSeriesData.createObjectData(IKeyObjectData.class, "1.2.840.10008.5.1.4.1.1.88.59", "1.2.840.10008.1.2.1");
        KeyObjectSelectionDocumentInformationObject keyObjectSelectionDocumentInformationObject = KeyObjectSelectionDocumentInformationObject.createInstance((Attributes)iKeyObjectData.getDicomObject());
        SessionKeyObject sessionKeyObject = sessionStorageData.createSessionKeyObject(keyObjectSelectionDocumentInformationObject, byteArrayOutputStream.toByteArray(), session.getStudyContainer());
        sessionKeyObject.setDescription(sessionStorageData.getVisibleName());
        sessionKeyObject.setStudyOrdering(sessionStorageData.getStudyOrdering());
        sessionKeyObject.setSessionKeyObjectSOPInstanceUIDs(sessionStorageData.getSessionKeyObjectSOPInstanceUIDs());
        sessionKeyObject.setAdditionalSnapshotInformation(sessionStorageData.getAdditionalSnapshotInformation());
        sessionKeyObject.set4DInformation(sessionStorageData.get4DInformation());
        sessionKeyObject.setExtensions(sessionStorageData.getExtensions());
        this.collectReferences(sessionStorageData, sessionKeyObject);
        IStudyData iStudyData2 = this.getStudyRef(sessionStorageData);
        Attributes attributes2 = iSeriesData.getDicomObject();
        PersonName personName = DicomUtils.getPersonNameFromFirstSeries((IDataInfo)iStudyData2.getQueryObject(), (int)524432);
        if (personName != null) {
            attributes2.setString(524432, VR.PN, personName.toString());
        }
        Sequence sequence = attributes2.newSequence(4194933, 1);
        Attributes attributes3 = new Attributes();
        sequence.add(attributes3);
        String string4 = DicomUtils.getStringFromFirstSeries((IDataInfo)iStudyData2.getQueryObject(), (int)3280947);
        if (string4 != null) {
            attributes3.setString(3280947, VR.LO, string4);
        }
        if ((string3 = DicomUtils.getStringFromFirstSeries((IDataInfo)iStudyData2.getQueryObject(), (int)3280946)) != null) {
            attributes3.setString(3280946, VR.PN, string3);
        }
        if ((string2 = DicomUtils.getStringFromFirstSeries((IDataInfo)iStudyData2.getQueryObject(), (int)524416)) != null) {
            attributes2.setString(524416, VR.LO, string2);
        }
        if ((string = DicomUtils.getStringFromFirstSeries((IDataInfo)iStudyData2.getQueryObject(), (int)528448)) != null) {
            attributes2.setString(528448, VR.LO, string);
        }
        iKeyObjectData.setDicomObject(sessionKeyObject.toDataset(iKeyObjectData));
        iKeyObjectData.getDicomObject().setString(131088, VR.UI, "1.2.840.10008.1.2.1");
        sessionStorageData.setSessionKeyObject(sessionKeyObject, iKeyObjectData);
        return new SaveData(iStudyData2, iKeyObjectData);
    }

    private SaveData updateSession(Session session) throws Throwable {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        SessionStorageData sessionStorageData = session.write(dataOutputStream);
        SessionKeyObject sessionKeyObject = sessionStorageData.getSessionKeyObject();
        IKeyObjectData iKeyObjectData = sessionStorageData.getKeyObjectData();
        sessionKeyObject.setStudyContainer(session.getStudyContainer());
        sessionKeyObject.setSessionData(byteArrayOutputStream.toByteArray());
        sessionKeyObject.setPatientKeyIfTemporaryMerged(sessionStorageData.getPatientKeyIfTemporaryMerged());
        sessionKeyObject.setStudyOrdering(sessionStorageData.getStudyOrdering());
        sessionKeyObject.setSessionKeyObjectSOPInstanceUIDs(sessionStorageData.getSessionKeyObjectSOPInstanceUIDs());
        sessionKeyObject.setAdditionalSnapshotInformation(sessionStorageData.getAdditionalSnapshotInformation());
        sessionKeyObject.set4DInformation(sessionStorageData.get4DInformation());
        sessionKeyObject.setExtensions(sessionStorageData.getExtensions());
        sessionKeyObject.clearReferences();
        this.collectReferences(sessionStorageData, sessionKeyObject);
        IStudyData iStudyData = this.getStudyRef(sessionStorageData);
        iKeyObjectData.setDicomObject(sessionKeyObject.toDataset(iKeyObjectData));
        DicomCacheFactory.getInstance().getDicomCache().removeDataset(iKeyObjectData.getDicomObject().getString(0x20000D), iKeyObjectData.getSOPInstanceUID());
        return new SaveData(iStudyData, iKeyObjectData);
    }

    private IStudyData getStudyRef(SessionStorageData sessionStorageData) {
        try {
            return DataSelectionManager.getInstance().getActiveHanging().getStudyContainer().getBaseStudy();
        }
        catch (Exception exception) {
            log.warn("Failed to determine base study", (Throwable)exception);
            return sessionStorageData.getSessionBaseStudy();
        }
    }

    private void collectReferences(SessionStorageData sessionStorageData, SessionKeyObject sessionKeyObject) {
        for (ISessionDisplaySet iSessionDisplaySet : sessionStorageData.getSessionDisplaySets()) {
            this.collectReferences(iSessionDisplaySet.getSessionObjects(), sessionKeyObject);
        }
        this.collectReferences(sessionStorageData.getAdditionalObjects(), sessionKeyObject);
    }

    private void collectReferences(Iterable<SessionObject> iterable, SessionKeyObject sessionKeyObject) {
        for (SessionObject sessionObject : iterable) {
            String string = sessionObject.getStudyUID();
            String string2 = sessionObject.getSeriesUID();
            String string3 = sessionObject.getInstanceUID();
            String string4 = sessionObject.getClassUID();
            sessionKeyObject.insertReference(string4, string3, string2, string, null);
        }
    }
}

