/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions;

import com.agfa.pacs.base.util.PatientMergeUtilities;
import com.agfa.pacs.impaxee.hanging.IHangingSessionExtension;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.sessions.ISessionDisplaySet;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.impaxee.sessions.Session4DInfo;
import com.agfa.pacs.impaxee.sessions.SessionKeyObject;
import com.agfa.pacs.impaxee.sessions.SessionObject;
import com.agfa.pacs.impaxee.sessions.SessionSnapshotInformation;
import com.agfa.pacs.listtext.dicomobject.iod.sr.KeyObjectSelectionDocumentInformationObject;
import com.tiani.base.data.IKeyObjectData;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.IStudyData;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class SessionStorageData {
    private final Session session;
    private final String[] filteredStudyOrdering;
    private final List<ISessionDisplaySet> filteredDisplaySets;
    private final List<SessionObject> filteredAdditionalObjects;
    private final Collection<Session4DInfo> fourDInfos;

    SessionStorageData(Session session, String[] stringArray, List<ISessionDisplaySet> list, List<SessionObject> list2, Collection<Session4DInfo> collection) {
        this.session = session;
        this.filteredStudyOrdering = stringArray;
        this.filteredDisplaySets = Collections.unmodifiableList(list);
        this.filteredAdditionalObjects = Collections.unmodifiableList(list2);
        this.fourDInfos = collection;
    }

    IStudyData createStudyData() {
        return this.session.getPatient().getPatientData().createStudyData();
    }

    String getVisibleName() {
        return this.session.getVisibleName();
    }

    IStudyData getSessionBaseStudy() {
        return this.session.getSessionBaseStudy();
    }

    String[] getStudyOrdering() {
        if (this.filteredStudyOrdering == null) {
            return null;
        }
        return Arrays.copyOf(this.filteredStudyOrdering, this.filteredStudyOrdering.length);
    }

    String[] getSessionKeyObjectSOPInstanceUIDs() {
        return this.session.getSessionKeyObjectSOPInstanceUIDs();
    }

    List<SessionSnapshotInformation> getAdditionalSnapshotInformation() {
        return this.session.getAdditionalSnapshotInformation();
    }

    List<IHangingSessionExtension> getExtensions() {
        return this.session.getExtensions();
    }

    Iterable<ISessionDisplaySet> getSessionDisplaySets() {
        return this.filteredDisplaySets;
    }

    Iterable<SessionObject> getAdditionalObjects() {
        return this.filteredAdditionalObjects;
    }

    Collection<Session4DInfo> get4DInformation() {
        return this.fourDInfos;
    }

    String getPatientKeyIfTemporaryMerged() {
        IPatientData iPatientData = this.session.getPatient().getPatientData();
        if (PatientMergeUtilities.getPatientMergeStatus((Attributes)iPatientData.getQueryObject().getAttributes()) == PatientMergeUtilities.PatientMergeStatus.NotMerged) {
            return null;
        }
        return iPatientData.getKey();
    }

    SessionKeyObject createSessionKeyObject(KeyObjectSelectionDocumentInformationObject keyObjectSelectionDocumentInformationObject, byte[] byArray, IStudyContainer iStudyContainer) {
        String string = this.getPatientKeyIfTemporaryMerged();
        return new SessionKeyObject(keyObjectSelectionDocumentInformationObject, byArray, string, iStudyContainer);
    }

    void setSessionKeyObject(SessionKeyObject sessionKeyObject, IKeyObjectData iKeyObjectData) {
        this.session.setSessionKeyObject(sessionKeyObject, iKeyObjectData);
    }

    SessionKeyObject getSessionKeyObject() {
        return this.session.getSessionKeyObject();
    }

    IKeyObjectData getKeyObjectData() {
        return this.session.getKeyObjectData();
    }
}

