/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions.gui;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.data.shared.worklist.IWorklistContext;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IHangingSession;
import com.agfa.pacs.impaxee.save.ISaveManager;
import com.agfa.pacs.listtext.swingx.controls.MessageDialog;
import com.agfa.pacs.listtext.swingx.impl.WorklistChooserPanel;
import com.tiani.gui.dialog.GUIMessageHandler;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.TableRowSorter;
import org.apache.commons.collections4.CollectionUtils;

public class ImageAreaWorklistChooserPanel
extends WorklistChooserPanel {
    private static final Map<IHangingSession, Collection<IWorklistContext>> unsavedHangingsMap = new HashMap<IHangingSession, Collection<IWorklistContext>>();
    private static final String SCHEDULED = "SCHEDULED";
    private static Map<Integer, Date> lastUsedWorklists;
    private ISaveManager saveManager;
    private IHangingSession hangingSession;
    private boolean rememberLastUsedWorklists;
    private ClearSelectionAction clearSelectionAction;

    public ImageAreaWorklistChooserPanel(List<IWorklistContext> list, IHangingSession iHangingSession) {
        this(list, iHangingSession, false);
    }

    public ImageAreaWorklistChooserPanel(List<IWorklistContext> list, IHangingSession iHangingSession, boolean bl) {
        super((IComponentFactory)ComponentFactory.instance, list);
        JPanel jPanel = ComponentFactory.instance.createPanel(new FlowLayout(0));
        this.clearSelectionAction = new ClearSelectionAction();
        jPanel.add(ComponentFactory.instance.createButton(this.clearSelectionAction));
        this.add(jPanel, "South");
        this.hangingSession = iHangingSession;
        this.clearSelectionAction.setEnabled(false);
        if (bl) {
            this.rememberLastUsedWorklists = true;
            if (lastUsedWorklists != null) {
                HashMap<IWorklistContext, Date> hashMap = new HashMap<IWorklistContext, Date>(lastUsedWorklists.size());
                for (IWorklistContext iWorklistContext : list) {
                    if (!lastUsedWorklists.containsKey(iWorklistContext.getId())) continue;
                    Date date = lastUsedWorklists.get(iWorklistContext.getId());
                    if (date != null) {
                        if (!iWorklistContext.isSchedulableOn(date)) continue;
                        hashMap.put(iWorklistContext, date);
                        continue;
                    }
                    hashMap.put(iWorklistContext, null);
                }
                if (!hashMap.isEmpty()) {
                    this.setSelectedWorklistContexts(hashMap);
                }
            }
        }
    }

    public static Map<IHangingSession, Collection<IWorklistContext>> getUnsavedHangings() {
        return Collections.unmodifiableMap(unsavedHangingsMap);
    }

    public boolean checkSavingIntoWorklists(Collection<IWorklistContext> collection) {
        if (collection != null && !collection.isEmpty() && Config.impaxee.jvision.DIALOGS.StoreSessionIntoWorklist.get()) {
            IWorklistContext iWorklistContext2;
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(Messages.getString("SaveSessionIntoWorklistDlg.Msg.Prefix"));
            stringWriter.append("\n\n");
            for (IWorklistContext iWorklistContext2 : collection) {
                stringWriter.append(iWorklistContext2.getTitle());
                if (SCHEDULED.equals(iWorklistContext2.getType())) {
                    stringWriter.append(' ');
                    stringWriter.append('(');
                    stringWriter.append(DateFormat.getDateInstance(2).format(iWorklistContext2.getScheduledDate()));
                    stringWriter.append(')');
                }
                stringWriter.append('\n');
            }
            stringWriter.append('\n');
            stringWriter.append(Messages.getString("SaveSessionIntoWorklistDlg.Msg.Suffix"));
            iWorklistContext2 = MessageDialog.createMessageDialog((Component)GUIMessageHandler.getParentWindow(), (String)Messages.getString("SaveSessionIntoWorklistDlg.Title"), (Object)stringWriter.toString(), (boolean)true, (int)0, (String)"YES_NO_OPTION", (boolean)false, (IComponentFactory)ComponentFactory.instance);
            GUIMessageHandler.centerSizedWindow((Window)iWorklistContext2);
            iWorklistContext2.setVisible(true);
            if ("NO_OPTION" == iWorklistContext2.getSelectedOption()) {
                return false;
            }
        }
        return true;
    }

    public boolean saveReplacementDataAndSession() {
        return this.save(IHangingSession::saveReplacementDataAndSession, false);
    }

    public boolean saveSessionOnly(boolean bl) {
        return this.save(IHangingSession::saveSessionOnly, bl);
    }

    private boolean save(SessionSaver sessionSaver, boolean bl) {
        boolean bl2;
        assert (this.hangingSession != null) : "hangingSession has to be supplied";
        Collection<Object> collection = Collections.emptyList();
        if (!bl) {
            collection = this.getUpdatedWorklistContexts();
            if (this.rememberLastUsedWorklists) {
                if (lastUsedWorklists != null) {
                    lastUsedWorklists.clear();
                }
                if (collection != null) {
                    if (lastUsedWorklists == null) {
                        lastUsedWorklists = new HashMap<Integer, Date>(2);
                    }
                    for (IWorklistContext iWorklistContext : collection) {
                        lastUsedWorklists.put(iWorklistContext.getId(), iWorklistContext.getScheduledDate());
                    }
                }
            }
        }
        if (CollectionUtils.isEmpty(collection)) {
            collection = unsavedHangingsMap.get(this.hangingSession);
        }
        if (bl2 = sessionSaver.save(this.hangingSession, collection)) {
            unsavedHangingsMap.remove(this.hangingSession);
        }
        return bl2;
    }

    public Collection<IWorklistContext> getUpdatedWorklistContexts() {
        Map map = this.getSelectedWorklistContexts();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                IWorklistContext iWorklistContext = (IWorklistContext)entry.getKey();
                if (!iWorklistContext.isScheduled() || entry.getValue() == null) continue;
                iWorklistContext.setScheduledDate((Date)entry.getValue());
            }
            return map.keySet();
        }
        return null;
    }

    public void saveUnsavedHangings() {
        Collection<IWorklistContext> collection = this.getUpdatedWorklistContexts();
        if (collection != null) {
            unsavedHangingsMap.put(this.hangingSession, collection);
        }
    }

    public void setSaveManager(ISaveManager iSaveManager) {
        this.saveManager = iSaveManager;
    }

    protected JTable createTable(IComponentFactory iComponentFactory) {
        final JTable jTable = super.createTable(iComponentFactory);
        jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ImageAreaWorklistChooserPanel.this.clearSelectionAction.setEnabled(jTable.getSelectedRows().length > 0);
                if (ImageAreaWorklistChooserPanel.this.saveManager != null) {
                    ImageAreaWorklistChooserPanel.this.updateSaveableStatus();
                }
            }
        });
        return jTable;
    }

    protected TableRowSorter<?> createRowSorter(JTable jTable) {
        TableRowSorter tableRowSorter = super.createRowSorter(jTable);
        tableRowSorter.setSortKeys(Arrays.asList(new RowSorter.SortKey((int)Config.impaxee.jvision.Worklists.WorklistChooser.SortedColumn.get(), SortOrder.valueOf(Config.impaxee.jvision.Worklists.WorklistChooser.SortedKey.get()))));
        tableRowSorter.addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent rowSorterEvent) {
                Config.impaxee.jvision.Worklists.WorklistChooser.SortedColumn.set(((RowSorter)rowSorterEvent.getSource()).getSortKeys().get(0).getColumn());
                Config.impaxee.jvision.Worklists.WorklistChooser.SortedKey.set(((RowSorter)rowSorterEvent.getSource()).getSortKeys().get(0).getSortOrder().name());
            }
        });
        return tableRowSorter;
    }

    private void updateSaveableStatus() {
        this.saveManager.updateItems();
    }

    private class ClearSelectionAction
    extends AbstractAction {
        public ClearSelectionAction() {
            super(Messages.getString("WorklistChooser.DeselectAll.Text"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (lastUsedWorklists != null) {
                lastUsedWorklists.clear();
            }
            ImageAreaWorklistChooserPanel.this.setSelectedWorklistContexts(null);
        }
    }

    @FunctionalInterface
    private static interface SessionSaver {
        public boolean save(IHangingSession var1, Collection<IWorklistContext> var2);
    }
}

