/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions.gui;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.HangingUtil;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.snapshot.AbstractSnapshotRuntime;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.impaxee.sessions.gui.ImageAreaWorklistChooserPanel;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.hanging.snapshots.SnapshotController;
import com.tiani.util.message.Message;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.MutableComboBoxModel;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.apache.commons.lang3.StringUtils;

class NewSessionPanel
extends JPanel {
    private static final boolean SAVE_IMMEDIATELY_BY_DEFAULT = NewSessionPanel.isSaveImmediatelyEnabledByDefault();
    private ImageAreaWorklistChooserPanel worklistChooserPanel;
    private JPanel createSessionPanel;
    private JPanel contentPanel;
    private JComboBox<String> comboBoxName;
    private JCheckBox checkBoxSaveImmediately;
    private Session newSession;
    private String automaticallyCreatedSessionName = HangingUtil.createSessionName();
    private final boolean isMultiSnapshotSession;

    NewSessionPanel(IPatientRepresentation iPatientRepresentation, boolean bl) {
        this.newSession = new Session(this.automaticallyCreatedSessionName, iPatientRepresentation, new Date());
        this.isMultiSnapshotSession = bl;
        this.init();
    }

    private static boolean isSaveImmediatelyEnabledByDefault() {
        if (!Product.isRunningAutoTests()) {
            return true;
        }
        String string = System.getProperty("test.session.save.enabled");
        return string != null && Boolean.parseBoolean(string);
    }

    public Session getSession() {
        return this.newSession;
    }

    private void init() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(SwingUtilities2.createEmptyBorder((int)5));
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 0));
        this.worklistChooserPanel = new ImageAreaWorklistChooserPanel(this.newSession.getUserAndScheduledWorklistContexts(), this.newSession, Config.impaxee.jvision.DIALOGS.RememberLastUsedWorklist.get());
        this.createSessionPanel = new JPanel(new BorderLayout());
        this.createSessionPanel.add((Component)((Object)this.worklistChooserPanel), "Center");
        this.contentPanel = new JPanel(new BorderLayout(0, ComponentFactory.instance.scaleInt(5)));
        this.contentPanel.add(this.createSessionPanel);
        List<String> list = this.getPredefinedSessionNames();
        list.add(this.automaticallyCreatedSessionName);
        this.comboBoxName = ComponentFactory.instance.createMultiMonitorComboBox(list.toArray(new String[list.size()]));
        this.comboBoxName.setEditable(true);
        this.comboBoxName.setEditor(new BasicComboBoxEditor(){

            @Override
            public void setItem(Object object) {
                String string = null;
                if (object != null) {
                    string = object.toString().trim();
                }
                super.setItem(string);
            }
        });
        this.comboBoxName.setPreferredSize(this.comboBoxName.getPreferredSize());
        if (this.comboBoxName.getModel() instanceof MutableComboBoxModel) {
            ((MutableComboBoxModel)this.comboBoxName.getModel()).removeElement(this.automaticallyCreatedSessionName);
        }
        this.comboBoxName.getEditor().setItem(this.automaticallyCreatedSessionName);
        this.checkBoxSaveImmediately = ComponentFactory.instance.createCheckBox(Messages.getString("NewSessionPanel.SaveSessionImmediately"), Messages.getString("NewSessionPanel.SaveSessionImmediatelyToolTip"), true);
        this.checkBoxSaveImmediately.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                NewSessionPanel.this.createSessionPanel.setEnabled(NewSessionPanel.this.checkBoxSaveImmediately.isSelected());
            }
        });
        this.checkBoxSaveImmediately.setSelected(SAVE_IMMEDIATELY_BY_DEFAULT);
        jPanel2.add((Component)ComponentFactory.instance.createLabel(String.valueOf(Messages.getString("NewSessionPanel.Name")) + ":"), "West");
        jPanel2.add(this.comboBoxName, "Center");
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        jPanel.add(jPanel2);
        this.contentPanel.add((Component)this.checkBoxSaveImmediately, "North");
        this.add((Component)jPanel, "North");
        this.add((Component)this.contentPanel, "Center");
    }

    public boolean checkSavingIntoSelectedWorklists() {
        if (this.checkBoxSaveImmediately.isSelected()) {
            return this.worklistChooserPanel.checkSavingIntoWorklists(this.worklistChooserPanel.getUpdatedWorklistContexts());
        }
        return true;
    }

    public void createPatientHangingState() {
        Object object = this.comboBoxName.getEditor().getItem();
        if (object == null) {
            Message.error(Messages.getString("NewSessionPanel.ErrorMessageNoName"));
            return;
        }
        String string = object.toString();
        if (string.length() == 0) {
            Message.error(Messages.getString("NewSessionPanel.ErrorMessageNoName"));
            return;
        }
        this.newSession.setVisibleName(string);
        AbstractSnapshotRuntime abstractSnapshotRuntime = this.newSession.getSnapshotModel().newInstance();
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        if (!this.isMultiSnapshotSession || iHanging == null) {
            this.newSession.getSnapshotModel().insertAt(0, abstractSnapshotRuntime);
        } else {
            AbstractSnapshotRuntime abstractSnapshotRuntime2 = DataSelectionManager.getInstance().getActiveSnapshot();
            if (abstractSnapshotRuntime2 != null) {
                abstractSnapshotRuntime.setName(abstractSnapshotRuntime2.getName());
            }
            IHanging.SnapshotModel snapshotModel = iHanging.getSnapshotModel();
            int n = snapshotModel.getSelectedIndex();
            int n2 = 0;
            while (n2 < snapshotModel.size()) {
                SnapshotController.getInstance().selectionActivated(this, n2);
                abstractSnapshotRuntime = this.newSession.getSnapshotModel().newInstance();
                abstractSnapshotRuntime.setName(snapshotModel.get(n2).getName());
                this.newSession.getSnapshotModel().insertAt(n2, abstractSnapshotRuntime);
                ++n2;
            }
            if (n >= 0) {
                iHanging.getSnapshotModel().select(n);
                this.newSession.getSnapshotModel().select(n);
            }
        }
        if (this.checkBoxSaveImmediately.isSelected()) {
            this.worklistChooserPanel.saveReplacementDataAndSession();
        } else {
            this.worklistChooserPanel.saveUnsavedHangings();
        }
    }

    private List<String> getPredefinedSessionNames() {
        String string = Config.impaxee.jvision.HANGMAN.predefinedSessionNames.get();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            String[] stringArray;
            String[] stringArray2 = stringArray = string.split("[\n|\r|\r\n]");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                if (StringUtils.isNotBlank((CharSequence)string2)) {
                    arrayList.add(string2);
                }
                ++n2;
            }
        }
        return arrayList;
    }
}

