/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.setaside;

import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.HangingUtil;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IMultiplePatientHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.snapshot.AbstractSnapshotRuntime;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.impaxee.sessions.SessionStorage;
import com.agfa.pacs.impaxee.setaside.SetAsideLoadedDataState;
import com.agfa.pacs.impaxee.setaside.SetAsidePatientState;
import com.agfa.pacs.impaxee.setaside.SetAsideStudyState;
import com.agfa.pacs.listtext.setaside.ISetAsideData;
import com.agfa.pacs.listtext.setaside.ISetAsideHandler;
import com.agfa.pacs.listtext.setaside.SetAsideDialogException;
import com.agfa.pacs.listtext.setaside.SetAsideState;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.patinfo.DataSelectionManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.Attributes;

public class ImpaxEESetAsideHandler
implements ISetAsideHandler {
    private static final ALogger log = ALogger.getLogger(ImpaxEESetAsideHandler.class);

    public ISetAsideData createEmptyDataContainer() {
        return SetAsideLoadedDataState.createEmptyInstance();
    }

    public void updateState(SetAsideState setAsideState) throws Exception {
        SetAsideLoadedDataState setAsideLoadedDataState = (SetAsideLoadedDataState)setAsideState.getCustomData(SetAsideLoadedDataState.class);
        setAsideLoadedDataState.setSinglePatientBrowsingEnabled(Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.get());
        List<IPatientData> list = DataManager.getInstance().getPatientDatas();
        if (list != null) {
            Map<IPatientRepresentation, Attributes> map = this.createSessionDatasets();
            for (IPatientData iPatientData : list) {
                Object object;
                IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(iPatientData.getKey());
                IPatientRepresentation iPatientRepresentation2 = DataSelectionManager.getInstance().getCurrentPatient();
                IHanging iHanging = iPatientRepresentation.getActiveHanging();
                String string = iPatientData.getKey();
                String string2 = iHanging != null ? iHanging.getIdentifier() : null;
                boolean bl = iPatientRepresentation2 != null && iPatientRepresentation2.getPatientKey().equals(iPatientRepresentation.getPatientKey());
                Attributes attributes = map.get(iPatientRepresentation);
                if (iPatientRepresentation.getActiveHanging() instanceof IMultiplePatientHanging) {
                    object = new SetAsideDialogException("Creating set-aside state info of multi-patient hanging is not supported!");
                    object.setErrorDialogTitle(Messages.getString("SetAside.MultiPatientErrorDialog.Title"));
                    object.setErrorDialogMessage(Messages.getString("SetAside.MultiPatientErrorDialog.Message"));
                    throw object;
                }
                object = new SetAsidePatientState(string, string2, bl);
                Collection<IStudyData> collection = iPatientData.getStudies();
                if (collection != null) {
                    for (IStudyData iStudyData : collection) {
                        IStudyContainer iStudyContainer = iPatientRepresentation.getStudyContainerForStudyKey(iStudyData.getKey());
                        if (iStudyContainer == null) continue;
                        this.addStudy((SetAsidePatientState)object, iStudyContainer.getBaseStudy());
                        int n = 0;
                        while (n < iStudyContainer.getRelevantPriorCount()) {
                            IStudyInfo iStudyInfo = iStudyContainer.getPriorInfo(n);
                            if (iStudyInfo != null) {
                                this.addPriorStudy((SetAsidePatientState)object, iStudyContainer.getBaseStudy(), iStudyInfo);
                            }
                            ++n;
                        }
                    }
                    if (attributes != null) {
                        ((SetAsidePatientState)object).addStudy(SetAsideStudyState.createSessionInstance(attributes.getString(0x20000D), attributes));
                    }
                }
                setAsideLoadedDataState.addLoadedPatient((SetAsidePatientState)object);
            }
        }
    }

    public void applyState(SetAsideState setAsideState) throws Exception {
    }

    public boolean isReadyToUse() {
        return true;
    }

    private void addStudy(SetAsidePatientState setAsidePatientState, IStudyData iStudyData) {
        String string = iStudyData.getKey();
        String string2 = iStudyData.getQueryObject().getSource().getIdentifier().getName();
        if (string2 != null && !"DICOMCACHE".equals(string2)) {
            setAsidePatientState.addStudy(SetAsideStudyState.createInstance(string, string2));
        }
    }

    private void addPriorStudy(SetAsidePatientState setAsidePatientState, IStudyData iStudyData, IStudyInfo iStudyInfo) {
        String string;
        String string2 = iStudyInfo.getKey();
        String string3 = string = iStudyInfo.getSource() != null ? iStudyInfo.getSource().getIdentifier().getName() : "";
        if (string != null && !"DICOMCACHE".equals(string)) {
            setAsidePatientState.addStudy(SetAsideStudyState.createPriorInstance(string2, string, iStudyData.getKey()));
        }
    }

    private Map<IPatientRepresentation, Attributes> createSessionDatasets() throws Exception {
        List<IPatientData> list = DataManager.getInstance().getPatientDatas();
        if (list != null && list.size() > 0) {
            HashMap<IPatientRepresentation, Attributes> hashMap = new HashMap<IPatientRepresentation, Attributes>();
            IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
            if (iPatientRepresentation != null) {
                try {
                    Attributes attributes = this.createSession(iPatientRepresentation);
                    hashMap.put(iPatientRepresentation, attributes);
                }
                catch (Exception exception) {
                    log.warn("Creating set-aside session discarded for '" + iPatientRepresentation + "': " + exception.getMessage());
                }
            }
            return hashMap;
        }
        return Collections.emptyMap();
    }

    private Attributes createSession(IPatientRepresentation iPatientRepresentation) throws Exception {
        IHanging iHanging = iPatientRepresentation.getActiveHanging();
        if (iHanging == null) {
            throw new Exception("Patient has no active hanging!");
        }
        if (iHanging instanceof IMultiplePatientHanging) {
            throw new Exception("Multi-patient session is not supported!");
        }
        Session session = new Session(HangingUtil.createSessionName(), iPatientRepresentation, new Date(), false);
        AbstractSnapshotRuntime abstractSnapshotRuntime = session.getSnapshotModel().newInstance();
        session.getSnapshotModel().insertAt(0, abstractSnapshotRuntime);
        try {
            return new SessionStorage().writeSession(session).getKeyObject().getDicomObject();
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
    }
}

