/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.setaside;

import com.agfa.pacs.impaxee.setaside.SetAsidePatientState;
import com.agfa.pacs.impaxee.setaside.SetAsideStudyState;
import com.agfa.pacs.listtext.setaside.ISetAsideData;
import com.agfa.pacs.listtext.setaside.SetAsideUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dcm4che3.data.Attributes;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SetAsideLoadedDataState
implements ISetAsideData {
    private static final String SESSION_FILE_PREFIX = "set-aside-session-";
    private static final String SESSION_FILE_SUFFIX = ".xml";
    private static final String DATA_FILE_PREFIX = "set-aside-data";
    private static final String DATA_FILE_SUFFIX = ".xml";
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private boolean singlePatientBrowsing;
    private Collection<SetAsidePatientState> loadedPatients = new ArrayList<SetAsidePatientState>();

    private SetAsideLoadedDataState() {
    }

    public static SetAsideLoadedDataState createEmptyInstance() {
        return new SetAsideLoadedDataState();
    }

    public void reset() {
        this.loadedPatients.clear();
        this.singlePatientBrowsing = false;
    }

    public void addLoadedPatient(SetAsidePatientState setAsidePatientState) {
        this.loadedPatients.add(setAsidePatientState);
    }

    public Collection<SetAsidePatientState> getLoadedPatients() {
        return this.loadedPatients;
    }

    public boolean isSinglePatientBrowsingEnabled() {
        return this.singlePatientBrowsing;
    }

    public void setSinglePatientBrowsingEnabled(boolean bl) {
        this.singlePatientBrowsing = bl;
    }

    public Map<ZipEntry, byte[]> toZipEntries(String string, String string2) throws IOException {
        HashMap<ZipEntry, byte[]> hashMap = new HashMap<ZipEntry, byte[]>();
        hashMap.put(this.createDataZipEntry(), this.toXML(string, string2, this.loadedPatients).getBytes(CHARSET));
        for (SetAsidePatientState setAsidePatientState : this.loadedPatients) {
            for (SetAsideStudyState setAsideStudyState : setAsidePatientState.getStudies()) {
                if (!setAsideStudyState.hasSession()) continue;
                ZipEntry zipEntry = this.createSessionZipEntry(setAsideStudyState.getSessionUID());
                byte[] byArray = SetAsideUtils.toXMLAsBytes((Attributes)setAsideStudyState.getSession());
                hashMap.put(zipEntry, byArray);
            }
        }
        return hashMap;
    }

    public void init(Map<ZipEntry, byte[]> map) throws Exception {
        this.loadedPatients.clear();
        if (map != null) {
            Object object;
            Object object2;
            HashMap<String, Attributes> hashMap = new HashMap<String, Attributes>();
            for (Map.Entry<ZipEntry, byte[]> object3 : map.entrySet()) {
                object2 = object3.getKey();
                object = object3.getValue();
                if (this.isSessionZipEntry((ZipEntry)object2)) {
                    Attributes attributes = SetAsideUtils.fromXML((InputStream)new ByteArrayInputStream((byte[])object));
                    hashMap.put(attributes.getString(524312), attributes);
                    continue;
                }
                if (!this.isDataZipEntry((ZipEntry)object2)) continue;
                this.loadedPatients.addAll(this.fromXML((byte[])object));
            }
            for (SetAsidePatientState setAsidePatientState : this.loadedPatients) {
                object = setAsidePatientState.getStudies().iterator();
                while (object.hasNext()) {
                    object2 = (SetAsideStudyState)object.next();
                    if (!((SetAsideStudyState)object2).hasSession()) continue;
                    ((SetAsideStudyState)object2).setSession((Attributes)hashMap.get(((SetAsideStudyState)object2).getSessionUID()));
                }
            }
        }
    }

    private String toXML(String string, String string2, Collection<SetAsidePatientState> collection) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<set-aside ");
        stringBuilder.append(" creation-date=");
        stringBuilder.append("\"" + string2 + "\"");
        stringBuilder.append(" user-id=");
        stringBuilder.append("\"" + string + "\"");
        stringBuilder.append(">");
        stringBuilder.append("<single-patient-browsing>");
        stringBuilder.append(Boolean.toString(this.singlePatientBrowsing));
        stringBuilder.append("</single-patient-browsing>");
        stringBuilder.append("<loaded-data>");
        if (collection != null) {
            for (SetAsidePatientState setAsidePatientState : collection) {
                stringBuilder.append(setAsidePatientState.toXML());
            }
        }
        stringBuilder.append("</loaded-data>");
        stringBuilder.append("</set-aside>");
        return stringBuilder.toString();
    }

    private Collection<SetAsidePatientState> fromXML(byte[] byArray) throws Exception {
        InputSource inputSource = new InputSource(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), CHARSET));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        this.singlePatientBrowsing = Boolean.valueOf(document.getElementsByTagName("single-patient-browsing").item(0).getTextContent());
        NodeList nodeList = document.getElementsByTagName("patient");
        if (nodeList != null && nodeList.getLength() > 0) {
            ArrayList<SetAsidePatientState> arrayList = new ArrayList<SetAsidePatientState>();
            int n = 0;
            while (n < nodeList.getLength()) {
                arrayList.add(SetAsidePatientState.createInstance(nodeList.item(n)));
                ++n;
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private ZipEntry createSessionZipEntry(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SESSION_FILE_PREFIX);
        stringBuilder.append(string);
        stringBuilder.append(".xml");
        return new ZipEntry(stringBuilder.toString());
    }

    private ZipEntry createDataZipEntry() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DATA_FILE_PREFIX);
        stringBuilder.append(".xml");
        return new ZipEntry(stringBuilder.toString());
    }

    private boolean isSessionZipEntry(ZipEntry zipEntry) {
        String string = zipEntry.getName();
        return string.startsWith(SESSION_FILE_PREFIX) && string.endsWith(".xml");
    }

    private boolean isDataZipEntry(ZipEntry zipEntry) {
        String string = zipEntry.getName();
        return string.startsWith(DATA_FILE_PREFIX) && string.endsWith(".xml");
    }
}

