/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.setlive;

import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.plugin.IDisplayPlugin;
import com.agfa.pacs.impaxee.plugin.IPlugin;
import com.agfa.pacs.impaxee.plugin.PluginManager;
import com.agfa.pacs.impaxee.plugin.PluginStarter;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.impaxee.setlive.HangingProtocolSetLiveData;
import com.agfa.pacs.impaxee.setlive.ISetLiveData;
import com.agfa.pacs.impaxee.setlive.ISetLivePlugin;
import com.agfa.pacs.impaxee.setlive.SessionSetLiveData;
import com.agfa.pacs.listtext.dicomobject.type.ImageType;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.ISeriesData;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.ISecondaryCapture;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.SecondaryCapture;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.util.TwoDArrayIterator;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;

public class SetLiveUtil {
    public static final String VERSION = "1.2";
    private static final String IMAGE_TYPE = "SET LIVE";
    private static ALogger log = ALogger.getLogger(SetLiveUtil.class);

    private SetLiveUtil() {
    }

    public static ISetLiveData captureSetLiveData(VisDisplay2 visDisplay2) {
        ISetLivePlugin iSetLivePlugin;
        List<? extends View> list;
        VisDisplayData visDisplayData = visDisplay2.getData();
        IDisplayPlugin iDisplayPlugin = visDisplayData.getDisplayPlugin();
        if (iDisplayPlugin instanceof ISetLivePlugin && (list = (iSetLivePlugin = (ISetLivePlugin)((Object)iDisplayPlugin)).getSetLiveSecondaryCaptureViews()) != null && !list.isEmpty()) {
            View view = list.get(0);
            return new HangingProtocolSetLiveData(SetLiveUtil.getPluginID(visDisplayData), view.getcwidth(), view.getcheight(), iSetLivePlugin.getSetLiveData());
        }
        return null;
    }

    public static IDisplaySet createSecondaryCapture(VisDisplayData visDisplayData, ISetLivePlugin iSetLivePlugin) {
        List<? extends View> list = iSetLivePlugin.getSetLiveSecondaryCaptureViews();
        ArrayList<VisData> arrayList = new ArrayList<VisData>(list.size());
        for (View object2 : list) {
            arrayList.add(object2.getVis());
        }
        SecondaryCapture secondaryCapture = new SecondaryCapture(arrayList, View.OverlayMode.PRINT_OVERLAY_ROI, true);
        secondaryCapture.run();
        Collection<ISeriesData> collection = secondaryCapture.getSeriesData();
        ISeriesData iSeriesData = (ISeriesData)SetLiveUtil.extractSingleElement(visDisplayData, collection);
        if (iSeriesData == null) {
            return null;
        }
        iSeriesData.setSecondaryCapture(ISecondaryCapture.SecondaryCaptureType.SetLive);
        Attributes attributes = iSeriesData.getObjects().get(0).getDicomObject();
        attributes.setString("TIANI", 0x710000, VR.SH, VERSION);
        attributes.setString(524296, VR.CS, new String[]{ImageType.SECONDARY.name(), IMAGE_TYPE, SetLiveUtil.getPluginID(visDisplayData)});
        IFrameObjectData iFrameObjectData = visDisplayData.getDisplaySet().getOneObject();
        attributes.setString("TIANI", 0x710001, VR.UI, iFrameObjectData.getSOPInstanceUID());
        BitSet bitSet = iSetLivePlugin.getSetLiveFrames();
        attributes.setBytes("TIANI", 7405570, VR.OB, SetLiveUtil.serializeBitSet(bitSet));
        Sequence sequence = attributes.newSequence("TIANI", 7405571, 6);
        for (Attributes attributes2 : iSetLivePlugin.getSetLiveData()) {
            sequence.add(attributes2);
        }
        return DataManager.getInstance().addSeriesToDisplay(collection, null);
    }

    private static <T> T extractSingleElement(VisDisplayData visDisplayData, Collection<T> collection) {
        if (collection != null && collection.size() == 1) {
            return collection.iterator().next();
        }
        String string = collection == null || collection.isEmpty() ? "No SetLive secondary captures available." : "Multiple SetLive secondary captures available.";
        SetLiveUtil.notifyCreationFailure(visDisplayData, string);
        return null;
    }

    private static String getPluginID(VisDisplayData visDisplayData) {
        return visDisplayData.getPlugin().getPluginName().getPluginName();
    }

    private static byte[] serializeBitSet(BitSet bitSet) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
                objectOutputStream.writeObject(bitSet);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            log.error("Serializing image references failed.", (Throwable)iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static BitSet deserializeBitSet(byte[] byArray) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));){
                return (BitSet)objectInputStream.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            log.error("Deserializing image references failed.", (Throwable)exception);
            return null;
        }
    }

    private static void notifyCreationFailure(VisDisplayData visDisplayData, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Creating Set Live status failed for ");
        stringBuilder.append(visDisplayData.getVisDisplay().getName());
        stringBuilder.append(". ");
        if (string != null) {
            stringBuilder.append(string);
        }
        log.error(stringBuilder.toString());
    }

    public static boolean isSetLiveCapable(VisDisplay2 visDisplay2) {
        if (!SetLiveUtil.checkPrerequisites(visDisplay2)) {
            return false;
        }
        List<IFrameObjectData> list = visDisplay2.getData().getFrameData();
        if (list != null && !list.isEmpty()) {
            Attributes attributes = list.get(0).getMainFrame().getDicomObject();
            String[] stringArray = attributes.getStrings(524296);
            return SetLiveUtil.isSetLiveSecondaryCapture(stringArray);
        }
        return false;
    }

    private static boolean checkPrerequisites(VisDisplay2 visDisplay2) {
        return visDisplay2 != null && visDisplay2.hasData() && DataSelectionManager.getInstance().getActiveHanging() instanceof Session;
    }

    public static boolean isSetLiveSecondaryCapture(Attributes attributes) {
        return SetLiveUtil.isSetLiveSecondaryCapture(attributes.getStrings(524296));
    }

    private static boolean isSetLiveSecondaryCapture(String[] stringArray) {
        return stringArray != null && stringArray.length >= 3 && ImageType.SECONDARY.name().equalsIgnoreCase(stringArray[0]) && IMAGE_TYPE.equals(stringArray[1]);
    }

    private static SessionSetLiveData extractSetLiveData(VisDisplay2 visDisplay2) {
        if (!SetLiveUtil.checkPrerequisites(visDisplay2)) {
            return null;
        }
        for (IFrameObjectData iFrameObjectData : visDisplay2.getData().getFrameData()) {
            Attributes attributes = iFrameObjectData.getMainFrame().getDicomObject();
            Sequence sequence = attributes.getSequence("TIANI", 7405571);
            String[] stringArray = attributes.getStrings(524296);
            if (sequence == null || !SetLiveUtil.isSetLiveSecondaryCapture(stringArray)) continue;
            return new SessionSetLiveData(stringArray[2], attributes, (List<Attributes>)sequence);
        }
        return null;
    }

    static boolean setLive(VisDisplay2 visDisplay2, boolean bl) {
        SessionSetLiveData sessionSetLiveData = SetLiveUtil.extractSetLiveData(visDisplay2);
        if (visDisplay2 == null || sessionSetLiveData == null) {
            return false;
        }
        return SetLiveUtil.activatePlugin(visDisplay2, sessionSetLiveData, DataSelectionManager.getInstance().getActiveHanging(), bl);
    }

    private static boolean activatePlugin(VisDisplay2 visDisplay2, SessionSetLiveData sessionSetLiveData, IHanging iHanging, boolean bl) {
        byte[] byArray;
        Attributes attributes = sessionSetLiveData.getSecondaryCapture();
        String string = attributes.getString("TIANI", 0x710001, null, null);
        if (string == null) {
            log.error("Reference to original series missing in secondary capture.");
            return false;
        }
        IDisplaySet iDisplaySet = SetLiveUtil.getMatchingDisplaySet(string, iHanging);
        if (iDisplaySet == null) {
            log.error("No matching display set found in current hanging: " + string);
            return false;
        }
        String string2 = sessionSetLiveData.getPluginName();
        IPlugin iPlugin = PluginManager.getPlugin(string2);
        if (iPlugin == null) {
            log.error("Plugin '" + sessionSetLiveData.getPluginName() + "' is unknown.");
            return false;
        }
        try {
            byArray = attributes.getBytes("TIANI", 7405570);
        }
        catch (IOException iOException) {
            log.error("Bulk error", (Throwable)iOException);
            return false;
        }
        visDisplay2.clear(false, true);
        visDisplay2.initVisDisplay(iDisplaySet, 0, true, ActivationMode.HANGUP);
        SetLiveUtil.setSelectionState(visDisplay2, SetLiveUtil.deserializeBitSet(byArray));
        return new SetLivePluginStarter(iPlugin, visDisplay2, sessionSetLiveData, bl).start();
    }

    private static IDisplaySet getMatchingDisplaySet(String string, IHanging iHanging) {
        for (IDisplaySet iDisplaySet : iHanging.getDisplaySets()) {
            for (IFrameObjectData iFrameObjectData : new TwoDArrayIterator<IFrameObjectData>(iDisplaySet.getFrames())) {
                if (!string.equals(iFrameObjectData.getSOPInstanceUID())) continue;
                return iDisplaySet;
            }
        }
        return null;
    }

    private static void setSelectionState(VisDisplay2 visDisplay2, BitSet bitSet) {
        if (bitSet == null) {
            log.error("Retrieving used image frames failed, using all available images.");
            return;
        }
        int n = 0;
        for (VisData visData : visDisplay2.getVis()) {
            visData.setSelected(bitSet.get(n), true);
            ++n;
        }
    }

    public static boolean restorePluginState(VisDisplay2 visDisplay2, ISetLiveData iSetLiveData) {
        if (!visDisplay2.hasData()) {
            log.error("Set Live initialization failed, no data in display.");
            return false;
        }
        if (!(visDisplay2.getData().getDisplayPlugin() instanceof ISetLivePlugin)) {
            log.error("Set Live not supported for " + SetLiveUtil.getPluginID(visDisplay2.getData()));
            return false;
        }
        JVision2.getMainFrame().getPluginToolbox().attachToDisplayOnPluginAutoStart(visDisplay2, visDisplay2.getData().getPlugin());
        return ((ISetLivePlugin)((Object)visDisplay2.getData().getDisplayPlugin())).setLive(iSetLiveData);
    }

    private static class SetLivePluginStarter
    extends PluginStarter {
        private final ISetLiveData data;
        private final boolean isLosslessImageDownloadConfirmationRequired;

        SetLivePluginStarter(IPlugin iPlugin, VisDisplay2 visDisplay2, ISetLiveData iSetLiveData, boolean bl) {
            super(iPlugin, visDisplay2);
            this.data = iSetLiveData;
            this.isLosslessImageDownloadConfirmationRequired = bl;
        }

        @Override
        protected void executeAction() {
            super.executeAction();
            SetLiveUtil.restorePluginState(this.display, this.data);
        }

        @Override
        protected ActivationMode getActivationMode() {
            return ActivationMode.SET_LIVE;
        }

        @Override
        protected boolean queryLosslessImageDownload() {
            if (this.isLosslessImageDownloadConfirmationRequired) {
                return super.queryLosslessImageDownload();
            }
            return true;
        }
    }
}

