/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sortorders.model.xml;

import com.agfa.pacs.base.swing.lists.models.GenericDataMutableListModel;
import com.agfa.pacs.base.swing.twolists.IMutableListModel;
import com.agfa.pacs.impaxee.model.xml.shared.AbstractNamedXMLElement;
import com.agfa.pacs.impaxee.sortorders.model.xml.CustomSortOrderListEntry;
import com.agfa.pacs.logging.ALogger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CustomSortOrder
extends AbstractNamedXMLElement
implements Comparable<CustomSortOrder> {
    private static final ALogger log = ALogger.getLogger(CustomSortOrder.class);
    private List<CustomSortOrderListEntry> customSortOrderListEntries = new ArrayList<CustomSortOrderListEntry>();
    private Integer referenceTag;
    private Map<String, Integer> orderMap = new LinkedHashMap<String, Integer>();
    private Map<Pattern, Integer> compiledOrderMap;
    private IMutableListModel<CustomSortOrderListEntry> listModel;
    private boolean isPatternCompiled = false;
    private static Collator collator = Collator.getInstance();

    static {
        collator.setStrength(0);
    }

    public Integer getReferenceTag() {
        return this.referenceTag;
    }

    public void setReferenceTag(Integer n) {
        this.referenceTag = n;
    }

    public CustomSortOrderListEntry getCustomSortOrderListEntry(int n) {
        if (n >= 0 && n < this.customSortOrderListEntries.size()) {
            return this.customSortOrderListEntries.get(n);
        }
        return null;
    }

    public void addCustomSortOrderListEntry(CustomSortOrderListEntry customSortOrderListEntry) {
        if (customSortOrderListEntry != null && customSortOrderListEntry.getValue() != null) {
            this.customSortOrderListEntries.add(customSortOrderListEntry);
            this.orderMap.put(customSortOrderListEntry.getValue().toUpperCase(Locale.getDefault()), this.orderMap.size());
        }
    }

    public Integer lookupIndex(String string) {
        if (string == null) {
            return null;
        }
        Integer n = this.orderMap.get(string = string.toUpperCase(Locale.getDefault()));
        if (n == null) {
            this.ensurePatternCompiled();
            for (Map.Entry<Pattern, Integer> entry : this.compiledOrderMap.entrySet()) {
                if (!entry.getKey().matcher(string).matches()) continue;
                n = entry.getValue();
                break;
            }
            if (n == null) {
                log.trace("Custom sort order found not matching entry:" + string);
            }
        }
        return n;
    }

    private void ensurePatternCompiled() {
        if (!this.isPatternCompiled) {
            long l = 0L;
            if (log.isDebugEnabled()) {
                l = System.currentTimeMillis();
            }
            this.compiledOrderMap = new LinkedHashMap<Pattern, Integer>();
            for (Map.Entry<String, Integer> entry : this.orderMap.entrySet()) {
                String string = entry.getKey().toUpperCase(Locale.getDefault()).replaceAll("\\*", "\\.\\*");
                string = string.replaceAll("\\?", "\\.");
                this.compiledOrderMap.put(Pattern.compile(string), entry.getValue());
            }
            this.isPatternCompiled = true;
            if (log.isDebugEnabled()) {
                log.debug("Compiling custom order " + this.name + " took " + (System.currentTimeMillis() - l) + "ms");
            }
        }
    }

    @Override
    public int compareTo(CustomSortOrder customSortOrder) {
        if (customSortOrder != null) {
            return collator.compare(this.name, customSortOrder.name);
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (object instanceof CustomSortOrder) {
            return collator.compare(this.name, ((CustomSortOrder)object).name) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public IMutableListModel<CustomSortOrderListEntry> customSortOrderListEntriesListModel() {
        if (this.listModel == null) {
            this.listModel = new GenericDataMutableListModel(this.customSortOrderListEntries);
            this.listModel.addListDataListener(new ListDataListener(){

                @Override
                public void contentsChanged(ListDataEvent listDataEvent) {
                    CustomSortOrder.this.rebuildMap();
                }

                @Override
                public void intervalAdded(ListDataEvent listDataEvent) {
                    CustomSortOrder.this.rebuildMap();
                }

                @Override
                public void intervalRemoved(ListDataEvent listDataEvent) {
                    CustomSortOrder.this.rebuildMap();
                }
            });
        }
        return this.listModel;
    }

    private void rebuildMap() {
        this.orderMap.clear();
        for (CustomSortOrderListEntry customSortOrderListEntry : this.customSortOrderListEntries) {
            this.orderMap.put(customSortOrderListEntry.getValue(), this.orderMap.size());
        }
    }
}

