/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort;

import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.SeparatorPAction;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.AbstractDisplaySetActionProvider;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.impl.HangingFactory;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.impaxee.splitsort.ManualSortSplitProcessor;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeSet;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeSetItem;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeType;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.impaxee.splitsort.model.ManualSplitAndSortPresets;
import com.agfa.pacs.impaxee.splitsort.model.ManualSplitAndSortPresetsType;
import com.agfa.pacs.impaxee.splitsort.model.xml.SplitAndSort;
import com.agfa.pacs.impaxee.splitsort.registry.SplitSortRegistry;
import com.agfa.pacs.impaxee.splitsort.runtime.FrameContainer;
import com.agfa.pacs.security.permission.Permissions;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class ManualSplitAndSortActionProvider
extends AbstractDisplaySetActionProvider {
    @Override
    protected List<PAction> getActions(AbstractDisplaySetActionProvider.IDisplaySetProvider iDisplaySetProvider) {
        ArrayList<PAction> arrayList = new ArrayList<PAction>(2);
        arrayList.add(new ManualSplitSortDisplaySets(iDisplaySetProvider, ManualSplitAndSortPresetsType.IMAGE_SORT));
        arrayList.add(new RevertDisplaySet(iDisplaySetProvider));
        arrayList.add(new Split4DTemporallyAction(iDisplaySetProvider));
        arrayList.add(new ResetSplitAndSortAction(iDisplaySetProvider, ManualSplitAndSortPresetsType.FULL));
        return arrayList;
    }

    public static List<PAction> getSeriesPaletteActions(IDisplaySet iDisplaySet) {
        AbstractDisplaySetActionProvider.FixedDisplaySetProvider fixedDisplaySetProvider = new AbstractDisplaySetActionProvider.FixedDisplaySetProvider(iDisplaySet);
        ManualSplitAndSortPresetsType[] manualSplitAndSortPresetsTypeArray = ManualSplitAndSortPresetsType.values();
        ArrayList<PAction> arrayList = new ArrayList<PAction>(manualSplitAndSortPresetsTypeArray.length + 3);
        ManualSplitAndSortPresetsType[] manualSplitAndSortPresetsTypeArray2 = manualSplitAndSortPresetsTypeArray;
        int n = manualSplitAndSortPresetsTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ManualSplitAndSortPresetsType manualSplitAndSortPresetsType = manualSplitAndSortPresetsTypeArray2[n2];
            arrayList.add(new ManualSplitSortDisplaySets(fixedDisplaySetProvider, manualSplitAndSortPresetsType));
            ++n2;
        }
        arrayList.add(new RevertDisplaySet(fixedDisplaySetProvider));
        if (iDisplaySet != null && iDisplaySet.is4D()) {
            arrayList.add(new Split4DTemporallyAction(fixedDisplaySetProvider));
        }
        arrayList.add(new ResetSplitAndSortAction(fixedDisplaySetProvider, ManualSplitAndSortPresetsType.FULL));
        return arrayList;
    }

    private static abstract class AbstractManualSplitSortAction
    extends AbstractDisplaySetActionProvider.AbstractDisplaySetPAction {
        AbstractManualSplitSortAction(AbstractDisplaySetActionProvider.IDisplaySetProvider iDisplaySetProvider) {
            super(iDisplaySetProvider);
        }

        @Override
        public String getGroupName() {
            return HANGINGS_GROUP;
        }

        @Override
        public boolean isAvailable() {
            if (!Permissions.getInstance().isAllowed("ImageArea/AllowedToDoManualSplitAndSort")) {
                return false;
            }
            return !(DataSelectionManager.getInstance().getActiveHanging() instanceof Session);
        }
    }

    private static abstract class AbstractManualSplitSortDialogAction
    extends AbstractTypedManualSplitSortAction
    implements Runnable {
        AbstractManualSplitSortDialogAction(AbstractDisplaySetActionProvider.IDisplaySetProvider iDisplaySetProvider, ManualSplitAndSortPresetsType manualSplitAndSortPresetsType) {
            super(iDisplaySetProvider, manualSplitAndSortPresetsType);
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed(this.type.getActionID());
            EventQueue.invokeLater(this);
            return true;
        }

        @Override
        public void run() {
            IDisplaySet iDisplaySet = this.provider.getDisplaySet();
            if (iDisplaySet != null) {
                ManualSortSplitProcessor.getInstance().splitAndSortDialog(iDisplaySet, this.type);
            }
        }
    }

    private static abstract class AbstractTypedManualSplitSortAction
    extends AbstractManualSplitSortAction {
        final ManualSplitAndSortPresetsType type;

        AbstractTypedManualSplitSortAction(AbstractDisplaySetActionProvider.IDisplaySetProvider iDisplaySetProvider, ManualSplitAndSortPresetsType manualSplitAndSortPresetsType) {
            super(iDisplaySetProvider);
            this.type = manualSplitAndSortPresetsType;
        }
    }

    private static class ManualSplitSortDialogAction
    extends AbstractManualSplitSortDialogAction {
        ManualSplitSortDialogAction(AbstractDisplaySetActionProvider.IDisplaySetProvider iDisplaySetProvider, ManualSplitAndSortPresetsType manualSplitAndSortPresetsType) {
            super(iDisplaySetProvider, manualSplitAndSortPresetsType);
        }

        @Override
        public String getID() {
            return String.valueOf(this.type.getActionID()) + "_DIALOG";
        }

        @Override
        public String getCaption() {
            return Messages.getString("ManualSplitSortDialogAction.Caption");
        }
    }

    private static class ManualSplitSortDisplaySets
    extends AbstractManualSplitSortDialogAction {
        private final PAction[] subactions = this.createManualSplitAndSortPresetActions();

        ManualSplitSortDisplaySets(AbstractDisplaySetActionProvider.IDisplaySetProvider iDisplaySetProvider, ManualSplitAndSortPresetsType manualSplitAndSortPresetsType) {
            super(iDisplaySetProvider, manualSplitAndSortPresetsType);
        }

        private PAction[] createManualSplitAndSortPresetActions() {
            ManualSplitAndSortPresets manualSplitAndSortPresets = new ManualSplitAndSortPresets(this.type);
            String[] stringArray = manualSplitAndSortPresets.getNames();
            if (stringArray.length == 0) {
                return null;
            }
            PAction[] pActionArray = new PAction[stringArray.length + 2];
            int n = 0;
            while (n < stringArray.length) {
                pActionArray[n] = new ManualSplitSortPresetAction(this.provider, this.type, stringArray[n]);
                ++n;
            }
            pActionArray[pActionArray.length - 2] = new SeparatorPAction();
            pActionArray[pActionArray.length - 1] = new ManualSplitSortDialogAction(this.provider, this.type);
            return pActionArray;
        }

        @Override
        public String getID() {
            return this.type.getActionID();
        }

        @Override
        public String getCaption() {
            return this.type.getCaption();
        }

        @Override
        public PAction.ActionType getActionType() {
            if (this.subactions == null) {
                return PAction.ActionType.None;
            }
            return PAction.ActionType.Submenu;
        }

        @Override
        public PAction[] getSubactions() {
            return this.subactions;
        }
    }

    private static class ManualSplitSortPresetAction
    extends AbstractTypedManualSplitSortAction
    implements Runnable {
        private final String presetName;

        ManualSplitSortPresetAction(AbstractDisplaySetActionProvider.IDisplaySetProvider iDisplaySetProvider, ManualSplitAndSortPresetsType manualSplitAndSortPresetsType, String string) {
            super(iDisplaySetProvider, manualSplitAndSortPresetsType);
            this.presetName = string;
        }

        @Override
        public String getID() {
            return String.valueOf(this.type.getActionID()) + "_PRESET_" + this.presetName;
        }

        @Override
        public String getCaption() {
            return this.presetName;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed(String.valueOf(this.type.getActionID()) + "_PRESET");
            EventQueue.invokeLater(this);
            return true;
        }

        @Override
        public void run() {
            try {
                CursorUtil.setWaitCursor((Component)JVision2.getMainFrame());
                IDisplaySet iDisplaySet = this.provider.getDisplaySet();
                if (iDisplaySet != null) {
                    this.type.applyManualSplitAndSort(iDisplaySet, new ManualSplitAndSortPresets(this.type).loadPreset(this.presetName));
                }
            }
            finally {
                CursorUtil.resetWaitCursor((Component)JVision2.getMainFrame());
            }
        }
    }

    private static class ResetSplitAndSortAction
    extends AbstractManualSplitSortAction {
        ManualSplitAndSortPresetsType type;

        ResetSplitAndSortAction(AbstractDisplaySetActionProvider.IDisplaySetProvider iDisplaySetProvider, ManualSplitAndSortPresetsType manualSplitAndSortPresetsType) {
            super(iDisplaySetProvider);
            this.type = manualSplitAndSortPresetsType;
        }

        @Override
        public String getCaption() {
            return Messages.getString("ResetSplitAndSortAction.Message");
        }

        @Override
        public String getID() {
            return "RESET_SPLIT_AND_SORT";
        }

        @Override
        public boolean perform(Component component) {
            IDisplaySet iDisplaySet = this.provider.getDisplaySet();
            if (iDisplaySet == null) {
                return false;
            }
            SplitAndSort splitAndSort = SplitSortRegistry.getInstance().getSplitAndSort();
            this.type.applyManualSplitAndSort(iDisplaySet, splitAndSort);
            return true;
        }
    }

    private static class RevertDisplaySet
    extends AbstractManualSplitSortAction
    implements ManualSortSplitProcessor.IFrameSorter {
        RevertDisplaySet(AbstractDisplaySetActionProvider.IDisplaySetProvider iDisplaySetProvider) {
            super(iDisplaySetProvider);
        }

        @Override
        public String getCaption() {
            return Messages.getString("DisplaySetLabelPopup.RevertDisplaySet");
        }

        @Override
        public String getID() {
            return "REVERT_DISPLAY_SET";
        }

        @Override
        public boolean perform(Component component) {
            IDisplaySet iDisplaySet = this.provider.getDisplaySet();
            if (iDisplaySet == null) {
                return false;
            }
            this.notifyActionPerformed();
            ManualSortSplitProcessor.getInstance().changeImageSort(iDisplaySet, this);
            return true;
        }

        @Override
        public void sort(IFrameObjectData[] iFrameObjectDataArray) {
            ArrayUtils.reverse((Object[])iFrameObjectDataArray);
        }
    }

    private static class Split4DTemporallyAction
    extends AbstractManualSplitSortAction {
        Split4DTemporallyAction(AbstractDisplaySetActionProvider.IDisplaySetProvider iDisplaySetProvider) {
            super(iDisplaySetProvider);
        }

        @Override
        public String getCaption() {
            return Messages.getString("DisplaySetLabelPopup.Split4D");
        }

        @Override
        public String getID() {
            return "SPLIT_4D";
        }

        @Override
        public boolean perform(Component component) {
            IFrameObjectData[] iFrameObjectDataArray;
            IDisplaySet iDisplaySet = this.provider.getDisplaySet();
            if (iDisplaySet == null) {
                return false;
            }
            this.notifyActionPerformed();
            IFrameObjectData[][] iFrameObjectDataArray2 = iDisplaySet.getFrames();
            ISplitAndSortRuntime iSplitAndSortRuntime = DataSelectionManager.getInstance().getCurrentPatient().getDecompositionRuntime();
            iSplitAndSortRuntime.removeDisplaySet(iDisplaySet, SplitAndSortChangeType.MANUAL_SPLIT_AND_SORT_CHANGE);
            ArrayList<SplitAndSortChangeSetItem> arrayList = new ArrayList<SplitAndSortChangeSetItem>(iFrameObjectDataArray2.length + 1);
            SplitAndSortChangeSetItem splitAndSortChangeSetItem = SplitAndSortChangeSetItem.createRemoveInstance(iDisplaySet);
            arrayList.add(splitAndSortChangeSetItem);
            IFrameObjectData[][] iFrameObjectDataArray3 = iFrameObjectDataArray2;
            int n = iFrameObjectDataArray2.length;
            int n2 = 0;
            while (n2 < n) {
                iFrameObjectDataArray = iFrameObjectDataArray3[n2];
                IDisplaySet iDisplaySet2 = HangingFactory.getInstance().newDisplaySet(new FrameContainer(iFrameObjectDataArray), iSplitAndSortRuntime);
                iSplitAndSortRuntime.addDisplaySet(iDisplaySet2, SplitAndSortChangeType.MANUAL_SPLIT_AND_SORT_CHANGE);
                SplitAndSortChangeSetItem splitAndSortChangeSetItem2 = SplitAndSortChangeSetItem.createAddInstance(iDisplaySet2);
                arrayList.add(splitAndSortChangeSetItem2);
                ++n2;
            }
            iFrameObjectDataArray = new SplitAndSortChangeSet(iSplitAndSortRuntime, SplitAndSortChangeType.MANUAL_SPLIT_AND_SORT_CHANGE, arrayList);
            DataManager.getInstance().applySplitAndSortChange((SplitAndSortChangeSet)iFrameObjectDataArray);
            return true;
        }
    }
}

