/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort;

import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeSetItem;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeType;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SplitAndSortChangeSet {
    private final ISplitAndSortRuntime runtime;
    private final SplitAndSortChangeType type;
    protected List<SplitAndSortChangeSetItem> items;

    public SplitAndSortChangeSet(ISplitAndSortRuntime iSplitAndSortRuntime, SplitAndSortChangeType splitAndSortChangeType, List<SplitAndSortChangeSetItem> list) {
        this.runtime = iSplitAndSortRuntime;
        this.type = splitAndSortChangeType;
        this.items = list;
    }

    public ISplitAndSortRuntime getSplitAndSortRuntime() {
        return this.runtime;
    }

    public SplitAndSortChangeType getType() {
        return this.type;
    }

    public List<IDisplaySet> getDisplaySetsAdded() {
        if (this.items != null) {
            ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>();
            for (SplitAndSortChangeSetItem splitAndSortChangeSetItem : this.items) {
                if (!splitAndSortChangeSetItem.isAdded()) continue;
                arrayList.add(splitAndSortChangeSetItem.getDisplaySet());
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public List<IDisplaySet> getDisplaySetsRemoved() {
        if (this.items != null) {
            ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>();
            for (SplitAndSortChangeSetItem splitAndSortChangeSetItem : this.items) {
                if (!splitAndSortChangeSetItem.isRemoved()) continue;
                arrayList.add(splitAndSortChangeSetItem.getDisplaySet());
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public Map<IDisplaySet, IDisplaySet> getDisplaySetsChanged() {
        if (this.items != null) {
            LinkedHashMap<IDisplaySet, IDisplaySet> linkedHashMap = new LinkedHashMap<IDisplaySet, IDisplaySet>();
            for (SplitAndSortChangeSetItem splitAndSortChangeSetItem : this.items) {
                if (!splitAndSortChangeSetItem.isChanged()) continue;
                linkedHashMap.put(splitAndSortChangeSetItem.getOldDisplaySet(), splitAndSortChangeSetItem.getNewDisplaySet());
            }
            return linkedHashMap;
        }
        return Collections.emptyMap();
    }
}

