/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort;

import com.agfa.pacs.impaxee.attributefilter.AttributeFilterRegistry;
import com.agfa.pacs.impaxee.splitsort.model.xml.AbstractSplitSortField;
import com.agfa.pacs.impaxee.splitsort.model.xml.SortField;
import com.agfa.pacs.impaxee.splitsort.model.xml.SplitField;
import com.agfa.pacs.listtext.lta.base.tagdictionary.DicomTag;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import com.agfa.pacs.listtext.lta.util.StringRepresentationComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class SplitAndSortUtils {
    private static final StringRepresentationComparator splitSortFieldComparator = StringRepresentationComparator.INSTANCE;

    public static List<SortField> getAllSortKeyEntries() {
        DicomTag[] dicomTagArray = TagDictionary.getInstance().getAllTags();
        ArrayList<SortField> arrayList = new ArrayList<SortField>();
        DicomTag[] dicomTagArray2 = dicomTagArray;
        int n = dicomTagArray.length;
        int n2 = 0;
        while (n2 < n) {
            DicomTag dicomTag = dicomTagArray2[n2];
            SortField sortField = new SortField();
            sortField.setTag(dicomTag.getNumber());
            arrayList.add(sortField);
            ++n2;
        }
        return arrayList;
    }

    public static List<SplitField> getAllSplitKeyEntries() {
        DicomTag[] dicomTagArray = TagDictionary.getInstance().getAllTags();
        ArrayList<SplitField> arrayList = new ArrayList<SplitField>();
        DicomTag[] dicomTagArray2 = dicomTagArray;
        int n = dicomTagArray.length;
        int n2 = 0;
        while (n2 < n) {
            DicomTag dicomTag = dicomTagArray2[n2];
            if (dicomTag != null) {
                SplitField splitField = new SplitField();
                splitField.setTag(dicomTag.getNumber());
                arrayList.add(splitField);
            }
            ++n2;
        }
        return arrayList;
    }

    public static List<SortField> getListHangingSortKeys(List<SortField> list) {
        TreeMap<Integer, SortField> treeMap = new TreeMap<Integer, SortField>();
        for (SortField object2 : list) {
            treeMap.put(object2.getTag(), object2);
        }
        Set<DicomTag> set = AttributeFilterRegistry.getInstance().getCFindTags();
        ArrayList arrayList = new ArrayList();
        for (DicomTag dicomTag : set) {
            SortField sortField = (SortField)((Object)treeMap.get(dicomTag.getNumber()));
            if (sortField == null) continue;
            arrayList.add(sortField);
        }
        Collections.sort(arrayList, splitSortFieldComparator);
        return arrayList;
    }

    public static List<SortField> getListHangingSortKeys() {
        Set<DicomTag> set = AttributeFilterRegistry.getInstance().getCFindTags();
        ArrayList<SortField> arrayList = new ArrayList<SortField>();
        for (DicomTag dicomTag : set) {
            SortField sortField = new SortField();
            sortField.setTag(dicomTag.getNumber());
            arrayList.add(sortField);
        }
        Collections.sort(arrayList, splitSortFieldComparator);
        return arrayList;
    }

    public static List<SplitField> getListHangingSplitKeys() {
        Set<DicomTag> set = AttributeFilterRegistry.getInstance().getCFindTags();
        ArrayList<SplitField> arrayList = new ArrayList<SplitField>();
        for (DicomTag dicomTag : set) {
            SplitField splitField = new SplitField();
            splitField.setTag(dicomTag.getNumber());
            arrayList.add(splitField);
        }
        Collections.sort(arrayList, splitSortFieldComparator);
        return arrayList;
    }

    public static List<SplitField> getListHangingSplitKeys(List<SplitField> list) {
        TreeMap<Integer, SplitField> treeMap = new TreeMap<Integer, SplitField>();
        for (SplitField object2 : list) {
            treeMap.put(object2.getTag(), object2);
        }
        Set<DicomTag> set = AttributeFilterRegistry.getInstance().getCFindTags();
        ArrayList arrayList = new ArrayList();
        for (DicomTag dicomTag : set) {
            SplitField splitField = (SplitField)((Object)treeMap.get(dicomTag.getNumber()));
            if (splitField == null) continue;
            arrayList.add(splitField);
        }
        Collections.sort(arrayList, splitSortFieldComparator);
        return arrayList;
    }

    public static void filterSplitFields(List<? extends AbstractSplitSortField> list, List<? extends AbstractSplitSortField> list2) {
        for (AbstractSplitSortField abstractSplitSortField : list2) {
            Integer n = abstractSplitSortField.getTag();
            if (n == null) continue;
            int n2 = 0;
            while (n2 < list.size()) {
                if (list.get(n2).getTag().equals(n)) {
                    list.remove(n2);
                }
                ++n2;
            }
        }
    }
}

