/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort;

import com.agfa.hap.pacs.data.dicom.DataTypeForVR;
import com.agfa.pacs.impaxee.sortorders.model.xml.CustomSortOrder;
import com.agfa.pacs.impaxee.sortorders.registry.CustomSortOrderRegistry;
import com.agfa.pacs.impaxee.splitsort.model.xml.SortField;
import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTagDictionary;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.Orientation;
import java.util.Date;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;

class TagValueComparator {
    private static final ALogger log = ALogger.getLogger(TagValueComparator.class);
    protected final SortField[] sortFields;
    private final int[] intTags;
    protected final DataTypeForVR[] dataTypes;
    private static final int frameNumberTag = PrivateTagDictionary.frameNumber.getNumber();
    private static final int SLICE_ORIENTATION_TAG = PrivateTagDictionary.displaySetOrientation.getNumber();

    protected TagValueComparator(SortField[] sortFieldArray) {
        this.sortFields = sortFieldArray;
        this.intTags = new int[sortFieldArray.length];
        this.dataTypes = new DataTypeForVR[sortFieldArray.length];
        PrivateTagDictionary privateTagDictionary = TagDictionary.getInstance().getPrivateTagDictionary();
        int n = 0;
        while (n < sortFieldArray.length) {
            Integer n2 = sortFieldArray[n].getTag();
            if (n2 != null) {
                this.intTags[n] = n2;
                this.dataTypes[n] = PrivateTagDictionary.isPrivateTag((int)n2) ? DataTypeForVR.getDataType((VR)privateTagDictionary.privateTagForNumber(n2).getVRType()) : DataTypeForVR.getDataType((VR)ElementDictionary.vrOf((int)n2, null));
            } else {
                this.intTags[n] = 0;
            }
            ++n;
        }
    }

    private int compare(Attributes attributes, Attributes attributes2, int n, int n2) {
        SortField sortField = this.sortFields[n];
        if (sortField.getCustomOrderName() != null && sortField.getCustomOrderName().length() > 0) {
            if (CustomSortOrderRegistry.getInstance().containsOrder(sortField.getCustomOrderName())) {
                CustomSortOrder customSortOrder = CustomSortOrderRegistry.getInstance().getOrder(sortField.getCustomOrderName());
                if (this.intTags[n] == 0) {
                    log.warn("missing tag information in sort key... use tag information of custom sort order");
                }
                return this.customOrderCompare(n2 != 0 ? Integer.valueOf(n2) : customSortOrder.getReferenceTag(), attributes, attributes2, sortField);
            }
            log.error("CustomOrdername '" + sortField.getCustomOrderName() + "' not found in config. Fallback to simple alphabetic order.");
            return this.stringCompare(n2, attributes, attributes2);
        }
        if (this.dataTypes[n] == DataTypeForVR.INTEGER) {
            return this.intCompare(n2, attributes, attributes2);
        }
        if (this.dataTypes[n] == DataTypeForVR.FLOAT) {
            return this.doubleCompare(n2, attributes, attributes2);
        }
        if (this.dataTypes[n] == DataTypeForVR.DATE || this.dataTypes[n] == DataTypeForVR.DATETIME || this.dataTypes[n] == DataTypeForVR.TIME) {
            return this.dateCompare(n2, attributes, attributes2);
        }
        return this.stringCompare(n2, attributes, attributes2);
    }

    public int compare(IFrameObjectData iFrameObjectData, IFrameObjectData iFrameObjectData2, int n, int n2) {
        Attributes attributes = null;
        Attributes attributes2 = null;
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            int n5 = this.intTags[n4];
            if (n5 == 2097171) {
                n3 = Integer.compare(iFrameObjectData.getInstanceNumber(), iFrameObjectData2.getInstanceNumber());
            } else if (n5 == frameNumberTag) {
                n3 = Integer.compare(iFrameObjectData.getFrameNumber(), iFrameObjectData2.getFrameNumber());
            } else if (n5 == 2134102 || n5 == 2134312 || n5 == 2134103) {
                n3 = this.comparePerFrameData(iFrameObjectData, iFrameObjectData2, 2134289, n5, n4);
            } else if (n5 == 2134359) {
                n3 = this.comparePerFrameDimensionIndex(iFrameObjectData, iFrameObjectData2);
            } else if (n5 == 5505040 || n5 == 5505056 || n5 == 5505072 || n5 == 5505280 || n5 == 0x540050 || n5 == 5505120 || n5 == 5505136 || n5 == 5505168) {
                n3 = this.compareNMVectors(iFrameObjectData, iFrameObjectData2, n5);
            } else if (PrivateTagDictionary.isPrivateTag((int)n5)) {
                n3 = this.privateTagIntCompare(iFrameObjectData, iFrameObjectData2, n5, this.dataTypes[n4]);
            } else if (n5 == SLICE_ORIENTATION_TAG) {
                n3 = this.sliceOrientationCompare(iFrameObjectData, iFrameObjectData2);
            } else if (n5 == 1609863 && iFrameObjectData.isEnhancedSliceObject()) {
                n3 = this.comparePerFrameData(iFrameObjectData, iFrameObjectData2, 1610007, n5, n4);
            } else {
                if (attributes == null) {
                    attributes = iFrameObjectData.getDicomObject();
                    attributes2 = iFrameObjectData2.getDicomObject();
                }
                n3 = this.compare(attributes, attributes2, n4, n5);
            }
            if (n3 != 0) {
                if (this.sortFields[n4].getIsDescending().booleanValue()) {
                    n3 = -n3;
                }
                return n3;
            }
            ++n4;
        }
        return n3;
    }

    private int compareNMVectors(IFrameObjectData iFrameObjectData, IFrameObjectData iFrameObjectData2, int n) {
        int n2 = iFrameObjectData.getImageInformation().getNMVectorValue(n, iFrameObjectData.getFrameNumber());
        int n3 = iFrameObjectData2.getImageInformation().getNMVectorValue(n, iFrameObjectData2.getFrameNumber());
        if (n2 < 0 || n3 < 0) {
            return 0;
        }
        return n2 < n3 ? -1 : 1;
    }

    private int comparePerFrameDimensionIndex(IFrameObjectData iFrameObjectData, IFrameObjectData iFrameObjectData2) {
        Attributes attributes = this.getPerFrameSubSequence(iFrameObjectData, 2134289);
        Attributes attributes2 = this.getPerFrameSubSequence(iFrameObjectData2, 2134289);
        if (attributes == null || attributes2 == null) {
            return 0;
        }
        int[] nArray = attributes.getInts(2134359);
        int[] nArray2 = attributes2.getInts(2134359);
        if (nArray == null || nArray2 == null) {
            return 0;
        }
        if (nArray.length != nArray2.length) {
            return 0;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != nArray2[n]) {
                return nArray[n] < nArray2[n] ? -1 : 1;
            }
            ++n;
        }
        return 0;
    }

    private Attributes getPerFrameSubSequence(IFrameObjectData iFrameObjectData, int n) {
        Sequence sequence = iFrameObjectData.getPerFrameDicomObject().getSequence(n);
        if (sequence != null && !sequence.isEmpty()) {
            return (Attributes)sequence.get(0);
        }
        return null;
    }

    private int comparePerFrameData(IFrameObjectData iFrameObjectData, IFrameObjectData iFrameObjectData2, int n, int n2, int n3) {
        Attributes attributes = this.getPerFrameSubSequence(iFrameObjectData, n);
        Attributes attributes2 = this.getPerFrameSubSequence(iFrameObjectData2, n);
        if (attributes == null || attributes2 == null) {
            return 0;
        }
        return this.compare(attributes, attributes2, n3, n2);
    }

    private int privateTagIntCompare(IFrameObjectData iFrameObjectData, IFrameObjectData iFrameObjectData2, int n, DataTypeForVR dataTypeForVR) {
        String string = iFrameObjectData.resolveString(n);
        String string2 = iFrameObjectData2.resolveString(n);
        return this.stringCompare(string, string2, dataTypeForVR);
    }

    protected int stringCompare(String string, String string2, DataTypeForVR dataTypeForVR) {
        if (dataTypeForVR == DataTypeForVR.INTEGER) {
            try {
                return Integer.compare(Integer.parseInt(string), Integer.parseInt(string2));
            }
            catch (Exception exception) {
                return CompareUtils.compareAdvanced((Comparable)((Object)string), (Comparable)((Object)string2));
            }
        }
        return CompareUtils.compareAdvanced((Comparable)((Object)string), (Comparable)((Object)string2));
    }

    private int sliceOrientationCompare(IFrameObjectData iFrameObjectData, IFrameObjectData iFrameObjectData2) {
        return CompareUtils.compareAdvanced((Comparable)((Object)this.getSliceOrientationString(iFrameObjectData)), (Comparable)((Object)this.getSliceOrientationString(iFrameObjectData2)));
    }

    private String getSliceOrientationString(IFrameObjectData iFrameObjectData) {
        Orientation orientation = Orientation.getOrientation(iFrameObjectData.getImageInformation());
        if (orientation == null) {
            return null;
        }
        return orientation.toString();
    }

    private int stringCompare(Integer n, Attributes attributes, Attributes attributes2) {
        String string = attributes.getString(n.intValue());
        String string2 = attributes2.getString(n.intValue());
        return CompareUtils.compareAdvanced((Comparable)((Object)string), (Comparable)((Object)string2));
    }

    private int customOrderCompare(Integer n, Attributes attributes, Attributes attributes2, SortField sortField) {
        String string;
        int n2 = n != null ? n.intValue() : sortField.getTag().intValue();
        String string2 = attributes.getString(n2);
        if (CompareUtils.equals((Object)string2, (Object)(string = attributes2.getString(n2)))) {
            return 0;
        }
        String string3 = sortField.getCustomOrderName();
        CustomSortOrder customSortOrder = CustomSortOrderRegistry.getInstance().getOrder(string3);
        Integer n3 = customSortOrder.lookupIndex(string2);
        Integer n4 = customSortOrder.lookupIndex(string);
        return CompareUtils.compareAdvanced((Comparable)n3, (Comparable)n4);
    }

    private int intCompare(Integer n, Attributes attributes, Attributes attributes2) {
        int n2;
        int n3 = attributes.getInt(n.intValue(), 0);
        return n3 == (n2 = attributes2.getInt(n.intValue(), 0)) ? 0 : (n3 < n2 ? -1 : 1);
    }

    private int doubleCompare(Integer n, Attributes attributes, Attributes attributes2) {
        try {
            return Double.compare(attributes.getDouble(n.intValue(), 0.0), attributes2.getDouble(n.intValue(), 0.0));
        }
        catch (Exception exception) {
            log.error("Error on double parsing", (Throwable)exception);
            return 0;
        }
    }

    private int dateCompare(Integer n, Attributes attributes, Attributes attributes2) {
        Date date;
        Date date2;
        try {
            date2 = attributes.getDate(n.intValue());
        }
        catch (Exception exception) {
            date2 = null;
        }
        try {
            date = attributes2.getDate(n.intValue());
        }
        catch (Exception exception) {
            date = null;
        }
        return CompareUtils.compareAdvanced((Comparable)date2, (Comparable)date);
    }
}

