/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort.gui;

import com.agfa.pacs.base.swing.twolists.IFilter;
import com.agfa.pacs.base.swing.twolists.IListItemEditor;
import com.agfa.pacs.base.swing.twolists.IncludeConcreteItemsFilter;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortUtils;
import com.agfa.pacs.impaxee.splitsort.gui.EditSortCriterionPanel;
import com.agfa.pacs.impaxee.splitsort.gui.EditSplitSortFieldPanel;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.impaxee.splitsort.model.ManualSplitAndSortPresetsType;
import com.agfa.pacs.impaxee.splitsort.model.xml.AbstractConditionalCriterion;
import com.agfa.pacs.impaxee.splitsort.model.xml.AbstractConditionalSortCriterion;
import com.agfa.pacs.impaxee.splitsort.model.xml.AbstractSplitSortField;
import com.agfa.pacs.impaxee.splitsort.model.xml.ConditionalSortDisplaySetsCriterion;
import com.agfa.pacs.impaxee.splitsort.model.xml.ConditionalSortImagesCriterion;
import com.agfa.pacs.impaxee.splitsort.model.xml.ConditionalSplitCriterion;
import com.agfa.pacs.impaxee.splitsort.model.xml.SortField;
import com.agfa.pacs.impaxee.splitsort.model.xml.SplitAndSort;
import com.agfa.pacs.impaxee.splitsort.model.xml.SplitField;
import com.agfa.pacs.impaxee.splitsort.runtime.ConditionalSplitAndSortRuntime;
import com.agfa.pacs.impaxee.splitsort.runtime.SplitAndSortEngine;
import com.agfa.pacs.listtext.swingx.controls.taskpane.JTaskPane;
import com.agfa.pacs.listtext.swingx.controls.taskpane.TaskPaneTab;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SplitAndSortPanel
extends JPanel {
    private List<SplitField> listSplitKeysAvailable;
    private List<SplitField> listSplitKeysUsed;
    private List<SortField> listSortKeysSeriesAvailable;
    private List<SortField> listSortKeysSeriesUsed;
    private List<SortField> listSortKeysImagesAvailable;
    private List<SortField> listSortKeysImagesUsed;
    private EditSplitSortFieldPanel<SplitField> twoListsSplitKeys;
    private EditSplitSortFieldPanel<SortField> twoListsSortKeysSeries;
    private EditSplitSortFieldPanel<SortField> twoListsSortKeysImages;
    private JCheckBox checkBoxTagsForHangingOnly;
    private IFilter<SplitField> filterSplitKeys;
    private IFilter<SortField> filterSortDSKeys;
    private IFilter<SortField> filterSortImagesKeys;
    private final ManualSplitAndSortPresetsType type;

    public SplitAndSortPanel(SplitAndSort splitAndSort, ISplitAndSortRuntime iSplitAndSortRuntime, ManualSplitAndSortPresetsType manualSplitAndSortPresetsType) {
        this.type = manualSplitAndSortPresetsType;
        this.init(splitAndSort, iSplitAndSortRuntime);
    }

    void init(SplitAndSort splitAndSort, ISplitAndSortRuntime iSplitAndSortRuntime) {
        Object object;
        TaskPaneTab taskPaneTab;
        ConditionalSplitCriterion conditionalSplitCriterion;
        this.removeAll();
        this.setLayout(new BorderLayout());
        JTaskPane jTaskPane = ComponentFactory.instance.createTaskPane(true, false);
        this.listSplitKeysAvailable = SplitAndSortUtils.getAllSplitKeyEntries();
        this.listSortKeysSeriesAvailable = SplitAndSortUtils.getAllSortKeyEntries();
        this.listSortKeysImagesAvailable = SplitAndSortUtils.getAllSortKeyEntries();
        this.filterSplitKeys = new IncludeConcreteItemsFilter(SplitAndSortUtils.getListHangingSplitKeys(this.listSplitKeysAvailable));
        this.filterSortDSKeys = new IncludeConcreteItemsFilter(SplitAndSortUtils.getListHangingSortKeys(this.listSortKeysSeriesAvailable));
        this.filterSortImagesKeys = new IncludeConcreteItemsFilter(SplitAndSortUtils.getListHangingSortKeys(this.listSortKeysImagesAvailable));
        if (splitAndSort != null) {
            conditionalSplitCriterion = splitAndSort.getConditionalSplitCriterion(0);
            this.listSplitKeysUsed = conditionalSplitCriterion != null ? new ArrayList<SplitField>(conditionalSplitCriterion.splitFields()) : new ArrayList<SplitField>();
            SplitAndSortUtils.filterSplitFields(this.listSplitKeysAvailable, this.listSplitKeysUsed);
            taskPaneTab = splitAndSort.getConditionalSortDisplaySetsCriterion(0);
            this.listSortKeysSeriesUsed = taskPaneTab != null ? new ArrayList<SortField>(taskPaneTab.sortFields()) : new ArrayList<SortField>();
            SplitAndSortUtils.filterSplitFields(this.listSortKeysSeriesAvailable, this.listSortKeysSeriesUsed);
            object = splitAndSort.getConditionalSortImagesCriterion(0);
            this.listSortKeysImagesUsed = object != null ? new ArrayList<SortField>(((AbstractConditionalSortCriterion)object).sortFields()) : new ArrayList<SortField>();
            SplitAndSortUtils.filterSplitFields(this.listSortKeysImagesAvailable, this.listSortKeysImagesUsed);
        } else {
            this.listSplitKeysUsed = new ArrayList<SplitField>();
            this.listSortKeysSeriesUsed = new ArrayList<SortField>();
            this.listSortKeysImagesUsed = new ArrayList<SortField>();
        }
        if (iSplitAndSortRuntime != null && iSplitAndSortRuntime instanceof ConditionalSplitAndSortRuntime) {
            conditionalSplitCriterion = SplitAndSortEngine.getInstance().determineSplitTags(iSplitAndSortRuntime.getDisplaySetAt(0).getOneObject().getMainFrame().getParent());
            int n = 0;
            while (n < conditionalSplitCriterion.size()) {
                object = new SplitField();
                ((AbstractSplitSortField)((Object)object)).setTag(conditionalSplitCriterion.get(n));
                this.listSplitKeysUsed.add((SplitField)((Object)object));
                ++n;
            }
            taskPaneTab = this.cloneFields(SplitAndSortEngine.getInstance().getImageSortTags(iSplitAndSortRuntime.getDisplaySetAt(0).getOneObject()));
            this.listSortKeysImagesUsed.addAll((Collection<SortField>)taskPaneTab);
            taskPaneTab = this.cloneFields(SplitAndSortEngine.getInstance().getDSSortTags(iSplitAndSortRuntime.getDisplaySetAt(0).getOneObject()));
            this.listSortKeysSeriesUsed.addAll((Collection<SortField>)taskPaneTab);
        }
        boolean bl = true;
        this.twoListsSplitKeys = new EditSplitSortFieldPanel<SplitField>(this.listSplitKeysAvailable, this.listSplitKeysUsed, null, "", ComponentFactory.instance);
        taskPaneTab = this.createTaskPaneTab(Messages.getString("SPLIT_AND_SORT_DLG_SPLIT"), this.twoListsSplitKeys);
        if (this.type.isSplitEnabled()) {
            taskPaneTab.setExpanded(bl);
            jTaskPane.addTab(taskPaneTab, JTaskPane.TabConstraint.MAXIMIZED);
            bl = false;
        }
        this.twoListsSortKeysSeries = new EditSplitSortFieldPanel<SortField>(this.listSortKeysSeriesAvailable, this.listSortKeysSeriesUsed, (IListItemEditor<SortField>)new EditSortCriterionPanel(ComponentFactory.instance), "", ComponentFactory.instance);
        taskPaneTab = this.createTaskPaneTab(Messages.getString("SPLIT_AND_SORT_DLG_SORTSEQ"), this.twoListsSortKeysSeries);
        if (this.type.isSeriesSortEnabled()) {
            taskPaneTab.setExpanded(bl);
            jTaskPane.addTab(taskPaneTab, JTaskPane.TabConstraint.MAXIMIZED);
            bl = false;
        }
        jTaskPane.setAutoscrolls(true);
        this.twoListsSortKeysImages = new EditSplitSortFieldPanel<SortField>(this.listSortKeysImagesAvailable, this.listSortKeysImagesUsed, (IListItemEditor<SortField>)new EditSortCriterionPanel(ComponentFactory.instance), "", ComponentFactory.instance);
        taskPaneTab = this.createTaskPaneTab(Messages.getString("SPLIT_AND_SORT_DLG_SORTOBJ"), this.twoListsSortKeysImages);
        if (this.type.isImageSortEnabled()) {
            taskPaneTab.setExpanded(bl);
            jTaskPane.addTab(taskPaneTab, JTaskPane.TabConstraint.MAXIMIZED);
        }
        this.add((Component)jTaskPane, "Center");
        this.checkBoxTagsForHangingOnly = ComponentFactory.instance.createCheckBox(Messages.getString("NewSortSplitKeyDialog.ShowOnlyHangingTags"));
        this.checkBoxTagsForHangingOnly.setSelected(false);
        this.checkBoxTagsForHangingOnly.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (SplitAndSortPanel.this.checkBoxTagsForHangingOnly.isSelected()) {
                    SplitAndSortPanel.this.twoListsSplitKeys.setFilter(SplitAndSortPanel.this.filterSplitKeys);
                    SplitAndSortPanel.this.twoListsSortKeysImages.setFilter(SplitAndSortPanel.this.filterSortImagesKeys);
                    SplitAndSortPanel.this.twoListsSortKeysSeries.setFilter(SplitAndSortPanel.this.filterSortDSKeys);
                } else {
                    SplitAndSortPanel.this.twoListsSplitKeys.setFilter(null);
                    SplitAndSortPanel.this.twoListsSortKeysImages.setFilter(null);
                    SplitAndSortPanel.this.twoListsSortKeysSeries.setFilter(null);
                }
            }
        });
        this.add((Component)this.checkBoxTagsForHangingOnly, "South");
    }

    private List<SortField> cloneFields(List<SortField> list) {
        ArrayList<SortField> arrayList = new ArrayList<SortField>(list.size());
        for (SortField sortField : list) {
            arrayList.add(SortField.clone(sortField));
        }
        return arrayList;
    }

    SplitAndSort getDecomposition() {
        AbstractConditionalCriterion abstractConditionalCriterion;
        if (!this.isComplete()) {
            return null;
        }
        SplitAndSort splitAndSort = new SplitAndSort();
        if (this.type.isSplitEnabled()) {
            abstractConditionalCriterion = new ConditionalSplitCriterion();
            for (SplitField abstractSplitSortField : this.listSplitKeysUsed) {
                ((ConditionalSplitCriterion)abstractConditionalCriterion).addSplitField(abstractSplitSortField);
            }
            splitAndSort.addConditionalSplitCriterion((ConditionalSplitCriterion)abstractConditionalCriterion);
        }
        if (this.type.isSeriesSortEnabled()) {
            abstractConditionalCriterion = new ConditionalSortDisplaySetsCriterion();
            for (SortField sortField : this.listSortKeysSeriesUsed) {
                ((AbstractConditionalSortCriterion)abstractConditionalCriterion).addSortField(sortField);
            }
            splitAndSort.addConditionalSortDisplaySetsCriterion((ConditionalSortDisplaySetsCriterion)abstractConditionalCriterion);
        }
        if (this.type.isImageSortEnabled()) {
            abstractConditionalCriterion = new ConditionalSortImagesCriterion();
            for (SortField sortField : this.listSortKeysImagesUsed) {
                ((AbstractConditionalSortCriterion)abstractConditionalCriterion).addSortField(sortField);
            }
            splitAndSort.addConditionalSortImagesCriterion((ConditionalSortImagesCriterion)abstractConditionalCriterion);
        }
        return splitAndSort;
    }

    private boolean isComplete() {
        return !(this.type.isSplitEnabled() && this.listSplitKeysUsed.isEmpty() || this.type.isSeriesSortEnabled() && this.listSortKeysSeriesUsed.isEmpty() || this.type.isImageSortEnabled() && this.listSortKeysImagesUsed.isEmpty());
    }

    private TaskPaneTab createTaskPaneTab(String string, JComponent jComponent) {
        TaskPaneTab taskPaneTab = ComponentFactory.instance.createTaskPaneTab(string, jComponent);
        taskPaneTab.setPrimaryHeaderColor(ColorUtils.getPrimary2());
        taskPaneTab.setSecondaryHeaderColor(ColorUtils.getPrimary4());
        return taskPaneTab;
    }
}

